/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.operations.MoveToResolveConflictOperation;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentConflictUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.ui.changes.dialogs.MoveConflictedItemsDialog;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnMoveUser;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class MoveConflictedItemAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        List conflictItems = selection.toList();
        MoveConflictedItemsDialog dialog = new MoveConflictedItemsDialog(shell, conflictItems);
        if (dialog.open() != 0) {
            return;
        }
        final MoveToResolveConflictOperation op = dialog.getMoveOperation(new WarnMoveUser(shell, Messages.MoveConflictedItemAction_0, Messages.MoveConflictedItemAction_1));
        this.getOperationRunner().enqueue(Messages.MoveConflictedItemAction_2, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                op.run(monitor);
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        Set[] result = ComponentSyncUtil.filter((Collection)((IStructuredSelection)selection).toList(), (Class[])new Class[]{IConflictItem.class, Object.class});
        boolean enable = false;
        if (result[1].isEmpty()) {
            for (IConflictItem conflictItem : result[0]) {
                ILogicalChange logicalChange = conflictItem.getLogicalChange();
                if (!ComponentConflictUtil.isStructuralChange((ILogicalChange)logicalChange) || logicalChange.isChangeType(2)) {
                    enable = false;
                    break;
                }
                IItemConflictReport itemConflictReport = conflictItem.getItemConflictReport();
                if (itemConflictReport != null && itemConflictReport.getProposedContributorState() == null && itemConflictReport.getSelectedContributorState() == null) {
                    enable = false;
                    break;
                }
                enable = true;
            }
        }
        action.setEnabled(enable);
    }
}

