/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IMarkAsMergedOperation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.operations.MoveToResolveConflictOperation;
import com.ibm.team.filesystem.client.operations.MarkAsMergedDilemmaHandler;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.DetailsDialog;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.ListDetailsDialog;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentConflictUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedFolder;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnResolveAsMergedUser;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.changes.actions.ResolveWithMineAction;
import com.ibm.team.filesystem.ui.changes.dialogs.MoveConflictedItemsDialog;
import com.ibm.team.filesystem.ui.changes.views.LocalSynchronizeDecorator;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesViewLabelProvider;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnMoveUser;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.IWorkspaceConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class MarkAsMergedAction
extends AbstractActionDelegate {
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        IStructuredSelection ss = (IStructuredSelection)selection;
        Set[] filtered = ComponentSyncUtil.filter((Collection)ss.toList(), (Class[])new Class[]{IConflictItem.class, ILocalConflictItem.class});
        Set wscs = ComponentSyncUtil.getWorkspaceContexts((Collection)filtered[0]);
        wscs.addAll(ComponentSyncUtil.getWorkspaceContexts((Collection)filtered[1]));
        action.setEnabled(wscs.size() == 1);
    }

    private void performResolve(ILogicalConflictReport conflictReport, Collection<IConflictItem> conflicts, IWorkspaceConnection wc, MarkAsMergedDilemmaHandler problemHandler, SubMonitor progress) throws FileSystemException, TeamRepositoryException {
        Collection changes = ComponentConflictUtil.getChanges(conflicts);
        if (!changes.isEmpty()) {
            IMarkAsMergedOperation mergedOp = IOperationFactory.instance.getMarkAsMergedOperation(problemHandler);
            mergedOp.setContext(wc, conflictReport);
            mergedOp.addChangesToResolve(changes);
            mergedOp.run((IProgressMonitor)progress);
        }
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        this.doRun(this.getContext(), selection);
    }

    private void doRun(UIContext context, IStructuredSelection selection) {
        Shell shell = context.getShell();
        IOperationRunner operationRunner = context.getUserOperationRunner();
        Set[] filtered = ComponentSyncUtil.filter((Collection)selection.toList(), (Class[])new Class[]{IConflictItem.class, ILocalConflictItem.class});
        Set conflictItems = filtered[0];
        Set localConflictItems = filtered[1];
        if (!conflictItems.isEmpty() && !localConflictItems.isEmpty()) {
            DialogUtil.pauseIfNeededBeforeShowingDialog();
            int code = JFaceUtils.showMessageButtonsBlocking((String)Messages.ResolveAsMerged_0, (String)Messages.ResolveAction_description, (String[])new String[]{Messages.ResolveAction_LocalConflict, Messages.ResolveAction_RemoteConflict, Messages.PreferencesListener_14}, (int)4, (int)2);
            switch (code) {
                case 0: {
                    ResolveWithMineAction.resolveWithMineLocalConflicts(shell, operationRunner, localConflictItems);
                    break;
                }
                case 1: {
                    this.resolveAsMergedConflicts(shell, operationRunner, conflictItems);
                }
            }
            return;
        }
        if (!conflictItems.isEmpty()) {
            this.resolveAsMergedConflicts(shell, operationRunner, conflictItems);
        }
        ResolveWithMineAction.resolveWithMineLocalConflicts(shell, operationRunner, localConflictItems);
    }

    private void resolveAsMergedConflicts(final Shell shell, IOperationRunner runner, final Collection<IConflictItem> conflictItems) {
        runner.enqueue(Messages.MarkAsMergedAction_ResovlveAsMergedJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MarkAsMergedAction_ResolvingMergedProgressName, (int)100);
                if (conflictItems.size() > 0) {
                    IConflictItem conflictItem = (IConflictItem)conflictItems.iterator().next();
                    IComponentSyncContext context = conflictItem.getOutgoingActivitySource().getModel();
                    IWorkspaceConnection wc = context.getOutgoingTeamPlace();
                    ILogicalConflictReport conflictReport = context.getLogicalConflictReport();
                    progress.setWorkRemaining(100);
                    if (!MarkAsMergedAction.this.resolveRequiredConflicts(shell, conflictItems, (IProgressMonitor)progress.newChild(30))) {
                        return;
                    }
                    WarnResolveAsMergedUser problemHandler = new WarnResolveAsMergedUser(shell, Messages.MarkAsMergedAction_ResolveAsMergedTitle){

                        public int confirmMarkAsMerged(final Collection<ILogicalChange> changes) {
                            final int[] result = new int[]{1};
                            Display display = PlatformUI.getWorkbench().getDisplay();
                            display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ListDetailsDialog dialog = new ListDetailsDialog(shell, Messages.MarkAsMergedAction_ConfirmResolveAsMergedTitle, Messages.MarkAsMergedAction_ConfirmOverwriteMessage, 4, DetailsDialog.ButtonBar.YesNoDetails, changes);
                                    dialog.setDefaultButtonId(3);
                                    dialog.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new LocalWorkspaceChangesViewLabelProvider(false), (ILabelDecorator)new LocalSynchronizeDecorator(false)));
                                    dialog.create();
                                    result[0] = dialog.open() == 2 ? 0 : 1;
                                }
                            });
                            return result[0];
                        }
                    };
                    problemHandler.setAllowUnmerged(false);
                    MarkAsMergedAction.this.performResolve(conflictReport, conflictItems, wc, (MarkAsMergedDilemmaHandler)problemHandler, progress.newChild(30));
                }
            }
        });
    }

    private boolean resolveRequiredConflicts(final Shell shell, Collection<IConflictItem> conflictItems, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        final ArrayList<IConflictItem> required = new ArrayList<IConflictItem>();
        for (IConflictItem conflictItem : conflictItems) {
            IUnresolvedFolder folder = ComponentSyncUtil.findParent((IConflictItem)conflictItem);
            if (!folder.isCompoundConflict(conflictItem)) continue;
            required.add(conflictItem);
        }
        if (!required.isEmpty()) {
            final MoveToResolveConflictOperation[] op = new MoveToResolveConflictOperation[1];
            shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    MoveConflictedItemsDialog dialog = new MoveConflictedItemsDialog(shell, required);
                    if (dialog.open() != 0) {
                        return;
                    }
                    op[0] = dialog.getMoveOperation(new WarnMoveUser(shell, Messages.MarkAsMergedAction_MoveConflictedItemTitle, Messages.MarkAsMergedAction_MoveConflictedItemMessage));
                }
            });
            if (op[0] == null) {
                return false;
            }
            op[0].run(monitor);
        }
        return true;
    }

    static Shell getActiveShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        return window != null ? window.getShell() : null;
    }
}

