/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.operations.ILockOperation;
import com.ibm.team.filesystem.client.operations.LockDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.FolderItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.LockConfirmationHandlerForVersionable;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentComponentInfo;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class LockAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, final IStructuredSelection selection) {
        this.getOperationRunner().enqueue(Messages.LockAction_0, (Operation)new RepositoryOperation(ComponentSyncUtil.getTeamRepositories((Collection)selection.toList())){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                IComponentSyncContext context;
                IVersionableHandle versionableHandle;
                ILockOperation lockOperation = IOperationFactory.instance.getLockOperation((LockDilemmaHandler)new LockConfirmationHandlerForVersionable());
                Set[] result = ComponentSyncUtil.filter((Collection)selection.toList(), (Class[])new Class[]{IRemoteChangeSummary.class, ILocalChange.class});
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)((result[0].size() + result[1].size()) * 10));
                for (Object o : result[0]) {
                    if (!(o instanceof IRemoteChangeSummary)) continue;
                    IRemoteChangeSummary rcs = (IRemoteChangeSummary)o;
                    versionableHandle = rcs.getItem();
                    context = ComponentSyncUtil.getContext((Object)rcs);
                    lockOperation = LockAction.getLockOperation(context, versionableHandle, lockOperation, problems, (IProgressMonitor)sub.newChild(1));
                }
                for (Object o : result[1]) {
                    if (!(o instanceof ILocalChange)) continue;
                    ILocalChange localChange = (ILocalChange)o;
                    versionableHandle = localChange.getTarget();
                    context = ComponentSyncUtil.getContext((IComponentSyncModel)FileSystemResourcesPlugin.getComponentSyncModel(), (ILocalChange)localChange);
                    lockOperation = LockAction.getLockOperation(context, versionableHandle, lockOperation, problems, (IProgressMonitor)sub.newChild(1));
                }
                if (lockOperation != null) {
                    lockOperation.run((IProgressMonitor)sub.newChild((result[0].size() + result[1].size()) * 9));
                }
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(LockAction.containsOnlyFiles(((IStructuredSelection)selection).toList()));
    }

    public static boolean containsOnlyFiles(Collection selection) {
        Set[] result = ComponentSyncUtil.filter((Collection)selection, (Class[])new Class[]{IRemoteChangeSummary.class, ILocalChange.class, AbstractFileSystemItemWrapper.class});
        for (Object o : result[0]) {
            IRemoteChangeSummary rcs;
            if (!(o instanceof IRemoteChangeSummary) || !((rcs = (IRemoteChangeSummary)o).getItem() instanceof IFolderHandle)) continue;
            return false;
        }
        for (Object o : result[1]) {
            ILocalChange localChange;
            if (!(o instanceof ILocalChange) || !((localChange = (ILocalChange)o).getTarget() instanceof IFolderHandle)) continue;
            return false;
        }
        for (Object o : result[2]) {
            if (!(o instanceof FolderItemWrapper)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ILockOperation getLockOperation(IComponentSyncContext context, IVersionableHandle versionableHandle, ILockOperation operation, IStatusCollector problems, IProgressMonitor monitor) throws TeamRepositoryException {
        ILockOperation lockOperation = operation;
        if (context == null) return lockOperation;
        IWorkspaceConnection deliverTarget = context.getRemoteOutgoingTeamPlace();
        if (deliverTarget != null && deliverTarget.isStream()) {
            if (LockAction.hasComponent(deliverTarget, context.getComponent())) {
                ItemNamespace targetNamespace = ItemNamespace.getNamespace((IConnection)deliverTarget, (IComponentHandle)context.getComponent());
                ItemNamespace sourceNamespace = ItemNamespace.getNamespace((IConnection)context.getOutgoingConnection(), (IComponentHandle)context.getComponent());
                return com.ibm.team.filesystem.ide.ui.internal.actions.file.LockAction.lock(lockOperation, versionableHandle, targetNamespace, sourceNamespace, monitor, problems);
            }
            problems.reportProblem(FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.LockAction_6));
            return null;
        }
        problems.reportProblem(FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.LockAction_3));
        return null;
    }

    private static boolean hasComponent(IWorkspaceConnection connection, IComponent component) {
        try {
            ICurrentComponentInfo info = connection.getComponentInfo((IComponentHandle)component);
            if (info != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

