/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChange;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.OutgoingChangeSummaryNode;
import com.ibm.team.filesystem.rcp.core.operations.IgnoreOperation;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;

public class IgnorePendingChangeAction
extends AbstractActionDelegate {
    private Set selection = new HashSet();
    private Shell parent;

    public void init(IViewPart view) {
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection sel) {
        if (this.selection.size() < 1) {
            return;
        }
        this.parent = shell;
        if (!this.confirmIgnore()) {
            return;
        }
        new Job(Messages.IgnorePendingChangeAction_3){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    return IgnorePendingChangeAction.this.ignoreChange(monitor);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    return new Status(4, "com.ibm.team.filesystem.ide.ui", Messages.IgnorePendingChangeAction_4, (Throwable)e);
                }
            }
        }.schedule();
    }

    private boolean confirmIgnore() {
        boolean confirmIgnore = true;
        IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
        boolean prompt = store.getBoolean("warn_ignore_changed_resource");
        if (prompt) {
            String message = NLS.bind((String)Messages.IgnorePendingChangeAction_Dialog_Message, (Object)Messages.IgnorePendingChangeAction_1, (Object)Messages.ActivityDeleteDialog_36);
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)this.parent.getShell(), (String)Messages.IgnorePendingChangeAction_0, (String)message, (String)Messages.IgnorePendingChangeAction_2, (boolean)false, null, null);
            if (dialog.getReturnCode() == 2) {
                store.setValue("warn_ignore_changed_resource", !dialog.getToggleState());
                confirmIgnore = true;
            } else {
                confirmIgnore = false;
            }
        }
        return confirmIgnore;
    }

    private IStatus ignoreChange(IProgressMonitor monitor) throws TeamRepositoryException, CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 + this.selection.size() * 2));
        final HashMap<IConnection, IgnoreOperation> ops = new HashMap<IConnection, IgnoreOperation>();
        boolean unloadedShareables = false;
        for (Object o : this.selection) {
            IConnection connection;
            if (o instanceof ILocalChange) {
                LocalChange change = (LocalChange)o;
                connection = ComponentSyncUtil.getContext((IComponentSyncModel)FileSystemResourcesPlugin.getComponentSyncModel(), (ILocalChange)change).getOutgoingConnection();
                this.getOp(ops, connection).addIgnoreable(connection, change.getShareable(), change.getComponent());
                continue;
            }
            if (o instanceof IRemoteChangeSummary) {
                IRemoteChangeSummary summary = (IRemoteChangeSummary)o;
                connection = summary.getActivity().getActivitySource().getModel().getOutgoingConnection();
                IComponent component = summary.getActivity().getActivitySource().getModel().getComponent();
                Collection shareables = SharingManager.getInstance().findShareables(connection.getContextHandle(), (IComponentHandle)component, summary.getItem(), (IProgressMonitor)progress.newChild(1));
                if (shareables.size() == 0) {
                    Collection parentShareables = SharingManager.getInstance().findShareables(connection.getContextHandle(), (IComponentHandle)component, (IVersionableHandle)summary.getChangeSummary().parent(), (IProgressMonitor)progress.newChild(1));
                    if (parentShareables.size() == 0) {
                        unloadedShareables = true;
                        continue;
                    }
                    if (parentShareables.size() == 1) {
                        IShareable parent = (IShareable)parentShareables.iterator().next();
                        IShareable toIgnore = parent.getSandbox().findShareable(parent.getLocalPath().append(summary.getResourceName()), ResourceType.getResourceType((IVersionableHandle)summary.getItem()));
                        this.getOp(ops, connection).addIgnoreable(connection, toIgnore, (IComponentHandle)component);
                        continue;
                    }
                    return this.handleMultiSandboxIgnoreError(summary.getResourceName());
                }
                if (shareables.size() == 1) {
                    this.getOp(ops, connection).addIgnoreable(connection, (IShareable)shareables.iterator().next(), (IComponentHandle)component);
                    continue;
                }
                return this.handleMultiSandboxIgnoreError(summary.getResourceName());
            }
            return new Status(4, "com.ibm.team.filesystem.ide.ui", String.valueOf(Messages.IgnorePendingChangeAction_5) + o.getClass().getSimpleName(), null);
        }
        if (unloadedShareables) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog dialog = new MessageDialog(IgnorePendingChangeAction.this.parent, Messages.IgnorePendingChangeAction_CANNOT_IGNORE_UNLOADED_FILES_OR_FOLDERS, null, Messages.IgnorePendingChangeAction_MAY_ONLY_IGNORE_LOADED_FILES_AND_FOLDERS, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                    dialog.setBlockOnOpen(false);
                    dialog.open();
                }
            });
            return Status.OK_STATUS;
        }
        progress.setWorkRemaining(100);
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)ops.size());
                for (IgnoreOperation op : ops.values()) {
                    try {
                        op.execute((IProgressMonitor)progress.newChild(1));
                    }
                    catch (TeamRepositoryException e) {
                        throw new CoreException((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", Messages.IgnorePendingChangeAction_6, (Throwable)e));
                    }
                }
            }
        }, (IProgressMonitor)progress.newChild(100));
        return Status.OK_STATUS;
    }

    private IStatus handleMultiSandboxIgnoreError(final String resourceName) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(IgnorePendingChangeAction.this.parent, Messages.IgnorePendingChangeAction_UNSUPPORTED_MULTI_SANDBOX_IGNORE_DIALOG_TITLE, null, NLS.bind((String)Messages.IgnorePendingChangeAction_UNSUPPORTED_MULTI_SANDBOX_IGNORE, (Object)resourceName), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                dialog.setBlockOnOpen(false);
                dialog.open();
            }
        });
        return Status.OK_STATUS;
    }

    private IgnoreOperation getOp(Map<IConnection, IgnoreOperation> ops, IConnection connection) throws FileSystemException {
        if (ops.containsKey(connection)) {
            return ops.get(connection);
        }
        IgnoreOperation op = new IgnoreOperation();
        ops.put(connection, op);
        return op;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        List list = ((IStructuredSelection)selection).toList();
        Set contexts = ComponentSyncUtil.getContexts((Collection)list);
        if (!ComponentSyncUtil.allLoggedIn((Collection)contexts)) {
            action.setEnabled(false);
            return;
        }
        Set[] result = ComponentSyncUtil.filter((Collection)list, (Class[])new Class[]{IOutgoingRemoteChangeSummary.class, ILocalChange.class, Object.class});
        if (!result[2].isEmpty() || !IgnorePendingChangeAction.validateSelection(result[0], result[1])) {
            action.setEnabled(false);
            return;
        }
        this.selection = new HashSet();
        this.selection.addAll(result[0]);
        this.selection.addAll(result[1]);
        action.setEnabled(true);
    }

    private static boolean validateSelection(Set<IOutgoingRemoteChangeSummary> remoteChanges, Set<ILocalChange> localChanges) {
        for (IOutgoingRemoteChangeSummary summary : remoteChanges) {
            IRemoteActivity activity = summary.getActivity();
            if (!activity.getActivitySource().getModel().isActive(activity)) {
                return false;
            }
            if (((OutgoingChangeSummaryNode)summary).getAfterPathArray().length > 1) continue;
            return false;
        }
        return true;
    }
}

