/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.ui.configuration.IHistoryEntry;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryPicker;
import com.ibm.team.internal.filesystem.ui.util.PendingChangesUtil;
import com.ibm.team.internal.filesystem.ui.views.history.HistoryViewUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class FindChangeSetAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        ItemId changeSet = null;
        ITeamRepository repository = null;
        ItemNamespace workspace = null;
        if (element instanceof ChangeSetWrapper) {
            ChangeSetWrapper wrapper = (ChangeSetWrapper)((Object)element);
            changeSet = ItemId.forItem((IItem)wrapper.getChangeSet());
            repository = wrapper.getRepository();
        }
        if (element instanceof IChangeSetHandle) {
            IChangeSetHandle changeSetHandle = (IChangeSetHandle)element;
            changeSet = new ItemId((IItemHandle)changeSetHandle);
            repository = (ITeamRepository)changeSetHandle.getOrigin();
        }
        if (element instanceof IRemoteActivity) {
            IRemoteActivity remoteActivity = (IRemoteActivity)element;
            changeSet = PendingChangesUtil.getChangeSet(remoteActivity);
            repository = remoteActivity.getActivitySource().getModel().localTeamRepository();
            workspace = PendingChangesUtil.getContributorPlace(remoteActivity);
        }
        if (element instanceof IHistoryEntry) {
            IHistoryEntry ihe = (IHistoryEntry)element;
            ChangeSetWrapper wrapper = ihe.getChangeSet();
            if (wrapper != null) {
                changeSet = ChangeSetUtil.getChangeSet((IChangeSetHandle)wrapper.getChangeSet());
            }
            repository = ihe.getRepository();
            workspace = ihe.getDynamicContext().getNamespace();
        }
        if (changeSet == null) {
            throw new IllegalStateException();
        }
        final UIContext context = this.getContext();
        final ItemNamespace finalWorkspace = workspace;
        if (repository == null) {
            final ItemId cs = changeSet;
            RepositoryPicker.pickRepository(shell, Messages.FindChangeSetAction_0, new IPartResult<ITeamRepository>(){

                public void setResult(ITeamRepository result) {
                    HistoryViewUtil.findChangeSet(context, (ItemLocator<IChangeSet>)ItemLocator.create((ITeamRepository)result, (ItemId)cs), finalWorkspace);
                }
            });
        } else {
            HistoryViewUtil.findChangeSet(context, (ItemLocator<IChangeSet>)ItemLocator.create((ITeamRepository)repository, (ItemId)changeSet), finalWorkspace);
        }
    }
}

