/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.client.operations.SuspendDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.OpenPortEditorAction;
import com.ibm.team.filesystem.ui.changes.actions.ApplyPatchDilemmaHandler;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetInContextWrapper;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public abstract class DiscardDilemmaHandler {
    protected UIContext context;

    public abstract com.ibm.team.filesystem.client.operations.DiscardDilemmaHandler getDiscardProblemHandler();

    public abstract SuspendDilemmaHandler getSuspendProblemHandler();

    public DiscardFailedResult notifyDiscardFailed(final List<ChangeSetInContextWrapper> failures, FailureReason reason, final TeamRepositoryException exception, final IProgressMonitor monitor) throws OperationCanceledException, TeamRepositoryException {
        switch (reason) {
            case INITIAL_BASELINE: {
                this.context.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)DiscardDilemmaHandler.this.context.getShell(), (String)DiscardDilemmaHandler.this.getDialogTitle(), (String)DiscardDilemmaHandler.this.getInitialBaselineErrorMessage());
                    }
                });
                break;
            }
            case CONFLICT: {
                this.context.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ErrorDialog.openError((Shell)DiscardDilemmaHandler.this.context.getShell(), (String)DiscardDilemmaHandler.this.getDialogTitle(), (String)DiscardDilemmaHandler.this.getConflictErrorMessage(), (IStatus)StatusUtil.newStatus((Object)this, (String)exception.getMessage()));
                    }
                });
                break;
            }
            case PENDING_PATCH: {
                this.context.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ErrorDialog.openError((Shell)DiscardDilemmaHandler.this.context.getShell(), (String)DiscardDilemmaHandler.this.getDialogTitle(), (String)DiscardDilemmaHandler.this.getPendingPatchErrorMessage(), (IStatus)StatusUtil.newStatus((Object)this, (String)exception.getMessage()));
                        try {
                            HashMap editorsToOpen = new HashMap();
                            for (ChangeSetInContextWrapper changeSetInContextWrapper : failures) {
                                UUID componentID;
                                IComponentHandle componentHandle;
                                WorkspaceNamespace nameSpace = (WorkspaceNamespace)changeSetInContextWrapper.getNamespace();
                                HashMap<UUID, IComponentHandle> componentMap = (HashMap<UUID, IComponentHandle>)editorsToOpen.get(nameSpace);
                                if (componentMap == null) {
                                    componentMap = new HashMap<UUID, IComponentHandle>();
                                    editorsToOpen.put(nameSpace, componentMap);
                                }
                                if ((componentHandle = (IComponentHandle)componentMap.get(componentID = nameSpace.getComponentId().getItemUUID())) != null) continue;
                                componentMap.put(componentID, (IComponentHandle)nameSpace.getComponentId().toHandle());
                            }
                            for (Map.Entry entry : editorsToOpen.entrySet()) {
                                IItemManager itemManager = ((WorkspaceNamespace)entry.getKey()).getRepository().itemManager();
                                IWorkspaceConnection workspaceConnection = (IWorkspaceConnection)((WorkspaceNamespace)entry.getKey()).getConnection(monitor);
                                for (IComponentHandle componentHandle : ((Map)entry.getValue()).values()) {
                                    if (workspaceConnection.getCurrentPatch(componentHandle) == null && workspaceConnection.getAcceptQueueSize(componentHandle) <= 0L) continue;
                                    IComponent component = (IComponent)itemManager.fetchCompleteItem((IItemHandle)componentHandle, 0, monitor);
                                    OpenPortEditorAction.openPortEditor(DiscardDilemmaHandler.this.context.getPage(), workspaceConnection, component);
                                }
                            }
                        }
                        catch (TeamRepositoryException teamRepositoryException) {
                            // empty catch block
                        }
                    }
                });
            }
        }
        throw new OperationCanceledException();
    }

    protected abstract String getPendingPatchErrorMessage();

    protected abstract String getConflictErrorMessage();

    protected abstract String getInitialBaselineErrorMessage();

    protected abstract String getDialogTitle();

    public abstract ApplyPatchDilemmaHandler getApplyPatchDilemmaHandler();

    public int uncheckedInChanges(Collection<IComponentHandle> components) {
        return 2;
    }

    public static enum DiscardFailedResult {
        REVERSE;

    }

    public static enum FailureReason {
        INITIAL_BASELINE,
        CONFLICT,
        PENDING_PATCH;

    }
}

