/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.operations.IDiscardOperation;
import com.ibm.team.filesystem.client.operations.ISuspendOperation;
import com.ibm.team.filesystem.client.operations.SuspendDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.ui.changes.actions.DiscardDilemmaHandler;
import com.ibm.team.filesystem.ui.changes.actions.StandardDiscardDilemmaHandler;
import com.ibm.team.filesystem.ui.item.AdapterUtil;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetInContextWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.patches.ApplyPatchUtil;
import com.ibm.team.internal.filesystem.ui.views.history.actions.ActivitySuspendDialog;
import com.ibm.team.internal.filesystem.ui.views.history.actions.SuspendWrapperAction;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.DiscardInitialBaselineException;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.NWayConflictUnsupportedException;
import com.ibm.team.scm.common.PatchInProgressException;
import com.ibm.team.scm.common.dto.IChangeSetLinkSummary;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class DiscardChangeSetsAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection ss) {
        List<ChangeSetInContextWrapper> changeSets = AdapterUtil.adaptList(ss.toList(), ChangeSetInContextWrapper.class);
        DiscardChangeSetsAction.discard(this.getContext(), changeSets);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        List elements = ((IStructuredSelection)selection).toList();
        for (IComponentSyncContext context : ComponentSyncUtil.getContexts((Collection)elements)) {
            if (!context.getOutgoingTeamPlace().isStream()) continue;
            action.setEnabled(false);
            return;
        }
        action.setEnabled(true);
    }

    public static void discard(final UIContext context, final Collection<ChangeSetInContextWrapper> changeSets) {
        for (ChangeSetInContextWrapper next : changeSets) {
            if (next.getNamespace() instanceof WorkspaceNamespace) continue;
            MessageDialogFactory.showMessage((Shell)context.getShell(), (int)2, (String)Messages.DiscardChangeSetsAction_0, (String)Messages.DiscardChangeSetsAction_1);
            return;
        }
        String message = Messages.DiscardChangeSetsAction_3;
        ActivitySuspendDialog.showDialog(context.getShell(), message, new IPartResult<Object>(){

            public void setResult(Object result) {
                if (result == ActivitySuspendDialog.VALUE_DISCARD) {
                    DiscardChangeSetsAction.doDiscard(context, changeSets);
                } else if (result == ActivitySuspendDialog.VALUE_SUSPEND) {
                    SuspendWrapperAction.doSuspend(context, changeSets);
                }
            }
        });
    }

    protected static boolean allEmptyChanges(Collection<? extends ChangeSetWrapper> activities) {
        for (ChangeSetWrapper changeSetWrapper : activities) {
            if (changeSetWrapper.getChangeSet().changes().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static void doDiscard(final UIContext context, final Collection<ChangeSetInContextWrapper> changeSets) {
        String name = Messages.DiscardChangeSetsAction_4;
        context.getUserOperationRunner().enqueue(name, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                DiscardChangeSetsAction.doDiscard(DiscardType.DISCARD, new StandardDiscardDilemmaHandler(context), changeSets, monitor);
            }
        });
    }

    public static void doDiscard(DiscardType operation, DiscardDilemmaHandler dilemmaHandler, Collection<ChangeSetInContextWrapper> changeSets, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException, OperationFailedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        com.ibm.team.filesystem.client.operations.DiscardDilemmaHandler problemHandler = dilemmaHandler.getDiscardProblemHandler();
        SuspendDilemmaHandler suspendProblemHandler = dilemmaHandler.getSuspendProblemHandler();
        Map<SnapshotId, List<ChangeSetInContextWrapper>> groupedBySnapshot = ChangeSetInContextWrapper.groupBySnapshot(changeSets);
        DiscardDilemmaHandler.FailureReason failureReason = DiscardDilemmaHandler.FailureReason.PENDING_PATCH;
        ArrayList failedDueToConflicts = NewCollection.arrayList();
        Throwable lastException = null;
        SubMonitor loopProgress = progress.newChild(90).setWorkRemaining(groupedBySnapshot.size());
        for (Map.Entry<SnapshotId, List<ChangeSetInContextWrapper>> next : groupedBySnapshot.entrySet()) {
            if (!(next.getKey() instanceof SnapshotId)) continue;
            SubMonitor iterationProgress = loopProgress.newChild(1).setWorkRemaining(100);
            IWorkspaceConnection connection = (IWorkspaceConnection)next.getKey().getConnection((IProgressMonitor)iterationProgress.newChild(10));
            try {
                List<IChangeSet> changeSetList = ChangeSetWrapper.getChangeSets((Collection<? extends ChangeSetWrapper>)next.getValue());
                HashSet<UUID> ids = new HashSet<UUID>();
                for (IChangeSet cs : changeSetList) {
                    if (ids.add(cs.getItemId())) continue;
                    String desc = null;
                    List summaries = SCMPlatform.getWorkspaceManager((ITeamRepository)connection.teamRepository()).getChangeSetLinkSummary(Collections.singletonList(cs), monitor);
                    if (!summaries.isEmpty()) {
                        IChangeSetLinkSummary summary = (IChangeSetLinkSummary)summaries.iterator().next();
                        desc = summary.getSummary();
                    }
                    if (desc != null) {
                        if (operation == DiscardType.DISCARD) {
                            throw new TeamRepositoryException(NLS.bind((String)Messages.DiscardChangeSetsAction_DUPLICATES_DISCARD, (Object)desc));
                        }
                        throw new TeamRepositoryException(NLS.bind((String)Messages.DiscardChangeSetsAction_DUPLICATES_SUSPEND, (Object)desc));
                    }
                    if (operation == DiscardType.DISCARD) {
                        throw new TeamRepositoryException(Messages.DiscardChangeSetsAction_DUPLICATES_DISCARD2);
                    }
                    throw new TeamRepositoryException(Messages.DiscardChangeSetsAction_DUPLICATES_SUSPEND2);
                }
                if (operation == DiscardType.DISCARD) {
                    DiscardChangeSetsAction.discardFromConnection(connection, changeSetList, problemHandler, (IProgressMonitor)iterationProgress.newChild(90));
                    continue;
                }
                if (operation != DiscardType.SUSPEND) continue;
                ISuspendOperation op = IOperationFactory.instance.getSuspendOperation(suspendProblemHandler);
                op.suspend(connection, changeSetList);
                op.run((IProgressMonitor)iterationProgress.newChild(90));
            }
            catch (NWayConflictUnsupportedException e) {
                failedDueToConflicts.addAll((Collection)next.getValue());
                failureReason = DiscardDilemmaHandler.FailureReason.CONFLICT;
                lastException = e;
            }
            catch (PatchInProgressException e) {
                failedDueToConflicts.addAll((Collection)next.getValue());
                failureReason = DiscardDilemmaHandler.FailureReason.PENDING_PATCH;
                lastException = e;
            }
            catch (DiscardInitialBaselineException e) {
                failedDueToConflicts.addAll((Collection)next.getValue());
                failureReason = DiscardDilemmaHandler.FailureReason.INITIAL_BASELINE;
                lastException = e;
            }
        }
        if (!failedDueToConflicts.isEmpty()) {
            progress.setWorkRemaining(100);
            DiscardDilemmaHandler.DiscardFailedResult failureResult = dilemmaHandler.notifyDiscardFailed(failedDueToConflicts, failureReason, (TeamRepositoryException)lastException, (IProgressMonitor)progress.newChild(10));
            if (failureResult == DiscardDilemmaHandler.DiscardFailedResult.REVERSE) {
                ApplyPatchUtil.applyAsPatch(dilemmaHandler.getApplyPatchDilemmaHandler(), failedDueToConflicts, true, (IProgressMonitor)progress.newChild(90));
            }
        }
    }

    protected static void discardFromConnection(IWorkspaceConnection connection, Collection<IChangeSet> changeSets, com.ibm.team.filesystem.client.operations.DiscardDilemmaHandler problemHandler, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        HashMap<UUID, IChangeSet> activeChangeSets = new HashMap<UUID, IChangeSet>();
        for (IChangeSet cs : changeSets) {
            if (!cs.isActive()) continue;
            activeChangeSets.put(cs.getItemId(), cs);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IDiscardOperation discardOperation = IOperationFactory.instance.getDiscardOperation(problemHandler);
        discardOperation.discard(connection, changeSets);
        discardOperation.run((IProgressMonitor)(activeChangeSets.isEmpty() ? progress.newChild(100) : progress.newChild(80)));
        if (!activeChangeSets.isEmpty()) {
            try {
                connection.teamRepository().itemManager().fetchCompleteItemsPermissionAware(new ArrayList(activeChangeSets.values()), 1, (IProgressMonitor)progress.newChild(20));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static enum DiscardType {
        DISCARD,
        SUSPEND;

    }
}

