/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.ILocalSynchronizationManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.jface.labelProviders.TypeLabelProvider;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public final class DialogUtil {
    private DialogUtil() {
    }

    public static IComponentSyncContext selectContext(Shell shell, IComponentSyncModel model) {
        IComponentSyncContext[] contexts = model.getComponentSyncContexts();
        ArrayList<IComponentSyncContext> localContexts = new ArrayList<IComponentSyncContext>();
        int i = 0;
        while (i < contexts.length) {
            IComponentSyncContext context = contexts[i];
            if (context.isLocal()) {
                localContexts.add(context);
            }
            ++i;
        }
        if (localContexts.size() == 1) {
            return (IComponentSyncContext)localContexts.get(0);
        }
        Object[] localContextsArray = localContexts.toArray(new IComponentSyncContext[localContexts.size()]);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new ComponentContextLabelProvider());
        dialog.setBlockOnOpen(true);
        dialog.setMultipleSelection(false);
        dialog.setSize(60, 15);
        dialog.setEmptyListMessage(Messages.DialogUtil_NoComponentsDefinedMessage);
        dialog.setMessage(Messages.DialogUtil_SelectComponentMessage);
        dialog.setTitle(Messages.DialogUtil_SelectComponentTitle);
        DialogUtil.sort((IComponentSyncContext[])localContextsArray);
        dialog.setElements(localContextsArray);
        int result = dialog.open();
        return result == 0 ? (IComponentSyncContext)dialog.getResult()[0] : null;
    }

    private static String getName(IComponentSyncContext context) {
        if (context.isDisposed()) {
            return "";
        }
        return context.getComponent().getName();
    }

    private static boolean isLoaded(IComponentSyncContext context) {
        ILocalSynchronizationManager mgr = FileSystemResourcesPlugin.getComponentSyncModel().getLocalSynchronizationManager();
        IWorkspaceConnection connection = context.getOutgoingTeamPlace();
        return connection != null && mgr.isShared((IWorkspaceHandle)connection.getResolvedWorkspace(), (IComponentHandle)context.getComponent());
    }

    public static void sort(IComponentSyncContext[] contexts) {
        Arrays.sort(contexts, new Comparator(){

            public int compare(Object o1, Object o2) {
                String n1 = DialogUtil.getName((IComponentSyncContext)o1);
                String n2 = DialogUtil.getName((IComponentSyncContext)o2);
                return n1.compareToIgnoreCase(n2);
            }
        });
    }

    public static boolean openConfirm(Shell parent, String title, String message, boolean defaultIsOK) {
        return DialogUtil.openConfirm(parent, title, message, 3, defaultIsOK);
    }

    public static void openError(final Shell parent, final String title, final String message) {
        DialogUtil.pauseIfNeededBeforeShowingDialog();
        Display display = parent == null ? Display.getDefault() : parent.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = DialogUtil.getParentShell(parent);
                MessageDialog.openError((Shell)shell, (String)title, (String)message);
            }
        });
    }

    public static void openWarning(final Shell parent, final String title, final String message) {
        DialogUtil.pauseIfNeededBeforeShowingDialog();
        Display display = parent == null ? Display.getDefault() : parent.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = DialogUtil.getParentShell(parent);
                MessageDialog.openWarning((Shell)shell, (String)title, (String)message);
            }
        });
    }

    public static boolean openConfirm(final Shell parent, final String title, final String message, final int dialogImageType, final boolean defaultIsOK) {
        DialogUtil.pauseIfNeededBeforeShowingDialog();
        final boolean[] result = new boolean[1];
        Display display = parent == null ? Display.getDefault() : parent.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = DialogUtil.getParentShell(parent);
                result[0] = DialogUtil.openConfirm0(shell, title, message, dialogImageType, defaultIsOK);
            }
        });
        return result[0];
    }

    private static boolean openConfirm0(Shell parent, String title, String message, int dialogImageType, boolean defaultIsOK) {
        MessageDialog dialog = new MessageDialog(parent, title, null, message, dialogImageType, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, defaultIsOK ? 0 : 1);
        return dialog.open() == 0;
    }

    public static int openYesNoCancel(Shell parent, String title, String message, boolean defaultIsYes) {
        return DialogUtil.openYesNoCancel(parent, title, message, 3, defaultIsYes);
    }

    public static int openYesNoCancel(final Shell parent, final String title, final String message, final int dialogImageType, final boolean defaultIsYes) {
        DialogUtil.pauseIfNeededBeforeShowingDialog();
        final int[] result = new int[1];
        Display display = parent == null ? Display.getDefault() : parent.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = DialogUtil.getParentShell(parent);
                result[0] = DialogUtil.openYesNoCancel0(shell, title, message, dialogImageType, defaultIsYes);
            }
        });
        return result[0];
    }

    private static int openYesNoCancel0(Shell parent, String title, String message, int dialogImageType, boolean defaultIsYes) {
        MessageDialog dialog = new MessageDialog(parent, title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, defaultIsYes ? 0 : 1);
        int result = dialog.open();
        if (result == 2) {
            result = -1;
        }
        return result;
    }

    public static void pauseIfNeededBeforeShowingDialog() {
        if (Display.getCurrent() == null && PlatformUI.isWorkbenchRunning() && !PlatformUI.getWorkbench().getPreferenceStore().getBoolean("RUN_IN_BACKGROUND")) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static boolean openQuestionDialog(final Shell parent, final String title, final String message, final boolean defaultIsYes) {
        DialogUtil.pauseIfNeededBeforeShowingDialog();
        final boolean[] result = new boolean[1];
        Display display = parent == null ? Display.getDefault() : parent.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = DialogUtil.getParentShell(parent);
                result[0] = DialogUtil.openQuestionDialog0(shell, title, message, defaultIsYes);
            }
        });
        return result[0];
    }

    private static Shell getParentShell(Shell parent) {
        IWorkbenchWindow window;
        if (parent != null && !parent.isDisposed()) {
            return parent;
        }
        if (PlatformUI.isWorkbenchRunning() && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && window.getShell() != null) {
            return window.getShell();
        }
        return null;
    }

    private static boolean openQuestionDialog0(Shell parent, String title, String message, boolean defaultIsYes) {
        MessageDialog dialog = new MessageDialog(parent, title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, defaultIsYes ? 0 : 1);
        return dialog.open() == 0;
    }

    public static Shell checkShell(Shell shell) {
        if (shell != null && !shell.isDisposed()) {
            return shell;
        }
        return null;
    }

    public static void setFocusControl(final Label label, final Control focusControl) {
        Assert.isLegal((label != null ? 1 : 0) != 0);
        Assert.isLegal((focusControl != null ? 1 : 0) != 0);
        label.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.detail == 128) {
                    char mnemonic = DialogUtil._findMnemonic(label.getText());
                    if (mnemonic == '\u0000') {
                        return;
                    }
                    if (Character.toUpperCase(event.character) != Character.toUpperCase(mnemonic)) {
                        return;
                    }
                    if (focusControl.setFocus()) {
                        event.doit = true;
                        event.detail = 0;
                    }
                }
            }
        });
    }

    private static char _findMnemonic(String string) {
        if (string == null) {
            return '\u0000';
        }
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return '\u0000';
            }
            if (string.charAt(index) != '&') {
                return string.charAt(index);
            }
            if (++index >= length) break;
        }
        return '\u0000';
    }

    private static class ComponentContextLabelProvider
    extends TypeLabelProvider {
        private Image loadedImage = this.getImage(ImagePool.COMPONENT);
        private Image unloadedImage = this.getImage(ImagePool.COMPONENT_UNLOADED);

        public void updateLabel(ViewerLabel label, Object element) {
            IComponentSyncContext context = (IComponentSyncContext)element;
            String name = DialogUtil.getName(context);
            IBaseline basis = context.getLocalBaseline();
            if (basis != null) {
                label.setText(NLS.bind((String)Messages.DialogUtil_componentWithBaselineDecoration, (Object)name, (Object)BaselineWrapper.getLabel(basis)));
            } else {
                label.setText(name);
            }
            label.setImage(DialogUtil.isLoaded(context) ? this.loadedImage : this.unloadedImage);
        }
    }
}

