/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.DeliverDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IDeliverOperation;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingBaselineGroup;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnDeliverUser;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class DeliverBaselineGroupAction
extends AbstractActionDelegate {
    Set<IOutgoingBaselineGroup> baselines;

    public void run(final Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        if (this.baselines == null) {
            return;
        }
        final String name = Messages.DeliverBaselineGroupAction_DeliveringBaselinesJobName;
        HashSet<ITeamRepository> affectedRepositories = new HashSet<ITeamRepository>(1);
        for (IOutgoingBaselineGroup bg : this.baselines) {
            affectedRepositories.add(bg.getActivitySource().getModel().localTeamRepository());
            affectedRepositories.add(bg.getActivitySource().getModel().getRemoteOutgoingTeamRepository());
        }
        this.getOperationRunner().enqueue(name, (Operation)new RepositoryOperation(affectedRepositories){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DeliverBaselineGroupAction_DeliveringBaselineProgressName, (int)100);
                IDeliverOperation deliverOp = IOperationFactory.instance.getDeliverOperation((DeliverDilemmaHandler)new WarnDeliverUser(shell, name){

                    @Override
                    public int uncheckedInChanges(Map<ConfigurationFacade, Collection<ILocalChange>> changes) {
                        return 3;
                    }
                });
                for (IOutgoingBaselineGroup bg : DeliverBaselineGroupAction.this.baselines) {
                    IComponentSyncContext context = bg.getActivitySource().getModel();
                    deliverOp.deliver(context.getOutgoingTeamPlace(), context.getRemoteOutgoingTeamPlace(), context.getOutgoingChangeHistorySyncReport(), Collections.singletonList(bg.getBaseline()), Collections.emptyList(), Collections.emptyList());
                }
                deliverOp.run((IProgressMonitor)progress);
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Set contexts;
        super.selectionChanged(action, selection);
        boolean enable = false;
        Set[] result = ComponentSyncUtil.filter((Collection)((IStructuredSelection)selection).toList(), (Class[])new Class[]{IOutgoingBaselineGroup.class, Object.class});
        if (!result[0].isEmpty() && result[1].isEmpty() && (contexts = ComponentSyncUtil.getContexts((Collection)result[0])).size() == result[0].size() && ComponentSyncUtil.allLoggedIn((Collection)contexts)) {
            this.baselines = result[0];
            enable = true;
        }
        action.setEnabled(enable);
    }
}

