/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.utils.ConnectionFacade;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.IActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IComponentHierarchyResult;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class DeliverAndOverrideAction
extends AbstractActionDelegate {
    public static String getTargetName(List selection, boolean incoming) {
        String targetName = null;
        Set[] filter = ComponentSyncUtil.filter((Collection)selection, (Class[])new Class[]{IWorkspaceSyncContext.class, IComponentSyncContext.class, Object.class});
        Set workspaces = filter[0];
        Set contexts = filter[1];
        if (workspaces.size() == 1) {
            IWorkspaceSyncContext context = (IWorkspaceSyncContext)workspaces.iterator().next();
            ConnectionFacade desc = incoming ? context.getRemoteIncomingConnectionDescriptor() : context.getRemoteOutgoingConnectionDescriptor();
            IConnection remote = desc.getCachedConnection();
            if (remote != null) {
                targetName = remote.getName();
            }
        }
        for (IWorkspaceSyncContext context : contexts) {
            ConnectionFacade connection = incoming ? context.getRemoteIncomingConnection() : context.getRemoteOutgoingConnection();
            String name = connection.getName();
            if (targetName == null) {
                targetName = name;
                continue;
            }
            if (targetName.equals(name)) continue;
            targetName = null;
            break;
        }
        return targetName != null ? targetName : Messages.DeliverAndOverrideAction_0;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enable;
        super.selectionChanged(action, selection);
        List list = ((IStructuredSelection)selection).toList();
        Set[] filter = ComponentSyncUtil.filter((Collection)list, (Class[])new Class[]{IComponentSyncContext.class, Object.class});
        boolean bl = enable = filter[1].isEmpty() && ComponentSyncUtil.getWorkspaceContexts((Collection)list).size() == 1 && ComponentSyncUtil.allType((Collection)filter[0], (int)10);
        if (enable) {
            IWorkspaceSyncContext wsc = (IWorkspaceSyncContext)ComponentSyncUtil.getWorkspaceContexts((Collection)list).iterator().next();
            IWorkspaceConnection wc = wsc.getLocal();
            IActiveWorkspaceManager manager = FileSystemResourcesPlugin.getActiveWorkspaceManager();
            if (!manager.isWorkspaceTracked((IWorkspaceHandle)wc.getResolvedWorkspace())) {
                enable = false;
            }
        }
        action.setEnabled(enable);
        action.setText(NLS.bind((String)Messages.DeliverAndOverrideAction_1, (Object)DeliverAndOverrideAction.getTargetName(list, false)));
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        int severity;
        String dialogMessage;
        List list = selection.toList();
        Set[] filter = ComponentSyncUtil.filter((Collection)list, (Class[])new Class[]{IWorkspaceSyncContext.class, IComponentSyncContext.class, Object.class});
        final Set workspaces = filter[0];
        final Set contexts = filter[1];
        if (ComponentSyncUtil.hasComponentContextTwins((Collection)contexts)) {
            JFaceUtils.showMessage((String)Messages.DeliverAndOverrideAction_7, (String)Messages.ContextTwinsSelected_0, (int)2);
            return;
        }
        boolean replaceTargetContainsHierarchy = false;
        HashSet<IComponentSyncContext> componentsToCheck = new HashSet<IComponentSyncContext>(contexts);
        for (IWorkspaceSyncContext workspace : workspaces) {
            componentsToCheck.addAll(Arrays.asList(workspace.getComponentSyncContexts()));
        }
        for (IComponentSyncContext component : componentsToCheck) {
            IWorkspaceConnection wc;
            IComponentHierarchyResult hierarchy;
            if (!(component.getRemoteOutgoingTeamPlace() instanceof IWorkspaceConnection) || (hierarchy = (wc = component.getRemoteOutgoingTeamPlace()).getComponentHierarchy(Collections.singletonList(component.getComponent()))).getFlattenedElementsMap().size() <= 1) continue;
            replaceTargetContainsHierarchy = true;
            break;
        }
        String dialogTitle = Messages.DeliverAndOverrideAction_2;
        if (replaceTargetContainsHierarchy) {
            dialogMessage = Messages.DeliverAndOverrideAction_3_NoBackupBaseline;
            severity = 4;
        } else {
            dialogMessage = Messages.DeliverAndOverrideAction_3;
            severity = 5;
        }
        String[] dialogButtons = new String[]{Messages.DeliverAndOverrideAction_4, Messages.DeliverAndOverrideAction_5};
        if (!JFaceUtils.showMessageBlocking((String)dialogTitle, (String)dialogMessage, (String[])dialogButtons, (int)severity)) {
            return;
        }
        this.getOperationRunner().enqueue(Messages.DeliverAndOverrideAction_6, (Operation)new RepositoryOperation(ComponentSyncUtil.getTeamRepositories((Collection)list)){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                try {
                    List<ReplaceOperationData> replaces;
                    HashMap<IWorkspaceConnection, ArrayList<ReplaceOperationData>> groupedReplaces = new HashMap<IWorkspaceConnection, ArrayList<ReplaceOperationData>>();
                    for (IWorkspaceSyncContext workspaceContext : workspaces) {
                        IComponentSyncContext[] contexts2 = workspaceContext.getComponentSyncContexts();
                        ArrayList<? extends IComponentHandle> components = new ArrayList<IComponentHandle>(contexts2.length);
                        IComponentSyncContext[] iComponentSyncContextArray = contexts2;
                        int n = contexts2.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IComponentSyncContext context = iComponentSyncContextArray[n2];
                            components.add((IComponentHandle)context.getComponent());
                            ++n2;
                        }
                        ReplaceOperationData data = new ReplaceOperationData();
                        data.connection = (IWorkspaceConnection)workspaceContext.getRemoteOutgoingConnectionDescriptor().getConnection((IProgressMonitor)progress.newChild(1));
                        data.sources = components;
                        data.seed = workspaceContext.getLocal();
                        ArrayList<ReplaceOperationData> replaces2 = (ArrayList<ReplaceOperationData>)groupedReplaces.get(data.connection);
                        if (replaces2 == null) {
                            replaces2 = new ArrayList<ReplaceOperationData>();
                            groupedReplaces.put(data.connection, replaces2);
                        }
                        replaces2.add(data);
                    }
                    for (IComponentSyncContext context : contexts) {
                        ReplaceOperationData data = new ReplaceOperationData();
                        data.connection = context.getRemoteOutgoingTeamPlace();
                        data.sources = Arrays.asList(context.getComponent());
                        data.seed = context.getOutgoingTeamPlace();
                        replaces = (List)groupedReplaces.get(data.connection);
                        if (replaces == null) {
                            replaces = new ArrayList<ReplaceOperationData>();
                            groupedReplaces.put(data.connection, (ArrayList<ReplaceOperationData>)replaces);
                        }
                        replaces.add(data);
                    }
                    Set connections = groupedReplaces.keySet();
                    if (connections.size() != 1) {
                        throw new OperationFailedException((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", Messages.DeliverAndOverrideAction_8));
                    }
                    ArrayList<IFlowNodeConnection.IComponentReplacementOp> replaceOps = new ArrayList<IFlowNodeConnection.IComponentReplacementOp>();
                    IWorkspaceConnection connection = (IWorkspaceConnection)connections.iterator().next();
                    replaces = (ArrayList<ReplaceOperationData>)groupedReplaces.get(connection);
                    for (ReplaceOperationData data : replaces) {
                        int count = 0;
                        while (count < data.sources.size()) {
                            replaceOps.add(connection.componentOpFactory().replaceComponent(data.sources.get(count), data.seed, false));
                            ++count;
                        }
                    }
                    connection.applyComponentOperations(replaceOps, (IProgressMonitor)progress.newChild(1));
                }
                finally {
                    monitor.done();
                }
            }
        });
    }

    protected static class ReplaceOperationData {
        public IWorkspaceConnection connection;
        public List<? extends IComponentHandle> sources;
        public IConnection seed;

        protected ReplaceOperationData() {
        }
    }
}

