/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.operations.DeliverDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.views.zoom.ZoomRootUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnDeliverUser;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class DeliverAction
extends AbstractActionDelegate {
    private boolean shouldShowDeliverConfirmation = true;

    public DeliverAction() {
    }

    public DeliverAction(boolean shouldShowDeliverConfirmation) {
        this.shouldShowDeliverConfirmation = shouldShowDeliverConfirmation;
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        this.deliver(this.getContext().getShell(), ZoomRootUtil.replaceRootsWithChildren(selection.toList(), IOutgoingRemoteActivity.class));
    }

    private boolean shouldPromptForDeliver() {
        boolean confirmDeliver = UiPlugin.getBooleanPreference("pref_confirm_deliver");
        return this.shouldShowDeliverConfirmation && confirmDeliver;
    }

    public void deliver(final Shell shell, final Collection selection) {
        if (selection.size() == 0) {
            return;
        }
        if (this.shouldPromptForDeliver()) {
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)this.getName(), (String)Messages.DeliverAction_ConfirmDeliver, (String)Messages.DeliverAction_ConfirmDeliver_Store, (boolean)false, null, null);
            if (dialog.getReturnCode() == 2) {
                IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
                store.setValue("pref_confirm_deliver", !dialog.getToggleState());
            } else {
                return;
            }
        }
        HashSet<ITeamRepository> affectedRepositories = new HashSet<ITeamRepository>(1);
        for (IWorkspaceSyncContext context : ComponentSyncUtil.getWorkspaceContexts((Collection)selection)) {
            affectedRepositories.add(context.teamRepository());
        }
        this.getOperationRunner().enqueue(this.getName(), (Operation)new RepositoryOperation(affectedRepositories){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DeliverAction_0, (int)100);
                try {
                    if (!DeliverAction.this.addSubcomponentsToSelection(selection, shell)) {
                        return;
                    }
                    try {
                        IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
                        model.deliver(selection, (DeliverDilemmaHandler)new WarnDeliverUser(shell, Messages.DeliverAction_2), (IProgressMonitor)progress.newChild(100));
                    }
                    catch (TeamRepositoryException e) {
                        problems.setProblemSummary(Messages.DeliverAction_2a, e.getMessage());
                        problems.reportException((Throwable)e);
                    }
                }
                finally {
                    progress.done();
                }
            }
        });
    }

    protected boolean addSubcomponentsToSelection(Collection selection, Shell shell) {
        return true;
    }

    protected String getName() {
        return Messages.DeliverAction_1;
    }

    public void selectionChanged(IAction action, ISelection selected) {
        super.selectionChanged(action, selected);
        Collection selection = ZoomRootUtil.replaceRootsWithChildren(((IStructuredSelection)selected).toList(), IOutgoingRemoteActivity.class);
        action.setEnabled(this.calculateEnabledState(selection));
    }

    protected boolean calculateEnabledState(Collection selection) {
        return ComponentSyncUtil.enableDeliver((Collection)selection);
    }
}

