/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class CvsAcceptAction
extends AbstractActionDelegate {
    private static final String ACCEPTING_NAME = Messages.CvsAcceptAction_0;

    public void run(final Shell shell, IWorkbenchPage page, final IStructuredSelection selection) {
        if (selection.size() == 0) {
            return;
        }
        this.getOperationRunner().enqueue(ACCEPTING_NAME, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                CvsAcceptAction.accept(shell, selection.toList(), monitor);
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(ComponentSyncUtil.enableAccept((Collection)((IStructuredSelection)selection).toList()));
    }

    private static void accept(Shell shell, Collection selection, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IComponentSyncModel model = null;
        Set contexts = ComponentSyncUtil.getContexts((Collection)selection);
        SubMonitor subProgress = progress.newChild(80);
        subProgress.setWorkRemaining(contexts.size());
        for (IComponentSyncContext context : contexts) {
            model = context.getComponentSyncModel();
        }
        subProgress.done();
        if (model != null) {
            model.refresh(true, (IProgressMonitor)progress.newChild(20));
        }
    }
}

