/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.common.changemodel.ChangeDescription;
import com.ibm.team.filesystem.common.changemodel.ConfigurationChange;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ConfigurationChangeFactory;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.CopyFileAreaPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.FallbackPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivityFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.SnapshotPathResolver;
import com.ibm.team.filesystem.ui.changemodel.UIConfigurationChangeFactory;
import com.ibm.team.filesystem.ui.item.AdapterUtil;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetInContextWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.patches.ChangeFolder;
import com.ibm.team.internal.filesystem.ui.patches.CreatePatchPart;
import com.ibm.team.internal.filesystem.ui.util.PendingChangesUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class CreatePatchAction
extends AbstractActionDelegate {
    public void run(final Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        List sel = selection.toList();
        final Set<IRemoteChangeSummary> changes = this.getRemoteChangeSummaries(sel);
        final Set localChanges = ComponentSyncUtil.filter((Collection)sel, (Class[])new Class[]{ILocalChange.class})[0];
        final ArrayList changeSets = NewCollection.arrayList();
        final HashSet changeSetSet = NewCollection.hashSet();
        ArrayList unfilteredChangeSets = NewCollection.arrayList();
        unfilteredChangeSets.addAll(this.getChangeSetWrappers(sel));
        unfilteredChangeSets.addAll(this.getChangeSetWrappers(this.getRemoteActivities(sel)));
        for (ChangeSetWrapper next : unfilteredChangeSets) {
            if (!changeSetSet.add(next)) continue;
            changeSets.add(next);
        }
        final HashSet fileChanges = NewCollection.hashSet();
        fileChanges.addAll(AdapterUtil.adaptList(sel, FileChange.class));
        for (ChangeFolder folders : AdapterUtil.adaptList(sel, ChangeFolder.class)) {
            fileChanges.addAll(folders.getChanges());
            fileChanges.addAll(folders.getFolderChanges());
        }
        final UIContext context = this.getContext();
        this.getOperationRunner().enqueue(Messages.CreatePatchAction_ComputingPatchJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                List filteredChanges = CreatePatchAction.filterRemoteChanges(changes, changeSetSet);
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(3 + changeSets.size() + filteredChanges.size() + localChanges.size()));
                HashSet repositories = NewCollection.hashSet();
                for (ILocalChange next : localChanges) {
                    ITeamRepository repository = RepositoryUtils.getTeamRepository((ISharingDescriptor)next.getShareable().getShare((IProgressMonitor)progress.newChild(1)).getSharingDescriptor());
                    repositories.add(repository);
                }
                for (IRemoteChangeSummary nextSummary : filteredChanges) {
                    repositories.add(nextSummary.getActivity().getActivitySource().getModel().localTeamRepository());
                }
                final HashSet<SnapshotId> workspaces = new HashSet<SnapshotId>();
                for (ChangeSetWrapper next : changeSets) {
                    repositories.add(next.getRepository());
                    if (!(next instanceof ChangeSetInContextWrapper)) continue;
                    ChangeSetInContextWrapper context2 = (ChangeSetInContextWrapper)next;
                    workspaces.add(context2.getSnapshot());
                }
                SubMonitor loginProgress = progress.newChild(1).setWorkRemaining(repositories.size());
                for (ITeamRepository next : repositories) {
                    next.login((IProgressMonitor)loginProgress.newChild(1));
                }
                ArrayList problemsFound = new ArrayList();
                ConfigurationChange activityChanges = UIConfigurationChangeFactory.createChangeForChangeSets(changeSets, (IProgressMonitor)progress.newChild(changeSets.size()));
                ConfigurationChange individualChanges = ConfigurationChangeFactory.createChangeForSummaries((List)filteredChanges, (boolean)true, (IProgressMonitor)progress.newChild(filteredChanges.size()));
                ConfigurationChange localConfigChange = ConfigurationChangeFactory.createChange((Collection)localChanges, (boolean)true, problemsFound, (IProgressMonitor)progress.newChild(localChanges.size()));
                for (IStatus toReport : problemsFound) {
                    problems.reportProblem(toReport);
                }
                ConfigurationChange selectedChanges = new ConfigurationChange((Collection)fileChanges);
                final ConfigurationChange cc = activityChanges.merge(individualChanges).merge(localConfigChange).merge(selectedChanges);
                final ChangeDescription description = UIConfigurationChangeFactory.createDescriptionForWrappers(changeSets, (IProgressMonitor)progress.newChild(1));
                SWTUtil.greedyExec((Display)context.getDisplay(), (Control)shell, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ArrayList<Object> resolvers = new ArrayList<Object>();
                        resolvers.add(CopyFileAreaPathResolver.create());
                        for (SnapshotId nextId : workspaces) {
                            resolvers.add(SnapshotPathResolver.create((SnapshotId)nextId));
                        }
                        CreatePatchPart.showDialog(shell, cc, (IPathResolver)new FallbackPathResolver(resolvers), description);
                    }
                });
            }
        });
    }

    private Collection<ChangeSetWrapper> getChangeSetWrappers(Collection sel) {
        return AdapterUtil.adaptList(sel, ChangeSetWrapper.class);
    }

    private static List<IRemoteChangeSummary> filterRemoteChanges(Collection<IRemoteChangeSummary> unfiltered, Set<? extends ChangeSetWrapper> toFilter) {
        HashSet changeSetsToFilter = NewCollection.hashSet();
        for (ChangeSetWrapper changeSetWrapper : toFilter) {
            changeSetsToFilter.add(ItemId.forItem((IItem)changeSetWrapper.getChangeSet()));
        }
        ArrayList arrayList = NewCollection.arrayList();
        for (IRemoteChangeSummary next : unfiltered) {
            if (changeSetsToFilter.contains(PendingChangesUtil.getChangeSet(next.getActivity()))) continue;
            arrayList.add(next);
        }
        return arrayList;
    }

    private Set<IRemoteChangeSummary> getRemoteChangeSummaries(List sel) {
        HashSet result = NewCollection.hashSet();
        for (Object next : sel) {
            List changes;
            if (next instanceof IRemoteChangeSummary) {
                IRemoteChangeSummary summary = (IRemoteChangeSummary)next;
                result.add(summary);
                continue;
            }
            if (next instanceof IRemoteActivity) {
                IRemoteActivity activity = (IRemoteActivity)next;
                changes = activity.getChanges();
                result.addAll(changes);
                continue;
            }
            if (!(next instanceof IActivityFolder)) continue;
            IActivityFolder activityFolder = (IActivityFolder)next;
            changes = activityFolder.getChanges();
            result.addAll(changes);
        }
        return result;
    }

    private List<IRemoteActivity> getRemoteActivities(List sel) {
        ArrayList result = NewCollection.arrayList();
        for (Object next : sel) {
            if (!(next instanceof IRemoteActivity)) continue;
            result.add((IRemoteActivity)next);
        }
        return result;
    }
}

