/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.internal.calm.OslcLinkUtil;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.ui.item.AdapterUtil;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetInContextWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class CopyChangeSetWebURLAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        CopyChangeSetWebURLAction.copyToClipboard(this.getContext(), AdapterUtil.adaptList(selection.toList(), ChangeSetWrapper.class));
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(CopyChangeSetWebURLAction.shouldEnable(AdapterUtil.adaptList(((IStructuredSelection)selection).toList(), ChangeSetWrapper.class)));
    }

    public static boolean shouldEnable(List<ChangeSetWrapper> changeSets) {
        if (changeSets.isEmpty()) {
            return false;
        }
        for (ChangeSetWrapper changeSet : changeSets) {
            if (!(changeSet instanceof ChangeSetInContextWrapper)) {
                return false;
            }
            ChangeSetInContextWrapper inContext = (ChangeSetInContextWrapper)changeSet;
            if (inContext.getNamespace() instanceof WorkspaceNamespace) continue;
            return false;
        }
        return true;
    }

    public static void copyToClipboard(UIContext context, List<ChangeSetWrapper> changeSets) {
        if (changeSets.isEmpty()) {
            return;
        }
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        for (ChangeSetWrapper changeSet : changeSets) {
            ChangeSetInContextWrapper inContext;
            if (!(changeSet instanceof ChangeSetInContextWrapper) || !((inContext = (ChangeSetInContextWrapper)changeSet).getNamespace() instanceof WorkspaceNamespace)) continue;
            WorkspaceNamespace namespace = (WorkspaceNamespace)inContext.getNamespace();
            if (sb.length() > 0) {
                sb.append(lineSeparator);
            }
            String webURL = CopyChangeSetWebURLAction.getWebURL(changeSet, namespace);
            sb.append(webURL);
        }
        if (sb.length() > 0) {
            Clipboard cb = new Clipboard(context.getDisplay());
            TextTransfer textTransfer = TextTransfer.getInstance();
            cb.setContents(new Object[]{sb.toString()}, new Transfer[]{textTransfer});
            cb.dispose();
        }
    }

    private static String getWebURL(ChangeSetWrapper changeSet, WorkspaceNamespace namespace) {
        return OslcLinkUtil.getWebURL((ITeamRepository)changeSet.getRepository(), (IChangeSetHandle)changeSet.getChangeSet(), (IWorkspaceHandle)((IWorkspaceHandle)namespace.getWorkspaceId().toHandle())).toString();
    }
}

