/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.namespace.ItemFetcher;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.client.internal.namespace.impl.DescriptionRecord;
import com.ibm.team.filesystem.client.internal.namespace.impl.EraCache;
import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.filesystem.common.internal.util.ItemUtil;
import com.ibm.team.filesystem.ui.item.AdapterUtil;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class CopyChangeAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        CopyChangeAction.copyToClipboard(this.getContext(), AdapterUtil.adaptList(selection.toList(), ChangeSetWrapper.class));
    }

    public static void copyToClipboard(final UIContext context, final List<ChangeSetWrapper> changeSets) {
        if (changeSets.isEmpty()) {
            return;
        }
        HashSet<ITeamRepository> repos = new HashSet<ITeamRepository>();
        for (ChangeSetWrapper changeSet : changeSets) {
            ITeamRepository repo = changeSet.getRepository();
            if (repo == null) continue;
            repos.add(repo);
        }
        context.getUserOperationRunner().enqueue(Messages.CopyChangeAction_0, (Operation)new RepositoryOperation(repos){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                final HashMap<ItemLocator, DescriptionRecord> recs = new HashMap<ItemLocator, DescriptionRecord>();
                Map grouped = ChangeSetWrapper.groupByRepository(changeSets);
                HashSet<ItemLocator> components = new HashSet<ItemLocator>();
                final HashMap contributors = new HashMap();
                HashSet<ItemId> authors = new HashSet<ItemId>();
                SubMonitor loopProgress = SubMonitor.convert((IProgressMonitor)progress.newChild(80), (int)(changeSets.size() * 2));
                for (Map.Entry next : grouped.entrySet()) {
                    ITeamRepository repo = next.getKey();
                    List wrappers = next.getValue();
                    Map descriptions = EraCache.fetchDescriptions((ITeamRepository)repo, ChangeSetWrapper.getChangeSets(wrappers), (IRepositoryResolver)IRepositoryResolver.EXISTING_SHARED, (IProgressMonitor)loopProgress.newChild(1));
                    for (ChangeSetWrapper changeSetWrapper : wrappers) {
                        components.add(ItemLocator.create((ITeamRepository)repo, (ItemId)ItemUtil.getComponent((IComponentHandle)changeSetWrapper.getChangeSet().getComponent())));
                        ItemId currentAuthor = ChangeSetUtil.getAuthor((IChangeSet)changeSetWrapper.getChangeSet());
                        if (authors.contains(currentAuthor)) continue;
                        authors.add(currentAuthor);
                    }
                    for (Map.Entry entry : descriptions.entrySet()) {
                        recs.put(ItemLocator.create((ITeamRepository)repo, (ItemId)((ItemId)entry.getKey())), (DescriptionRecord)entry.getValue());
                    }
                    contributors.putAll(RepoFetcher.fetchCurrents((ITeamRepository)repo, authors, (IProgressMonitor)loopProgress.newChild(1)));
                    authors.clear();
                }
                final HashMap groupedByComponent = new HashMap();
                for (ChangeSetWrapper next : changeSets) {
                    IChangeSet nextChangeSet = next.getChangeSet();
                    CollectionUtil.addToMapOfLists(groupedByComponent, (Object)ItemLocator.create((ITeamRepository)next.getRepository(), (ItemId)ChangeSetUtil.getComponent((IChangeSet)nextChangeSet)), (Object)((Object)next));
                }
                final Map fetchedComponents = ItemFetcher.fetchCurrents(components, (boolean)false, (IProgressMonitor)progress.newChild(20));
                context.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Clipboard cb = new Clipboard(context.getDisplay());
                        StringBuffer sb = new StringBuffer();
                        String lineSeparator = System.getProperty("line.separator");
                        for (ItemLocator nextComponent : groupedByComponent.keySet()) {
                            IComponent component = (IComponent)fetchedComponents.get(nextComponent);
                            if (component != null) {
                                sb.append(component.getName());
                            }
                            sb.append(lineSeparator);
                            for (ChangeSetWrapper next : (List)groupedByComponent.get(nextComponent)) {
                                sb.append("\t");
                                DescriptionRecord rec = (DescriptionRecord)recs.get(ItemLocator.create((ITeamRepository)next.getRepository(), (IAuditableHandle)next.getChangeSet()));
                                if (rec != null) {
                                    sb.append(rec.getDescription());
                                    sb.append("\t");
                                    IContributor contributor = (IContributor)contributors.get(ItemId.create((IItemHandle)rec.getChangeSet().getAuthor()));
                                    if (contributor != null) {
                                        sb.append(contributor.getName());
                                    } else {
                                        sb.append(Messages.ChangeSetUnknownCreator);
                                    }
                                    sb.append("\t");
                                    sb.append(DateFormat.getDateTimeInstance().format(rec.getChangeSet().getLastChangeDate()));
                                }
                                sb.append(lineSeparator);
                            }
                        }
                        if (sb.length() > 0) {
                            TextTransfer textTransfer = TextTransfer.getInstance();
                            cb.setContents(new Object[]{sb.toString()}, new Transfer[]{textTransfer});
                        }
                        if (cb != null) {
                            cb.dispose();
                        }
                    }
                });
            }
        });
    }
}

