/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.ui.changes.views.DummyAction;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView;
import com.ibm.team.filesystem.ui.wrapper.ContributorWrapper;
import com.ibm.team.jface.viewerutilities.ContextMenuHelper;
import com.ibm.team.repository.common.IContributor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class ContributorContextMenu
extends MenuManager {
    private LocalWorkspaceChangesView viewPart;

    public ContributorContextMenu(LocalWorkspaceChangesView viewPart) {
        this.viewPart = viewPart;
        this.setRemoveAllWhenShown(true);
        this.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ContextMenuHelper.buildStandardContextMenuGroups((IMenuManager)ContributorContextMenu.this);
            }
        });
        this.add((IAction)new DummyAction());
    }

    private static IContributor getContributor(IStructuredSelection selection) {
        Object first = selection.getFirstElement();
        if (first instanceof IRemoteActivity) {
            return ((IRemoteActivity)first).getModifiedBy();
        }
        return null;
    }

    public static boolean isNeeded(IStructuredSelection selection) {
        return selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof IRemoteActivity;
    }

    public ISelectionProvider getSelectionProvider() {
        return new ISelectionProvider(){

            public ISelection getSelection() {
                IStructuredSelection sel = (IStructuredSelection)ContributorContextMenu.this.viewPart.getActiveViewer().getSelection();
                IContributor contributor = ContributorContextMenu.getContributor(sel);
                return contributor == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)new ContributorWrapper(contributor));
            }

            public void setSelection(ISelection selection) {
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }
        };
    }

    public String getMenuText() {
        IStructuredSelection sel = (IStructuredSelection)this.viewPart.getActiveViewer().getSelection();
        IContributor contributor = ContributorContextMenu.getContributor(sel);
        return contributor == null ? "" : contributor.getName();
    }
}

