/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.snapshot.WorkspaceId;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.IActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.internal.filesystem.ui.adapters.WrapperUtil;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangesViewConverter;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class CompareWorkspacesAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection sel) {
        if (sel.size() != 1) {
            return;
        }
        Object first = sel.getFirstElement();
        SnapshotId firstWorkspace = WrapperUtil.getSnapshotFromWrapper(first);
        if (firstWorkspace == null) {
            return;
        }
        ArrayList<IWorkspaceHandle> toIgnore = new ArrayList<IWorkspaceHandle>();
        if (firstWorkspace instanceof WorkspaceId) {
            WorkspaceId wid = (WorkspaceId)firstWorkspace;
            toIgnore.add((IWorkspaceHandle)wid.getId().toHandle());
        }
        ITeamRepository repo = null;
        repo = firstWorkspace.getRepository();
        SnapshotId second = WrapperUtil.getSnapshotFromWrapper((Object)WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream(shell, repo, null, null, WORKSPACES_OR_STREAMS.STREAMS, true, null, toIgnore, false));
        if (second != null) {
            ChangesViewConverter.compare(this.getContext(), firstWorkspace, second);
        }
    }

    private boolean shouldEnable(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        Object obj = selection.getFirstElement();
        if (obj == null) {
            return false;
        }
        IWorkspaceSyncContext workspaceSyncContext = ComponentSyncUtil.getWorkspaceContext((Object)obj);
        if (workspaceSyncContext == null) {
            return true;
        }
        IWorkspaceConnection workspaceConnection = workspaceSyncContext.getLocal();
        IActiveWorkspaceManager manager = FileSystemResourcesPlugin.getActiveWorkspaceManager();
        return manager.isWorkspaceTracked((IWorkspaceHandle)workspaceConnection.getResolvedWorkspace());
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(this.shouldEnable((IStructuredSelection)selection));
    }
}

