/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.internal.snapshot.BaselineSetId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.snapshot.WorkspaceId;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.IActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.ui.changes.actions.CompareWithSnapshotWizard;
import com.ibm.team.filesystem.ui.wrapper.SnapshotWrapper;
import com.ibm.team.internal.filesystem.ui.util.WorkspaceUtil;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangesViewConverter;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class CompareWorkspaceWithSnapshotAction
extends AbstractActionDelegate {
    public void run(Shell shell, final IWorkbenchPage page, IStructuredSelection sel) {
        if (sel.size() != 1) {
            return;
        }
        Object element = sel.getFirstElement();
        final ITeamRepository repo = WorkspaceUtil.getRepository(element);
        final IWorkspace workspace = WorkspaceUtil.getWorkspace(element);
        CompareWithSnapshotWizard.ICallback callback = new CompareWithSnapshotWizard.ICallback(){

            @Override
            public void compareWithSnapshot(SnapshotWrapper snapshot) {
                ChangesViewConverter.compare(page, (SnapshotId)WorkspaceId.create((ITeamRepository)repo, (IWorkspaceHandle)workspace), (SnapshotId)BaselineSetId.create((ITeamRepository)snapshot.getRepository(), (IBaselineSetHandle)snapshot.getSnapshot()));
            }
        };
        CompareWithSnapshotWizard wizard = new CompareWithSnapshotWizard(repo, callback);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.open();
    }

    private boolean shouldEnable(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        Object obj = selection.getFirstElement();
        if (obj == null) {
            return false;
        }
        IWorkspaceSyncContext workspaceSyncContext = ComponentSyncUtil.getWorkspaceContext((Object)obj);
        if (workspaceSyncContext == null) {
            return true;
        }
        IWorkspaceConnection workspaceConnection = workspaceSyncContext.getLocal();
        IActiveWorkspaceManager manager = FileSystemResourcesPlugin.getActiveWorkspaceManager();
        return manager.isWorkspaceTracked((IWorkspaceHandle)workspaceConnection.getResolvedWorkspace());
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(this.shouldEnable((IStructuredSelection)selection));
    }
}

