/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.internal.ClientRepositoryUtil;
import com.ibm.team.filesystem.client.internal.snapshot.BaselineSetId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.wrapper.SnapshotWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangesViewConverter;
import com.ibm.team.internal.filesystem.ui.wizards.AdvanceableWizard;
import com.ibm.team.internal.filesystem.ui.wizards.component.SnapshotPickerPage;
import com.ibm.team.internal.filesystem.ui.wizards.component.WorkspacePickerPage;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class CompareWithSnapshotWizard
extends AdvanceableWizard {
    private ITeamRepository repository;
    private ICallback callback;
    private final JobRunner rq = new JobRunner(Messages.CompareWithSnapshotWizard_CompareSnapshotJobName, false);
    private WorkspacePickerPage workspacePage;
    private SnapshotPickerPage snapshotPage;
    private List<? extends IBaselineSetHandle> toIgnore;

    public static void open(Shell shell, final IWorkbenchPage page, final IBaselineSet original) {
        final ITeamRepository repo = ClientRepositoryUtil.getRepository((IItemHandle)original);
        ICallback callback = new ICallback(){

            @Override
            public void compareWithSnapshot(SnapshotWrapper snapshot) {
                ChangesViewConverter.compare(page, (SnapshotId)BaselineSetId.create((ITeamRepository)repo, (IBaselineSetHandle)original), (SnapshotId)BaselineSetId.create((ITeamRepository)snapshot.getRepository(), (IBaselineSetHandle)snapshot.getSnapshot()));
            }
        };
        CompareWithSnapshotWizard wizard = new CompareWithSnapshotWizard(repo, Collections.singletonList(original), callback);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.open();
    }

    public CompareWithSnapshotWizard(ITeamRepository repo, ICallback callback) {
        this(repo, null, callback);
    }

    public CompareWithSnapshotWizard(ITeamRepository repo, List<? extends IBaselineSetHandle> toIgnore, ICallback callback) {
        Assert.isLegal((repo != null ? 1 : 0) != 0);
        Assert.isLegal((callback != null ? 1 : 0) != 0);
        this.repository = repo;
        this.toIgnore = toIgnore;
        this.callback = callback;
        this.setWindowTitle(Messages.CompareWithSnapshotWizard_CompareSnapshotTitle);
        this.setDefaultPageImageDescriptor(ImagePool.COMPARE_WITH_SNAPSHOT_WIZBAN);
    }

    public void addPages() {
        this.workspacePage = new WorkspacePickerPage(this.repository, null, WORKSPACES_OR_STREAMS.BOTH);
        this.workspacePage.setDescription(Messages.CompareWithSnapshotWizard_PickRepoMessage);
        this.addPage((IWizardPage)this.workspacePage);
        this.snapshotPage = new SnapshotPickerPage((IOperationRunner)this.rq);
        this.snapshotPage.setDescription(Messages.CompareWithSnapshotWizard_SelectSnapshotMessage);
        this.snapshotPage.setToIgnore(this.toIgnore);
        this.addPage((IWizardPage)this.snapshotPage);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.team.filesystem.ide.ui.wizard_comparewithsnapshot");
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.workspacePage) {
            this.snapshotPage.setWorkspace(this.workspacePage.getWorkspace());
            return this.snapshotPage;
        }
        return null;
    }

    public boolean performFinish() {
        SnapshotWrapper snapshot = this.snapshotPage.getSnapshot();
        this.callback.compareWithSnapshot(snapshot);
        return true;
    }

    public boolean canFinish() {
        return this.workspacePage != null && this.workspacePage.isPageComplete() && this.snapshotPage.isPageComplete();
    }

    public static interface ICallback {
        public void compareWithSnapshot(SnapshotWrapper var1);
    }
}

