/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.IActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.internal.filesystem.ui.adapters.WrapperUtil;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangesViewConverter;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class CompareSnapshotAction
extends AbstractActionDelegate {
    public static final String ACTION_ID_ON_WORKSPACES = "com.ibm.team.filesystem.actions.compareWorkspaces2";
    public static final String ACTION_ID_ON_SNAPSHOTS = "com.ibm.team.filesystem.actions.CompareSnapshotAction";

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        Object[] elements = selection.toArray();
        if (elements.length != 2) {
            return;
        }
        SnapshotId baselineSet1 = WrapperUtil.getSnapshotFromWrapper(elements[0]);
        SnapshotId baselineSet2 = WrapperUtil.getSnapshotFromWrapper(elements[1]);
        ChangesViewConverter.compare(this.getContext(), baselineSet1, baselineSet2);
    }

    private boolean shouldEnable(IStructuredSelection selection) {
        IWorkspaceConnection workspaceConnection;
        if (selection.size() != 2) {
            return false;
        }
        Iterator it = selection.iterator();
        Object obj1 = it.next();
        Object obj2 = it.next();
        if (obj1 == null || obj2 == null) {
            return false;
        }
        IWorkspaceSyncContext workspaceSyncContext1 = ComponentSyncUtil.getWorkspaceContext(obj1);
        IWorkspaceSyncContext workspaceSyncContext2 = ComponentSyncUtil.getWorkspaceContext(obj2);
        IActiveWorkspaceManager manager = FileSystemResourcesPlugin.getActiveWorkspaceManager();
        if (workspaceSyncContext1 != null && !manager.isWorkspaceTracked((IWorkspaceHandle)(workspaceConnection = workspaceSyncContext1.getLocal()).getResolvedWorkspace())) {
            return false;
        }
        return workspaceSyncContext2 == null || manager.isWorkspaceTracked((IWorkspaceHandle)(workspaceConnection = workspaceSyncContext2.getLocal()).getResolvedWorkspace());
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(this.shouldEnable((IStructuredSelection)selection));
    }
}

