/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.common.IChangeSummary;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.ide.ui.internal.util.ExternalCompareToolUtils;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.FileChangeFactory;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenFileItemInExternalCompareOperation;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenInExternalCompareDilemmaHandler;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileChangeEditorInput;
import com.ibm.team.filesystem.ui.changes.actions.OpenInCompareAction;
import com.ibm.team.filesystem.ui.changes.actions.OpenInExternalCompareAction;
import com.ibm.team.filesystem.ui.changes.configuration.ChangesSorter;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnOpenInExternalCompare;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class CompareFileChangesAction
extends AbstractActionDelegate {
    IRemoteChangeSummary change1;
    IRemoteChangeSummary change2;

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        IRemoteChangeSummary[] changes = CompareFileChangesAction.getChangesToCompare(selection);
        if (changes == null) {
            return;
        }
        IRemoteChangeSummary rcs1 = changes[0];
        IRemoteChangeSummary rcs2 = changes[1];
        CompareFileChangesAction.showInCompare(this.getContext(), rcs1, rcs2, false);
    }

    public static void showInCompare(final UIContext context, final IRemoteChangeSummary rcs1, final IRemoteChangeSummary rcs2, final boolean aggregate) {
        context.getUserOperationRunner().enqueue(Messages.CompareFileChangesAction_0, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                FileState afterState;
                FileState beforeState;
                int compare;
                HashSet<IRemoteChangeSummary> toFetch = new HashSet<IRemoteChangeSummary>();
                toFetch.add(rcs1);
                toFetch.add(rcs2);
                boolean getVersionIds = OpenInCompareAction.showVersionIdForCompare();
                Map fileChanges = FileChangeFactory.createFromRemoteSummaries(toFetch, (boolean)true, (boolean)getVersionIds, (IProgressMonitor)monitor);
                FileChange fc1 = (FileChange)fileChanges.get(rcs1);
                FileChange fc2 = (FileChange)fileChanges.get(rcs2);
                int n = compare = aggregate ? ChangesSorter.compare(rcs1, rcs2) : 0;
                if (compare == 1) {
                    beforeState = fc2.getNonDeleted(false);
                    afterState = fc1.getNonDeleted(false);
                } else {
                    beforeState = fc1.getNonDeleted(false);
                    afterState = fc2.getNonDeleted(false);
                }
                boolean useExternalCompareTool = ExternalCompareToolUtils.shouldUseExternalCompareTool(afterState.getPath().getName());
                if (useExternalCompareTool) {
                    final OpenInExternalCompareAction.ExternalCommandLinePreference externalCommandLinePreference = OpenInExternalCompareAction.get2WayRemoteCompareCommandLine();
                    String commandLine = externalCommandLinePreference.getCommandLine();
                    if (commandLine == null) {
                        final Shell shell = context.getShell();
                        SWTUtil.greedyExec((Display)shell.getDisplay(), (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (!shell.isDisposed()) {
                                    externalCommandLinePreference.openPreferenceDialog(shell, null);
                                }
                            }
                        });
                        return;
                    }
                    monitor.setTaskName(Messages.OpenInExternalCompareAction_2);
                    OpenFileItemInExternalCompareOperation externalCompareOperation = new OpenFileItemInExternalCompareOperation(commandLine, afterState, beforeState, (OpenInExternalCompareDilemmaHandler)new WarnOpenInExternalCompare(context));
                    externalCompareOperation.run(monitor);
                } else {
                    context.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            FileChangeEditorInput input = FileChangeEditorInput.createFrom((FileState)afterState, (FileState)beforeState, (boolean)false);
                            OpenInCompareAction.openCompareEditor((CompareEditorInput)input, context.getPage());
                        }
                    });
                }
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(CompareFileChangesAction.getChangesToCompare((IStructuredSelection)selection) != null);
    }

    private static IRemoteChangeSummary[] getChangesToCompare(IStructuredSelection selection) {
        Object[] elts;
        if (selection.size() == 2 && CompareFileChangesAction.check((elts = selection.toArray())[0]) && CompareFileChangesAction.check(elts[1]) && CompareFileChangesAction.sameType(elts[0], elts[1])) {
            return new IRemoteChangeSummary[]{(IRemoteChangeSummary)elts[0], (IRemoteChangeSummary)elts[1]};
        }
        return null;
    }

    private static boolean sameType(Object e1, Object e2) {
        IRemoteChangeSummary change1 = (IRemoteChangeSummary)e1;
        IChangeSummary cs1 = change1.getChangeSummary();
        IRemoteChangeSummary change2 = (IRemoteChangeSummary)e2;
        IChangeSummary cs2 = change2.getChangeSummary();
        return cs1.item().getItemType().equals(cs2.item().getItemType());
    }

    private static boolean check(Object elt) {
        if (!(elt instanceof IRemoteChangeSummary)) {
            return false;
        }
        IRemoteChangeSummary change = (IRemoteChangeSummary)elt;
        IChangeSummary changeSummary = change.getChangeSummary();
        return changeSummary != null;
    }
}

