/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class CombineDeleteAddAction
extends AbstractActionDelegate {
    private ILocalChange changeDeletion = null;
    private ILocalChange changeAddition = null;

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection sel) {
        if (this.changeDeletion == null || this.changeAddition == null) {
            return;
        }
        if (!this.confirmCombine(shell, this.changeDeletion.getPath().toString(), this.changeAddition.getPath().toString())) {
            return;
        }
        final ILocalChange deletion = this.changeDeletion;
        final ILocalChange addition = this.changeAddition;
        new Job(Messages.CombineChangesAction_0){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    return CombineDeleteAddAction.this.combineChanges(deletion, addition, monitor);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    return new Status(4, "com.ibm.team.filesystem.ide.ui", Messages.CombineChangesAction_2, (Throwable)e);
                }
            }
        }.schedule();
    }

    private boolean confirmCombine(Shell shell, String path1, String path2) {
        String message = NLS.bind((String)Messages.CombineChangesAction_Dialog_Message, (Object)path1, (Object)path2);
        return MessageDialog.openQuestion((Shell)shell, (String)Messages.CombineChangesAction_0, (String)message);
    }

    private IStatus combineChanges(ILocalChange deletion, ILocalChange addition, IProgressMonitor monitor) throws TeamRepositoryException, CoreException {
        try {
            monitor.beginTask(Messages.CombineChangesAction_3, 100);
            LocalChangeManager lcm = (LocalChangeManager)FileSystemCore.getSharingManager().getLocalChangeManager();
            lcm.combineDeleteAdd(IRepositoryResolver.EXISTING_SHARED, deletion, addition, monitor);
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.changeDeletion = null;
        this.changeAddition = null;
        super.selectionChanged(action, selection);
        List list = ((IStructuredSelection)selection).toList();
        Set contexts = ComponentSyncUtil.getContexts((Collection)list);
        if (!ComponentSyncUtil.allLoggedIn((Collection)contexts)) {
            action.setEnabled(false);
            return;
        }
        Set[] result = ComponentSyncUtil.filter((Collection)list, (Class[])new Class[]{ILocalChange.class, Object.class});
        Set localChanges = result[0];
        if (!result[1].isEmpty() || !CombineDeleteAddAction.validateSelection(localChanges)) {
            action.setEnabled(false);
            return;
        }
        for (ILocalChange change : localChanges) {
            if (change.isType(4)) {
                this.changeDeletion = change;
            }
            if (!change.isType(2)) continue;
            this.changeAddition = change;
        }
        action.setEnabled(true);
    }

    private static boolean validateSelection(Set<ILocalChange> localChanges) {
        if (localChanges.size() == 2) {
            ILocalChange deletion = null;
            ILocalChange addition = null;
            for (ILocalChange change : localChanges) {
                if (change.isType(4)) {
                    deletion = change;
                }
                if (!change.isType(2)) continue;
                addition = change;
            }
            if (deletion != null && addition != null) {
                if (!deletion.getConnection().sameItemId((IItemHandle)addition.getConnection())) {
                    return false;
                }
                return deletion.getComponent().sameItemId((IItemHandle)addition.getComponent());
            }
        }
        return false;
    }
}

