/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.OperationFactory;
import com.ibm.team.filesystem.client.operations.CloseChangeSetsDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICloseChangeSetsOperation;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnCloseChangeSets;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class CloseAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        Set<IRemoteActivity> activities = this.getActivities(selection);
        if (activities == null) {
            return;
        }
        CloseAction.close(shell, this.getOperationRunner(), activities);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        Set<IRemoteActivity> activities = this.getActivities((IStructuredSelection)selection);
        action.setEnabled(activities != null);
    }

    private Set<IRemoteActivity> getActivities(IStructuredSelection selection) {
        List list = selection.toList();
        Set[] result = ComponentSyncUtil.filter((Collection)list, (Class[])new Class[]{IRemoteActivity.class, Object.class});
        if (!result[0].isEmpty() && result[1].isEmpty()) {
            for (IRemoteActivity activity : result[0]) {
                if (activity.getActivitySource().getModel().isActive(activity)) continue;
                return null;
            }
            return result[0];
        }
        return null;
    }

    public static void close(final Shell shell, IOperationRunner runner, final Collection<IRemoteActivity> activities) {
        runner.enqueue(Messages.CloseAction_JOB_NAME, (Operation)new RepositoryOperation(ComponentSyncUtil.getTeamRepositories(activities)){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                try {
                    Set contexts = ComponentSyncUtil.getWorkspaceContexts((Collection)activities);
                    for (IWorkspaceSyncContext workspaceContext : contexts) {
                        IWorkspaceConnection wc = workspaceContext.getLocal();
                        ICloseChangeSetsOperation op = OperationFactory.getInstance().getCloseChangeSetsOperation((CloseChangeSetsDilemmaHandler)new WarnCloseChangeSets(shell, wc));
                        op.setContext(wc);
                        List changeSets = ComponentSyncUtil.getChangeSetHandles((Collection)ComponentSyncUtil.filter((Collection)activities, (IWorkspaceSyncContext)workspaceContext));
                        op.ensureClosed(changeSets);
                        op.run(monitor);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
    }
}

