/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.ide.ui.internal.actions.load.LoadAction;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.IActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.ui.changes.actions.OpenTeamPlaceAction;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.actions.components.LoadComponentsAction;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;

public class CheckoutAction
extends AbstractActionDelegate {
    List elements;

    public static List convertSelection(Collection selection, boolean excludeStream) {
        ArrayList<AbstractWrapper> elements = new ArrayList<AbstractWrapper>();
        for (Object obj : selection) {
            IComponentSyncContext context;
            if (obj instanceof IWorkspaceSyncContext) {
                AbstractWrapper wrapper = OpenTeamPlaceAction.getAbstractWrapper(obj);
                if (excludeStream) {
                    if (!(wrapper instanceof ContributorPlaceWrapper)) continue;
                    elements.add((AbstractPlaceWrapper)wrapper);
                    continue;
                }
                if (!(wrapper instanceof AbstractPlaceWrapper)) continue;
                elements.add((AbstractPlaceWrapper)wrapper);
                continue;
            }
            if (!(obj instanceof IComponentSyncContext) || !(context = (IComponentSyncContext)obj).isLocal()) continue;
            elements.add(WorkspaceComponentWrapper.newWrapper(context.getWorkspaceSyncContext().getLocal(), context.getComponent()));
        }
        return elements;
    }

    public static boolean hasOnlyComponents(List elements) {
        for (Object obj : elements) {
            if (obj instanceof ContributorPlaceComponentWrapper) continue;
            return false;
        }
        return true;
    }

    public static boolean hasOnlyWorkspaces(List elements) {
        for (Object obj : elements) {
            if (obj instanceof ContributorPlaceWrapper) continue;
            return false;
        }
        return true;
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        if (this.elements == null || this.elements.isEmpty()) {
            return;
        }
        if (CheckoutAction.hasOnlyWorkspaces(this.elements)) {
            LoadAction checkoutSelectedComponentsAction = new LoadAction();
            checkoutSelectedComponentsAction.init((IViewPart)this.getPart());
            checkoutSelectedComponentsAction.run(shell, page, (IStructuredSelection)new StructuredSelection(this.elements));
        } else if (CheckoutAction.hasOnlyComponents(this.elements)) {
            LoadComponentsAction loadComponentsAction = new LoadComponentsAction();
            loadComponentsAction.init((IViewPart)this.getPart());
            loadComponentsAction.run(shell, page, (IStructuredSelection)new StructuredSelection(this.elements));
        }
    }

    private boolean containsUntrackedWorkspace(IStructuredSelection selection) {
        IActiveWorkspaceManager manager = FileSystemResourcesPlugin.getActiveWorkspaceManager();
        List selectionList = selection.toList();
        Set workspaceContexts = ComponentSyncUtil.getWorkspaceContexts((Collection)selectionList);
        boolean containsUntrackedWorkspace = false;
        for (IWorkspaceSyncContext nextContext : workspaceContexts) {
            IWorkspaceConnection wc = nextContext.getLocal();
            if (manager.isWorkspaceTracked((IWorkspaceHandle)wc.getResolvedWorkspace())) continue;
            containsUntrackedWorkspace = true;
            break;
        }
        return containsUntrackedWorkspace;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        this.elements = null;
        if (selection instanceof IStructuredSelection) {
            if (this.containsUntrackedWorkspace((IStructuredSelection)selection)) {
                action.setEnabled(false);
                return;
            }
            Collection list = null;
            Set[] result = ComponentSyncUtil.filter((Collection)((IStructuredSelection)selection).toList(), (Class[])new Class[]{IWorkspaceSyncContext.class, IComponentSyncContext.class, Object.class});
            if (result[0].size() == 1 && result[1].isEmpty() && result[2].isEmpty()) {
                list = result[0];
            }
            if (result[0].isEmpty() && !result[1].isEmpty() && result[2].isEmpty() && ComponentSyncUtil.allLocal((Collection)result[1])) {
                boolean isStream = false;
                for (IComponentSyncContext context : result[1]) {
                    if (!context.getOutgoingTeamPlace().isStream()) continue;
                    isStream = true;
                    break;
                }
                if (!isStream) {
                    list = ComponentSyncUtil.filterComponentContextTwins((Collection)result[1]);
                }
            }
            if (list != null) {
                this.elements = CheckoutAction.convertSelection(list, true);
            }
        }
        action.setEnabled(this.elements != null && this.elements.size() > 0);
    }
}

