/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnCommitUser;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class CheckinAllAction
extends AbstractActionDelegate {
    public void run(final Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        List list = selection.toList();
        final Collection<IComponentSyncContext> contexts = CheckinAllAction.getContexts(list);
        this.getOperationRunner().enqueue(this.getOperationName(), (Operation)new RepositoryOperation(ComponentSyncUtil.getTeamRepositories((Collection)list)){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                try {
                    WarnCommitUser problemHandler = new WarnCommitUser(shell, CheckinAllAction.this.getOperationName());
                    for (IComponentSyncContext context : contexts) {
                        List localChanges;
                        if (!context.isLocal() || (localChanges = context.getLocalChangeSource().getLocalChanges()).isEmpty()) continue;
                        context.autoCommitLocalChanges((Collection)localChanges, false, (CommitDilemmaHandler)problemHandler, monitor);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
    }

    private String getOperationName() {
        return Messages.CheckinAllAction_0;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(CheckinAllAction.getContexts(((IStructuredSelection)selection).toList()) != null);
    }

    private static Collection<IComponentSyncContext> getContexts(List selection) {
        Set contexts = ComponentSyncUtil.getContexts((Collection)selection);
        if (CheckinAllAction.hasLocalChanges(contexts)) {
            return contexts;
        }
        return null;
    }

    private static boolean hasLocalChanges(Collection<IComponentSyncContext> contexts) {
        for (IComponentSyncContext context : contexts) {
            if (!context.isLocal() || context.getLocalChangeSource().size() == 0) continue;
            return true;
        }
        return false;
    }
}

