/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteActivity;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnCommitUser;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.common.ItemAlreadyInActiveChangeSetException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class CheckIntoChangeSetAction {
    public static void run(final Shell shell, final IComponentSyncContext context, final IOutgoingRemoteActivity target, final Collection<ILocalChange> changes) {
        JobRunner runner = new JobRunner(true);
        runner.enqueue(Messages.ChangesDropTargetAdapter_3, (Operation)new RepositoryOperation(target.getActivitySource().getModel().localTeamRepository()){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                try {
                    try {
                        monitor.beginTask(Messages.ChangesDropTargetAdapter_4, 100);
                        context.commitLocalChanges(target, changes, (CommitDilemmaHandler)new WarnCommitUser(shell, Messages.ChangesDropTargetAdapter_3), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                        context.refresh(false, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    }
                    catch (TeamRepositoryException e) {
                        final String errorTitle = Messages.ChangesDropTargetAdapter_3;
                        final String errorMsg = e.getMessage();
                        if (e instanceof ItemAlreadyInActiveChangeSetException) {
                            if (e.getMessage() != null && shell != null && !shell.isDisposed()) {
                                shell.getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        MessageDialog.openError((Shell)shell, (String)errorTitle, (String)errorMsg);
                                    }
                                });
                            } else {
                                problems.reportException((Throwable)e);
                                problems.setProblemSummary(errorTitle, errorMsg);
                            }
                        } else {
                            problems.reportException((Throwable)e);
                            problems.setProblemSummary(errorTitle, errorMsg);
                        }
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
    }
}

