/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.actions.ActionGroup;

public class ChangesViewFilterActionGroup
extends ActionGroup
implements IPropertyChangeListener {
    List<PreferenceAction> actions = new ArrayList<PreferenceAction>();

    public ChangesViewFilterActionGroup() {
        this.actions.add(new PreferenceAction(Messages.ChangesViewFilterActionGroup_ShowComponentsNotLoadedPreference, "com.ibm.team.filesystem.ide.ui.show_not_loaded_components"));
        this.actions.add(new PreferenceAction(Messages.ChangesViewFilterActionGroup_ShowUnchangedComponentsPreference, "com.ibm.team.filesystem.ide.ui.prefs_show_with_no_changes"));
        this.actions.add(new PreferenceAction(Messages.ChangesViewFilterActionGroup_ShowUntrackedWorkspacesPreference, "com.ibm.team.filesystem.ide.ui.prefs_show_untracked_workspaces"));
        this.actions.add(new PreferenceAction(Messages.ChangesViewFilterActionGroup_ShowAddedOrRemovedComponentPreference, "com.ibm.team.filesystem.ide.ui.show_added_removed_components"));
        UiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void fillContextMenu(IMenuManager menu) {
        for (PreferenceAction action : this.actions) {
            action.update();
            menu.add((IAction)action);
        }
    }

    public void dispose() {
        super.dispose();
        UiPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    private void update() {
        for (PreferenceAction action : this.actions) {
            action.update();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.update();
    }

    private static class PreferenceAction
    extends Action {
        private final String pref;
        private IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();

        PreferenceAction(String label, String pref) {
            this.pref = pref;
            this.setText(label);
        }

        public void run() {
            boolean current = this.getCurrent();
            this.store.setValue(this.pref, !current);
        }

        private boolean getCurrent() {
            return this.store.getBoolean(this.pref);
        }

        public void update() {
            this.setChecked(this.getCurrent());
        }
    }
}

