/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.operations.AutoResolveConflictsDilemmaHandler;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedFolder;
import com.ibm.team.filesystem.rcp.ui.internal.util.StandardAutoResolveDilemmaHandler;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.changes.actions.ResolveWithProposed;
import com.ibm.team.filesystem.ui.operations.AutoResolveLocalOperation;
import com.ibm.team.filesystem.ui.operations.AutoResolveOperation;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.ListDialog;

public class AutoResolveAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        Set[] filtered = ComponentSyncUtil.filter((Collection)selection.toList(), (Class[])new Class[]{IConflictItem.class, ILocalConflictItem.class});
        Set conflictItems = filtered[0];
        Set localConflictItems = filtered[1];
        UIContext context = this.getContext();
        if (conflictItems.isEmpty() && localConflictItems.isEmpty()) {
            MessageDialogFactory.showMessage((Shell)context.getShell(), (String)Messages.AutoResolveAction_0, (IStatus)StatusUtil.newStatus(AutoResolveAction.class, (int)4, (String)Messages.AutoResolveAction_1));
            return;
        }
        if (!conflictItems.isEmpty() && !localConflictItems.isEmpty()) {
            DialogUtil.pauseIfNeededBeforeShowingDialog();
            int code = JFaceUtils.showMessageButtonsBlocking((String)Messages.AutoResolveAction_11, (String)Messages.AutoResolveAction_12, (String[])new String[]{Messages.AutoResolveAction_LocalConflict, Messages.AutoResolveAction_RemoteConflict, Messages.PreferencesListener_14}, (int)4, (int)2);
            switch (code) {
                case 0: {
                    AutoResolveAction.autoResolveLocalConflict(context, localConflictItems);
                    break;
                }
                case 1: {
                    AutoResolveAction.autoResolve(context, conflictItems);
                }
            }
            return;
        }
        if (!conflictItems.isEmpty()) {
            AutoResolveAction.autoResolve(context, conflictItems);
        }
        if (!localConflictItems.isEmpty()) {
            AutoResolveAction.autoResolveLocalConflict(context, localConflictItems);
        }
    }

    public static void autoResolve(final UIContext context, final Collection<IConflictItem> items) {
        if (items.size() == 0) {
            MessageDialogFactory.showMessage((Shell)context.getShell(), (String)Messages.AutoResolveAction_0, (IStatus)StatusUtil.newStatus(AutoResolveAction.class, (int)4, (String)Messages.AutoResolveAction_1));
            return;
        }
        ArrayList autoResolveItems = NewCollection.arrayList();
        for (IConflictItem conflict : items) {
            if (conflict.getType() != 3) continue;
            autoResolveItems.add(conflict);
        }
        if (autoResolveItems.size() > 0) {
            String message = autoResolveItems.size() == 1 ? Messages.AutoResolveAction_2 : Messages.AutoResolveAction_3;
            ArrayList<ILogicalChange> autoResolveChanges = new ArrayList<ILogicalChange>(autoResolveItems.size());
            for (IConflictItem autoResolveItem : autoResolveItems) {
                autoResolveChanges.add(autoResolveItem.getLogicalChange());
            }
            ListDialog dialog = ResolveWithProposed.createConflictDialog(context.getShell(), autoResolveChanges, Messages.AutoResolveAction_5, message);
            if (dialog.open() != 0) {
                return;
            }
        }
        final StandardAutoResolveDilemmaHandler dilemmaHandler = new StandardAutoResolveDilemmaHandler(context, true);
        context.getUserOperationRunner().enqueue(Messages.AutoResolveAction_6, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                ArrayList<IConflictItem> filtered = new ArrayList<IConflictItem>();
                List<IConflictItem> conflictedItems = AutoResolveAction.getConflictedItems();
                ArrayList<IConflictItem> unloadedItems = new ArrayList<IConflictItem>();
                for (IConflictItem item : items) {
                    if (conflictedItems.contains(item)) {
                        filtered.add(item);
                        continue;
                    }
                    unloadedItems.add(item);
                }
                if (filtered.isEmpty()) {
                    if (!unloadedItems.isEmpty()) {
                        final String unloadedComponentName = ((IConflictItem)unloadedItems.get(0)).getComponentSyncContext().getComponent().getName();
                        context.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openWarning((Shell)context.getShell(), (String)Messages.AutoResolveAction_7, (String)NLS.bind((String)Messages.AutoResolveAction_15, (Object)unloadedComponentName));
                            }
                        });
                    }
                    return;
                }
                AutoResolveOperation autoResolveOp = new AutoResolveOperation(filtered, (AutoResolveConflictsDilemmaHandler)dilemmaHandler);
                autoResolveOp.repositoryRun(monitor, problems);
                final int result = autoResolveOp.numberOfConflictsResolved();
                if (result < filtered.size()) {
                    boolean stillHasConflict = false;
                    Iterator iter1 = filtered.iterator();
                    while (!stillHasConflict && iter1.hasNext()) {
                        IVersionableHandle one = ((IConflictItem)iter1.next()).getItem();
                        Iterator<IConflictItem> iter2 = AutoResolveAction.getConflictedItems().iterator();
                        while (!stillHasConflict && iter2.hasNext()) {
                            IVersionableHandle two = iter2.next().getItem();
                            if (one != null && two != null && !one.getItemId().equals((Object)two.getItemId())) continue;
                            stillHasConflict = true;
                        }
                    }
                    if (!stillHasConflict) {
                        return;
                    }
                    context.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (result == 0) {
                                MessageDialog.openWarning((Shell)context.getShell(), (String)Messages.AutoResolveAction_7, (String)Messages.AutoResolveAction_8);
                            } else {
                                MessageDialog.openWarning((Shell)context.getShell(), (String)Messages.AutoResolveAction_9, (String)Messages.AutoResolveAction_10);
                            }
                        }
                    });
                }
            }
        });
    }

    public static void autoResolveLocalConflict(final UIContext context, final Collection<ILocalConflictItem> autoResolvedItems) {
        final BackupDilemmaHandler dilemmaHandler = new BackupDilemmaHandler(){

            public boolean backupEnabled() {
                return false;
            }
        };
        context.getUserOperationRunner().enqueue(Messages.AutoResolveAction_6, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                AutoResolveLocalOperation autoResolveOp = new AutoResolveLocalOperation(autoResolvedItems, dilemmaHandler);
                autoResolveOp.repositoryRun(monitor, problems);
                final int result = autoResolveOp.numberOfConflictsResolved();
                if (result < autoResolvedItems.size()) {
                    boolean stillHasConflict = false;
                    Set<UUID> remainingLocalConflictItems = AutoResolveAction.getLocalConflictedItems();
                    Iterator iter1 = autoResolvedItems.iterator();
                    while (!stillHasConflict && iter1.hasNext()) {
                        IVersionableHandle one = ((ILocalConflictItem)iter1.next()).getItem();
                        if (one != null && !remainingLocalConflictItems.contains(one.getItemId())) continue;
                        stillHasConflict = true;
                    }
                    if (!stillHasConflict) {
                        return;
                    }
                    context.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (result == 0) {
                                MessageDialog.openWarning((Shell)context.getShell(), (String)Messages.AutoResolveAction_7, (String)Messages.AutoResolveAction_13);
                            } else {
                                MessageDialog.openWarning((Shell)context.getShell(), (String)Messages.AutoResolveAction_9, (String)Messages.AutoResolveAction_14);
                            }
                        }
                    });
                }
            }
        });
    }

    public static List<IConflictItem> getConflictedItems() {
        ArrayList<IConflictItem> conflictedItems = new ArrayList<IConflictItem>();
        IComponentSyncContext[] iComponentSyncContextArray = FileSystemResourcesPlugin.getComponentSyncModel().getComponentSyncContexts();
        int n = iComponentSyncContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentSyncContext context = iComponentSyncContextArray[n2];
            conflictedItems.addAll(context.getOutgoingActivitySource().getConflictItems());
            ++n2;
        }
        return conflictedItems;
    }

    public static Set<UUID> getLocalConflictedItems() throws FileSystemException, TeamRepositoryException {
        FileSystemResourcesPlugin.getComponentSyncModel().refresh(true, null);
        HashSet<UUID> localConflictedItemsIds = new HashSet<UUID>();
        IComponentSyncContext[] iComponentSyncContextArray = FileSystemResourcesPlugin.getComponentSyncModel().getComponentSyncContexts();
        int n = iComponentSyncContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentSyncContext context = iComponentSyncContextArray[n2];
            if (!ComponentSyncUtil.isDisconnected((IComponentSyncContext)context)) {
                Collection folders = context.getUnresolvedSource().getFolders();
                for (IUnresolvedFolder folder : folders) {
                    Collection localConflictItems = folder.getLocalConflictItems();
                    for (ILocalConflictItem item : localConflictItems) {
                        localConflictedItemsIds.add(item.getItem().getItemId());
                    }
                }
            }
            ++n2;
        }
        return localConflictedItemsIds;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        IStructuredSelection ss = (IStructuredSelection)selection;
        Set[] filtered = ComponentSyncUtil.filter((Collection)ss.toList(), (Class[])new Class[]{IConflictItem.class, ILocalConflictItem.class});
        action.setEnabled(!filtered[0].isEmpty() || !filtered[1].isEmpty());
    }
}

