/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.operations.CreateCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICreateCurrentPatchOperation;
import com.ibm.team.filesystem.client.operations.UpdateCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.OpenPortEditorAction;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentConflictUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncContext;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesViewLabelProvider;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnAutoResolveDilemmaHandler;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentPatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

public class ApplyToOtherComponentAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        List conflictItems = selection.toList();
        IWorkspaceConnection workspaceConnection = this.getWorkspaceConnection((IConflictItem)conflictItems.get(0));
        try {
            IComponent component = this.promptForComponent(workspaceConnection, conflictItems);
            if (component != null) {
                ICurrentPatch currentPort = workspaceConnection.getCurrentPatch((IComponentHandle)component);
                if (currentPort != null) {
                    JFaceUtils.showMessage((String)Messages.ApplyToOtherComponentAction_0, (String)Messages.ApplyToOtherComponentAction_1, (int)4);
                    return;
                }
                this.performApply(workspaceConnection, component, conflictItems);
            }
        }
        catch (TeamRepositoryException e) {
            JFaceUtils.showError(null, (String)e.getMessage(), (Throwable)e);
            StatusUtil.log((Object)((Object)UiPlugin.getDefault()), (Throwable)e);
        }
    }

    private IComponent promptForComponent(IWorkspaceConnection workspaceConnection, List<IConflictItem> conflictItems) throws TeamRepositoryException {
        List<IComponentSyncContext> pickerInput = this.getComponentSyncContexts(workspaceConnection, conflictItems);
        Collections.sort(pickerInput, new Comparator<IComponentSyncContext>(){

            @Override
            public int compare(IComponentSyncContext object1, IComponentSyncContext object2) {
                return object1.getComponent().getName().compareToIgnoreCase(object2.getComponent().getName());
            }
        });
        ListDialog dialog = new ListDialog(this.getContext().getShell()){

            protected Control createDialogArea(Composite container) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "com.ibm.team.filesystem.ide.ui.dialog_applyconflicttocomponent_componentpicker");
                return super.createDialogArea(container);
            }
        };
        dialog.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
        dialog.setLabelProvider((ILabelProvider)new LocalWorkspaceChangesViewLabelProvider());
        dialog.setInput(pickerInput);
        dialog.setTitle(Messages.ApplyToOtherComponentAction_2);
        dialog.setMessage(Messages.ApplyToOtherComponentAction_3);
        dialog.open();
        Object[] selection = dialog.getResult();
        if (selection != null && selection.length != 0) {
            ComponentSyncContext csc = (ComponentSyncContext)selection[0];
            return csc.getComponent();
        }
        return null;
    }

    private List<IComponentSyncContext> getComponentSyncContexts(IWorkspaceConnection workspaceConnection, List<IConflictItem> conflictItems) throws TeamRepositoryException {
        HashSet<UUID> componentsOfConflicts = new HashSet<UUID>();
        for (IConflictItem conflict : conflictItems) {
            componentsOfConflicts.add(conflict.getItemConflictReport().getComponent().getItemId());
        }
        ComponentSyncContext context = (ComponentSyncContext)conflictItems.get(0).getOutgoingActivitySource().getModel();
        IComponentSyncModel model = context.getComponentSyncModel();
        ArrayList<IComponentSyncContext> result = new ArrayList<IComponentSyncContext>();
        for (Object o : workspaceConnection.getComponents()) {
            IComponentSyncContext[] componentSyncContexts;
            IComponentHandle ch = (IComponentHandle)o;
            if (componentsOfConflicts.contains(ch.getItemId()) || (componentSyncContexts = model.getComponentSyncContexts((IConnection)workspaceConnection, ch)).length <= 0) continue;
            result.add(componentSyncContexts[0]);
        }
        return result;
    }

    private void performApply(final IWorkspaceConnection workspaceConnection, final IComponent component, List<IConflictItem> conflictItems) throws TeamRepositoryException {
        final WarnAutoResolveDilemmaHandler updateHandler = new WarnAutoResolveDilemmaHandler(this.getContext().getShell());
        CreateCurrentPatchDilemmaHandler dilemmaHandler = new CreateCurrentPatchDilemmaHandler(){

            public UpdateCurrentPatchDilemmaHandler getUpdateCurrentPortDilemmaHandler() {
                return updateHandler;
            }
        };
        final ICreateCurrentPatchOperation op = IOperationFactory.instance.getCreateCurrentPatchOperation(dilemmaHandler);
        op.setContext(workspaceConnection, (IComponentHandle)component);
        boolean hasActualConflict = false;
        for (IConflictItem item : conflictItems) {
            ILogicalChange conflict = item.getLogicalChange();
            if (!this.isPatchableConflict(conflict)) continue;
            op.applyConflict(conflict);
            hasActualConflict = true;
        }
        if (hasActualConflict) {
            this.getOperationRunner().enqueue(Messages.MoveConflictedItemAction_2, (Operation)new RepositoryOperation(){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                    op.run(monitor);
                    ApplyToOtherComponentAction.this.openGapEditor(ApplyToOtherComponentAction.this.getContext().getShell(), workspaceConnection, component);
                }
            });
        }
    }

    private void openGapEditor(Shell shell, final IWorkspaceConnection workspace, final IComponent component) {
        final Display display = shell.getDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!display.isDisposed() && workspace.getCurrentPatch((IComponentHandle)component) != null) {
                        OpenPortEditorAction.openPortEditor(ApplyToOtherComponentAction.this.getPage(), workspace, component, "com.ibm.team.internal.filesystem.ui.editors.port.CurrentPortPage");
                    }
                }
            });
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        Set[] result = ComponentSyncUtil.filter((Collection)((IStructuredSelection)selection).toList(), (Class[])new Class[]{IConflictItem.class, Object.class});
        boolean enable = false;
        IWorkspaceConnection connection = null;
        if (result[1].isEmpty()) {
            for (IConflictItem conflictItem : result[0]) {
                ILogicalChange logicalChange = conflictItem.getLogicalChange();
                if (!ComponentConflictUtil.isStructuralChange((ILogicalChange)logicalChange)) {
                    enable = false;
                    break;
                }
                if (!this.isPatchableConflict(logicalChange)) {
                    if (logicalChange.kind() == 3) continue;
                    enable = false;
                    break;
                }
                if (connection == null) {
                    connection = this.getWorkspaceConnection(conflictItem);
                } else if (!connection.getContextHandle().sameItemId((IItemHandle)this.getWorkspaceConnection(conflictItem).getContextHandle())) {
                    enable = false;
                    break;
                }
                enable = true;
            }
        }
        action.setEnabled(enable);
    }

    private IWorkspaceConnection getWorkspaceConnection(IConflictItem conflictItem) {
        ComponentSyncContext context = (ComponentSyncContext)conflictItem.getOutgoingActivitySource().getModel();
        return context.getOutgoingTeamPlace();
    }

    private IWorkbenchPage getPage() {
        if (this.getPart() == null || this.getPart().getSite() == null) {
            return null;
        }
        return this.getPart().getSite().getPage();
    }

    private boolean isPatchableConflict(ILogicalChange conflict) {
        return conflict.kind() != 3 || !conflict.isChangeType(2);
    }
}

