/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.common.changemodel.ChangeDescription;
import com.ibm.team.filesystem.common.changemodel.ConfigurationChange;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.CopyFileAreaPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.ui.changemodel.UIConfigurationChangeFactory;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetInContextWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.patches.ApplyPatchUtil;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class ApplyAsPatchAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        IRemoteActivity activity = (IRemoteActivity)selection.getFirstElement();
        ApplyAsPatchAction.applyAsPatch(this.getContext(), activity);
    }

    public static void applyAsPatch(final UIContext context, final IWorkspaceConnection wc, final List<IChangeSetHandle> changeSetsWithGap) {
        context.getUserOperationRunner().enqueue(Messages.ApplyAsPatchAction_0, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                List changeSets = wc.teamRepository().itemManager().fetchCompleteItems(changeSetsWithGap, 0, (IProgressMonitor)progress.newChild(10));
                ArrayList<ChangeSetInContextWrapper> wrappers = new ArrayList<ChangeSetInContextWrapper>();
                for (IChangeSet changeSet : changeSets) {
                    WorkspaceNamespace namespace = WorkspaceNamespace.create((IWorkspaceConnection)wc, (IComponentHandle)changeSet.getComponent());
                    wrappers.add(new ChangeSetInContextWrapper((ItemNamespace)namespace, changeSet));
                }
                ConfigurationChange change = UIConfigurationChangeFactory.createChangeForChangeSets(wrappers, (IProgressMonitor)progress.newChild(25));
                ChangeDescription description = UIConfigurationChangeFactory.createDescriptionForWrappers(wrappers, (IProgressMonitor)progress.newChild(25));
                ApplyPatchUtil.applyPatch(context, change, description, (IPathResolver)CopyFileAreaPathResolver.create(), (IProgressMonitor)progress.newChild(50));
            }
        });
    }

    public static void applyAsPatch(final UIContext context, IRemoteActivity activity) {
        final ChangeSetInContextWrapper changeSet = (ChangeSetInContextWrapper)((Object)Adapters.getAdapter((Object)activity, ChangeSetInContextWrapper.class));
        context.getUserOperationRunner().enqueue(Messages.ApplyAsPatchAction_0, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                ConfigurationChange change = UIConfigurationChangeFactory.createChangeForChangeSets(Collections.singletonList(changeSet), (IProgressMonitor)progress.newChild(25));
                ChangeDescription description = UIConfigurationChangeFactory.createDescriptionForWrappers(Collections.singletonList(changeSet), (IProgressMonitor)progress.newChild(25));
                ApplyPatchUtil.applyPatch(context, change, description, (IPathResolver)CopyFileAreaPathResolver.create(), (IProgressMonitor)progress.newChild(50));
            }
        });
    }
}

