/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.WorkspaceUpdateUtil;
import com.ibm.team.filesystem.ui.changes.actions.AcceptAction;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class AcceptWithHierarchyAction
extends AcceptAction {
    public static final String ID = "com.ibm.team.filesystem.ui.changes.actions.AcceptWithHierarchyAction";
    private static final int ALL = 0;
    private static final int SKIP = 1;

    @Override
    protected boolean addSubcomponentsToSelection(Collection selection, Shell shell) {
        ArrayList conflictingComponents = new ArrayList();
        ArrayList<IComponentSyncContext> multipleParticipants = new ArrayList<IComponentSyncContext>();
        Collection allChildren = WorkspaceUpdateUtil.getComponentHierarchyChildren((Collection)selection, (boolean)false, conflictingComponents, multipleParticipants);
        if (!conflictingComponents.isEmpty()) {
            DialogUtil.openError(shell, Messages.AcceptWithHierarchyAction_MismatchedFlowTargetsDialogTitle, Messages.AcceptWithHierarchyAction_MismatchedFlowTargetsDialogMessage);
            return false;
        }
        if (!multipleParticipants.isEmpty()) {
            int result = this.promptForMultipleParticipants(shell, multipleParticipants);
            if (result == 2) {
                return false;
            }
            if (result == 1) {
                selection.removeAll(multipleParticipants);
                allChildren.removeAll(multipleParticipants);
            }
        }
        selection.addAll(allChildren);
        return true;
    }

    private int promptForMultipleParticipants(final Shell shell, List<IComponentSyncContext> multipleParticipants) {
        final int[] result = new int[1];
        final ArrayList<IComponentSyncContext> streamElements = new ArrayList<IComponentSyncContext>();
        final ArrayList<IComponentSyncContext> workspaceElements = new ArrayList<IComponentSyncContext>();
        for (IComponentSyncContext component : multipleParticipants) {
            IWorkspaceSyncContext wsContext = ComponentSyncUtil.getWorkspaceContext((Object)component);
            if (wsContext != null && wsContext.getLocal().isStream()) {
                streamElements.add(component);
                continue;
            }
            workspaceElements.add(component);
        }
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                String dialogtitle = Messages.AcceptWithHierarchyAction_MultipleParticipantsDialog_Title;
                String dialogMessage = !streamElements.isEmpty() && workspaceElements.isEmpty() ? Messages.AcceptWithHierarchyAction_MultipleParticipantsDialog_MessageStream : Messages.AcceptWithHierarchyAction_MultipleParticipantsDialog_Message;
                String[] buttons = new String[]{Messages.AcceptWithHierarchyAction_MultipleParticipantsDialog_ALLButtonText, Messages.AcceptWithHierarchyAction_MultipleParticipantsDialog_SkipButtonText, Messages.AcceptWithHierarchyAction_MultipleParticipantsDialog_CancelButtonText};
                MessageDialog messageDialog = new MessageDialog(shell, dialogtitle, null, dialogMessage, 3, buttons, 0);
                int dialogResult = messageDialog.open();
                switch (dialogResult) {
                    case 0: {
                        result[0] = 0;
                        break;
                    }
                    case 1: {
                        result[0] = 1;
                        break;
                    }
                    default: {
                        result[0] = 2;
                    }
                }
            }
        });
        return result[0];
    }

    @Override
    protected boolean calculateEnabledState(Collection selection) {
        return ComponentSyncUtil.enableAcceptHierarchy((Collection)selection);
    }
}

