/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.icu.text.Collator;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.namespace.ItemFetcher;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.RepositoryNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.client.internal.namespace.impl.WorkspaceContext;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateOperation;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.ui.changes.actions.AcceptDilemmaHandler;
import com.ibm.team.filesystem.ui.changes.actions.StandardAcceptDilemmaHandler;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesViewLabelProvider;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.patches.ApplyPatchUtil;
import com.ibm.team.internal.filesystem.ui.util.WarnWorkspaceUpdate;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.CollatorCache;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.ActiveChangeSetsException;
import com.ibm.team.scm.common.ActiveChangeSetsOverlapException;
import com.ibm.team.scm.common.GapException;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.NWayConflictUnsupportedException;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.ListDialog;

public class AcceptChangeSetFromWildAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        if (selection.size() == 0) {
            return;
        }
        final List<ItemLocator<IChangeSet>> changeSets = AcceptChangeSetFromWildAction.extractChangeSets(selection.toList());
        UIContext context = this.getContext();
        final WarnWorkspaceUpdate warnWorkspaceUpdate = new WarnWorkspaceUpdate(context, Messages.AcceptPatchAction_AcceptingChangesJobName);
        final StandardAcceptDilemmaHandler dilemmaHandler = new StandardAcceptDilemmaHandler(context);
        this.getOperationRunner().enqueue(Messages.AcceptPatchAction_AcceptingChangesJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                AcceptChangeSetFromWildAction.acceptChanges(warnWorkspaceUpdate, dilemmaHandler, changeSets, monitor);
            }
        });
    }

    public static IComponentSyncContext promptForContext(final Shell shell, final IComponent component, final String message, final boolean checkLocal, final boolean checkShared) {
        final IComponentSyncContext[] result = new IComponentSyncContext[1];
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ArrayList<AbstractPlaceWrapper> pickerInput = new ArrayList<AbstractPlaceWrapper>();
                Set workspaceContexts = ComponentSyncUtil.getWorkspaceContexts((Collection)ComponentSyncUtil.getTrackedContexts((IComponentHandle)component, (boolean)checkLocal, (boolean)checkShared));
                for (IWorkspaceSyncContext context : workspaceContexts) {
                    IWorkspace workspace = context.getLocal().getResolvedWorkspace();
                    if (workspace.isStream()) continue;
                    pickerInput.add(AbstractPlaceWrapper.newWrapper(workspace));
                }
                AbstractPlaceWrapper selectedWS = null;
                if (pickerInput.size() == 1) {
                    selectedWS = (AbstractPlaceWrapper)((Object)pickerInput.get(0));
                } else if (pickerInput.size() > 1) {
                    Collections.sort(pickerInput, new Comparator<AbstractPlaceWrapper>(){
                        private Collator fCollator = CollatorCache.getInstance();

                        @Override
                        public int compare(AbstractPlaceWrapper object1, AbstractPlaceWrapper object2) {
                            return this.fCollator.compare(object1.getWorkspace().getName(), object2.getWorkspace().getName());
                        }
                    });
                    ListDialog dialog = new ListDialog(shell);
                    dialog.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                    dialog.setLabelProvider((ILabelProvider)new LocalWorkspaceChangesViewLabelProvider());
                    dialog.setInput(pickerInput);
                    dialog.setTitle(Messages.AcceptPatchAction_MultipleWorkspacesDialogTitle);
                    dialog.setMessage(NLS.bind((String)message, (Object)component.getName()));
                    dialog.open();
                    Object[] selection = dialog.getResult();
                    if (selection != null && selection.length != 0) {
                        selectedWS = (AbstractPlaceWrapper)((Object)selection[0]);
                    }
                }
                if (selectedWS != null) {
                    for (IWorkspaceSyncContext workspaceContext : workspaceContexts) {
                        if (!workspaceContext.getLocal().getResolvedWorkspace().sameItemId((IItemHandle)selectedWS.getWorkspace())) continue;
                        IComponentSyncContext[] iComponentSyncContextArray = workspaceContext.getComponentSyncContexts();
                        int n = iComponentSyncContextArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IComponentSyncContext syncContext = iComponentSyncContextArray[n2];
                            if (component.sameItemId((IItemHandle)syncContext.getComponent())) {
                                result[0] = syncContext;
                                return;
                            }
                            ++n2;
                        }
                    }
                }
            }
        });
        return result[0];
    }

    public static List<ItemLocator<IChangeSet>> extractChangeSets(Collection selection) {
        ArrayList result = NewCollection.arrayList();
        for (Object element : selection) {
            if (element instanceof IChangeSet) {
                result.add(ItemLocator.forItem((IItem)((IChangeSet)element)));
                continue;
            }
            if (element instanceof IChangeSetHandle) {
                ITeamRepository repository = (ITeamRepository)((IChangeSetHandle)element).getOrigin();
                if (repository == null) continue;
                ItemLocator nextChange = ItemLocator.create((ITeamRepository)repository, (IAuditableHandle)((IChangeSetHandle)element));
                result.add(nextChange);
                continue;
            }
            if (!(element instanceof IRemoteActivity)) continue;
            IRemoteActivity remoteActivity = (IRemoteActivity)element;
            ITeamRepository repository = remoteActivity.getActivitySource().getModel().localTeamRepository();
            ItemLocator nextChange = ItemLocator.create((ITeamRepository)repository, (IAuditableHandle)remoteActivity.getChangeSetHandle());
            result.add(nextChange);
        }
        return result;
    }

    public static void acceptChanges(WorkspaceUpdateDilemmaHandler warnWorkspaceUpdate, AcceptDilemmaHandler handler, List<ItemLocator<IChangeSet>> changeSets, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException, OperationCanceledException, OperationFailedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Map fetchedChangeSets = ItemFetcher.fetchCurrents(changeSets, (boolean)true, (IProgressMonitor)progress.newChild(10));
        HashSet<ItemLocator<IChangeSet>> notFound = new HashSet<ItemLocator<IChangeSet>>(changeSets);
        notFound.removeAll(fetchedChangeSets.keySet());
        if (notFound.size() > 0) {
            handler.getPatchDilemmaHandler().changeSetNotFound(changeSets, fetchedChangeSets, notFound);
        }
        HashSet components = NewCollection.hashSet();
        for (IChangeSet change : fetchedChangeSets.values()) {
            components.add(ChangeSetUtil.getComponent((IChangeSet)change));
        }
        Map<ItemId<IComponent>, WorkspaceNamespace> workspaces = handler.selectWorkspaces(components);
        HashMap contexts = NewCollection.hashMap();
        SubMonitor fetchWorkspaceProgress = progress.newChild(10).setWorkRemaining(workspaces.size());
        for (WorkspaceNamespace next : workspaces.values()) {
            contexts.put(next.getWorkspaceId(), (WorkspaceContext)next.getContext((IProgressMonitor)fetchWorkspaceProgress.newChild(1)));
        }
        ArrayList missingChangeSets = NewCollection.arrayList();
        for (ItemLocator<IChangeSet> next : changeSets) {
            IChangeSet changeSet = (IChangeSet)fetchedChangeSets.get(next);
            if (changeSet != null) continue;
            missingChangeSets.add(next);
        }
        if (!missingChangeSets.isEmpty()) {
            handler.missingChangeSetDetected(missingChangeSets);
        }
        HashMap changeSetsByWorkspace = NewCollection.hashMap();
        HashMap<UUID, ITeamRepository> repos = new HashMap<UUID, ITeamRepository>();
        for (ItemLocator itemLocator : changeSets) {
            List list;
            ITeamRepository tr = itemLocator.getRepository();
            repos.put(tr.getId(), tr);
            IChangeSet changeSet = (IChangeSet)fetchedChangeSets.get(itemLocator);
            if (changeSet == null) continue;
            ItemId component = ChangeSetUtil.getComponent((IChangeSet)changeSet);
            WorkspaceNamespace workspace = workspaces.get(component);
            HashMap<UUID, List> map = (HashMap<UUID, List>)changeSetsByWorkspace.get(workspace.getWorkspaceId());
            if (map == null) {
                map = new HashMap<UUID, List>();
                changeSetsByWorkspace.put(workspace.getWorkspaceId(), map);
            }
            if ((list = (List)map.get(tr.getId())) == null) {
                list = NewCollection.arrayList();
                map.put(tr.getId(), list);
            }
            list.add(itemLocator.getItemId());
        }
        HashMap hashMap = NewCollection.hashMap();
        HashMap overlapActiveFound = NewCollection.hashMap();
        ArrayList allFailed = NewCollection.arrayList();
        ArrayList allOverlappingSuspended = NewCollection.arrayList();
        boolean alreadyInHistory = false;
        AcceptDilemmaHandler.FailureReason reason = AcceptDilemmaHandler.FailureReason.UNKNOWN;
        SubMonitor acceptProgress = progress.newChild(60).setWorkRemaining(fetchedChangeSets.size());
        for (Map.Entry next : changeSetsByWorkspace.entrySet()) {
            WorkspaceContext workspaceContext = (WorkspaceContext)contexts.get(next.getKey());
            Iterator crossRepos = (Map)next.getValue();
            for (UUID repoId : crossRepos.keySet()) {
                ITeamRepository tr = (ITeamRepository)repos.get(repoId);
                List componentChangeSets = (List)crossRepos.get(repoId);
                Throwable e = null;
                FileSystemStatusException originalFSCE = null;
                TeamRepositoryException originalTRE = null;
                try {
                    boolean result = AcceptChangeSetFromWildAction.accept(workspaceContext, tr, componentChangeSets, warnWorkspaceUpdate, (IProgressMonitor)acceptProgress.newChild(componentChangeSets.size()));
                    if (!result) {
                        alreadyInHistory = true;
                    }
                }
                catch (FileSystemStatusException fsce) {
                    originalFSCE = fsce;
                    Throwable cause = fsce.getStatus().getException();
                    e = cause == null ? fsce : cause;
                }
                catch (TeamRepositoryException tre) {
                    originalTRE = tre;
                    e = tre;
                }
                if (e != null) {
                    if (e instanceof TeamRepositoryException) {
                        reason = AcceptDilemmaHandler.FailureReason.UNKNOWN;
                        if (e instanceof ActiveChangeSetsOverlapException) {
                            overlapActiveFound.put((ItemId)next.getKey(), Collections.singletonMap(repoId, componentChangeSets));
                            allOverlappingSuspended.addAll(ItemLocator.idsToLocators((ItemNamespace)RepositoryNamespace.create((ITeamRepository)workspaceContext.getNamespace().getRepository()), (Collection)componentChangeSets));
                            reason = AcceptDilemmaHandler.FailureReason.ACTIVE_CHANGE_SETS;
                        } else if (e instanceof GapException) {
                            reason = AcceptDilemmaHandler.FailureReason.GAPS;
                        } else if (e instanceof NWayConflictUnsupportedException) {
                            reason = AcceptDilemmaHandler.FailureReason.NWAYFORKS;
                        } else if (e instanceof ActiveChangeSetsException) {
                            RepositoryNamespace namespace = RepositoryNamespace.create((ITeamRepository)workspaceContext.getNamespace().getRepository());
                            for (ItemId changeSetId : componentChangeSets) {
                                ItemLocator locator = ItemLocator.create((ItemNamespace)namespace, (ItemId)changeSetId);
                                IChangeSet changeSet = (IChangeSet)fetchedChangeSets.get(locator);
                                if (changeSet == null || !changeSet.isActive()) continue;
                                reason = AcceptDilemmaHandler.FailureReason.ACTIVE_CHANGE_SETS;
                            }
                        }
                        if (reason == AcceptDilemmaHandler.FailureReason.UNKNOWN) {
                            throw (TeamRepositoryException)e;
                        }
                        hashMap.put((ItemId)next.getKey(), Collections.singletonMap(repoId, componentChangeSets));
                        allFailed.addAll(ItemLocator.idsToLocators((ItemNamespace)RepositoryNamespace.create((ITeamRepository)workspaceContext.getNamespace().getRepository()), (Collection)componentChangeSets));
                        continue;
                    }
                    if (originalFSCE != null) {
                        throw originalFSCE;
                    }
                    if (originalTRE == null) continue;
                    throw originalTRE;
                }
                if (originalFSCE != null) {
                    throw originalFSCE;
                }
                if (originalTRE == null) continue;
                throw originalTRE;
            }
        }
        ArrayList toApplyAsContent = NewCollection.arrayList();
        if (!allOverlappingSuspended.isEmpty()) {
            AcceptDilemmaHandler.OverlappingSuspendedResult overlapDecision = handler.overlappingSuspendedFound(allOverlappingSuspended, (IProgressMonitor)progress.newChild(3));
            if (overlapDecision == AcceptDilemmaHandler.OverlappingSuspendedResult.APPLY_CONTENT) {
                toApplyAsContent.addAll(allOverlappingSuspended);
            } else if (overlapDecision == AcceptDilemmaHandler.OverlappingSuspendedResult.COMPLETE_AND_RESUME) {
                SubMonitor acceptProgress2 = progress.newChild(20).setWorkRemaining(allOverlappingSuspended.size());
                for (Map.Entry entry : overlapActiveFound.entrySet()) {
                    WorkspaceContext context = (WorkspaceContext)contexts.get(entry.getKey());
                    Map componentChangeSets = (Map)entry.getValue();
                    SubMonitor iterationProgress = acceptProgress2.newChild(componentChangeSets.size()).setWorkRemaining(100);
                    for (UUID repoID : componentChangeSets.keySet()) {
                        try {
                            context.close((List)componentChangeSets.get(repoID), (IProgressMonitor)iterationProgress.newChild(50));
                            ITeamRepository teamRepository = (ITeamRepository)repos.get(repoID);
                            boolean result = AcceptChangeSetFromWildAction.accept(context, teamRepository, (List)componentChangeSets.get(repoID), warnWorkspaceUpdate, (IProgressMonitor)iterationProgress.newChild(50));
                            if (!result) {
                                alreadyInHistory = true;
                                continue;
                            }
                            allFailed.removeAll(ItemLocator.idsToLocators((ItemNamespace)RepositoryNamespace.create((ITeamRepository)context.getRepository()), (Collection)((Collection)componentChangeSets.get(repoID))));
                        }
                        catch (GapException ge) {
                            hashMap.put((ItemId)entry.getKey(), componentChangeSets);
                            allFailed.addAll(ItemLocator.idsToLocators((ItemNamespace)RepositoryNamespace.create((ITeamRepository)context.getRepository()), (Collection)((Collection)componentChangeSets.get(repoID))));
                            reason = AcceptDilemmaHandler.FailureReason.GAPS;
                        }
                    }
                }
            }
        }
        progress.setWorkRemaining(40);
        if (!allFailed.isEmpty()) {
            AcceptDilemmaHandler.FailureAction result = handler.reportFailure(allFailed, reason, (IProgressMonitor)progress.newChild(10));
            if (result == AcceptDilemmaHandler.FailureAction.APPLY_CONTENT) {
                toApplyAsContent.addAll(allFailed);
            }
        } else if (alreadyInHistory) {
            handler.alreadyInHistoryFound();
        }
        progress.setWorkRemaining(30);
        if (!toApplyAsContent.isEmpty()) {
            SubMonitor applyAsContentProgress = progress.newChild(15);
            HashMap changeSetsToApply = new HashMap();
            for (ItemLocator itemLocator : toApplyAsContent) {
                CollectionUtil.addToMapOfLists(changeSetsToApply, (Object)itemLocator.getRepository(), (Object)((IChangeSet)fetchedChangeSets.get(itemLocator)));
            }
            ArrayList arrayList = NewCollection.arrayList();
            applyAsContentProgress.setWorkRemaining(changeSetsToApply.size());
            for (Map.Entry next : changeSetsToApply.entrySet()) {
                arrayList.addAll(ChangeSetWrapper.getWrappers((ITeamRepository)next.getKey(), (Collection)next.getValue()));
            }
            ApplyPatchUtil.applyAsPatch(handler.getPatchDilemmaHandler(), arrayList, false, (IProgressMonitor)progress.newChild(15));
        }
    }

    private static boolean accept(WorkspaceContext context, ITeamRepository optionalSourceRepo, List<ItemId<IChangeSet>> changeSets, WorkspaceUpdateDilemmaHandler warnWorkspaceUpdate, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException, GapException, ActiveChangeSetsOverlapException, ActiveChangeSetsException {
        if (changeSets.isEmpty()) {
            return true;
        }
        IWorkspaceUpdateOperation updateOperation = IOperationFactory.instance.getWorkspaceUpdateOperation(warnWorkspaceUpdate);
        ArrayList<IChangeSetHandle> handles = new ArrayList<IChangeSetHandle>();
        for (ItemId<IChangeSet> changeSet : changeSets) {
            handles.add((IChangeSetHandle)changeSet.toHandle());
        }
        updateOperation.acceptChangeSets(context.getWorkspace(), optionalSourceRepo, handles);
        updateOperation.run(monitor);
        return true;
    }
}

