/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.operations.DeliverDilemmaHandler;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.WorkspaceUpdateUtil;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.changes.views.zoom.ZoomRootUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnDeliverUser;
import com.ibm.team.internal.filesystem.ui.util.WarnWorkspaceUpdate;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.DeliveryIntroducesConflictsException;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class AcceptAction
extends AbstractActionDelegate {
    protected final int KEEP = 0;
    protected final int REPLACE = 1;
    protected final int CANCEL = 2;

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        Collection elements = ZoomRootUtil.replaceRootsWithChildren(selection.toList(), IIncomingRemoteActivity.class);
        ArrayList streamElements = new ArrayList();
        ArrayList workspaceElements = new ArrayList();
        boolean cancel = false;
        for (Object element : elements) {
            IWorkspaceSyncContext wsContext = ComponentSyncUtil.getWorkspaceContext(element);
            if (wsContext != null && wsContext.getLocal().isStream()) {
                streamElements.add(element);
                continue;
            }
            workspaceElements.add(element);
        }
        if (!(streamElements.isEmpty() || workspaceElements.isEmpty() || DialogUtil.openConfirm(shell, Messages.AcceptAction_4, Messages.AcceptAction_5, 4, false))) {
            cancel = true;
        }
        if (!cancel) {
            if (!streamElements.isEmpty()) {
                this.reverseDeliver(shell, streamElements);
            }
            if (!workspaceElements.isEmpty()) {
                this.accept(shell, workspaceElements);
            }
        }
    }

    void reverseDeliver(final Shell shell, final Collection selection) {
        if (selection.size() == 0) {
            return;
        }
        this.getOperationRunner().enqueue(this.getName(), (Operation)new RepositoryOperation(this.getAffectedRepositories(selection)){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                AcceptAction.this.reverseDeliver(shell, selection, problems, monitor);
            }
        });
    }

    private Set<ITeamRepository> getAffectedRepositories(Collection selection) {
        HashSet<ITeamRepository> affectedRepositories = new HashSet<ITeamRepository>(1);
        for (IWorkspaceSyncContext context : ComponentSyncUtil.getWorkspaceContexts((Collection)selection)) {
            affectedRepositories.add(context.teamRepository());
        }
        return affectedRepositories;
    }

    private void reverseDeliver(Shell shell, Collection selection, IStatusCollector problems, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DeliverAction_0, (int)100);
        if (!this.addSubcomponentsToSelection(selection, shell)) {
            progress.done();
            return;
        }
        try {
            try {
                IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
                model.reverseDeliver(selection, (DeliverDilemmaHandler)new StreamWarnDeliverUser(shell, Messages.DeliverAction_2), (IProgressMonitor)progress.newChild(100));
            }
            catch (DeliveryIntroducesConflictsException e) {
                problems.setProblemSummary(Messages.AcceptAction_2, Messages.AcceptAction_3);
                problems.reportException((Throwable)e);
                progress.done();
            }
            catch (TeamRepositoryException e) {
                problems.setProblemSummary(Messages.AcceptAction_2, e.getMessage());
                problems.reportException((Throwable)e);
                progress.done();
            }
        }
        finally {
            progress.done();
        }
    }

    private int shouldReplace(final Shell shell, Collection selection) {
        Collection[] split = AcceptAction.split(selection, true);
        if (split[0].isEmpty()) {
            return 0;
        }
        if (AcceptAction.hasOutgoingChangeSetsToReplace(split[0])) {
            final int[] result = new int[1];
            shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog messageDialog = new MessageDialog(shell, Messages.AcceptAction_0, null, Messages.AcceptAction_1, 3, new String[]{Messages.AcceptAction_ShouldReplaceDialog_KeepButtonText, Messages.AcceptAction_ShouldReplaceDialog_ReplaceButtonText, Messages.AcceptAction_ShouldReplaceDialog_CancelButtonText}, 0);
                    int dialogResult = messageDialog.open();
                    switch (dialogResult) {
                        case 0: {
                            result[0] = 0;
                            break;
                        }
                        case 1: {
                            result[0] = 1;
                            break;
                        }
                        default: {
                            result[0] = 2;
                        }
                    }
                }
            });
            return result[0];
        }
        return 1;
    }

    public void accept(final Shell shell, final Collection selection) {
        if (selection.size() == 0) {
            return;
        }
        final String name = Messages.AcceptAction_AcceptingChangeSetsJobName;
        this.getOperationRunner().enqueue(name, (Operation)new RepositoryOperation(ComponentSyncUtil.getTeamRepositories((Collection)selection)){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                if (!AcceptAction.this.addSubcomponentsToSelection(selection, shell)) {
                    return;
                }
                int promptResult = AcceptAction.this.shouldReplace(shell, selection);
                if (promptResult == 2) {
                    return;
                }
                boolean shouldReplace = promptResult == 1;
                WarnWorkspaceUpdate warnWorkspaceUpdate = new WarnWorkspaceUpdate(AcceptAction.this.getContext(), name);
                WorkspaceUpdateUtil.accept((Collection)selection, (WorkspaceUpdateDilemmaHandler)warnWorkspaceUpdate, (boolean)shouldReplace, (boolean)false, (IProgressMonitor)monitor);
            }
        });
    }

    protected boolean addSubcomponentsToSelection(Collection selection, Shell shell) throws TeamRepositoryException {
        return true;
    }

    public void selectionChanged(IAction action, ISelection selected) {
        super.selectionChanged(action, selected);
        Collection selection = ZoomRootUtil.replaceRootsWithChildren(((IStructuredSelection)selected).toList(), IIncomingRemoteActivity.class);
        action.setEnabled(this.calculateEnabledState(selection));
    }

    protected boolean calculateEnabledState(Collection selection) {
        return ComponentSyncUtil.enableAccept((Collection)selection);
    }

    public static Collection[] split(Collection selection, boolean incoming) {
        Set[] result = ComponentSyncUtil.filter((Collection)selection, (Class[])new Class[]{incoming ? IIncomingActivitySource.class : IOutgoingActivitySource.class, Object.class});
        ArrayList<IComponentSyncContext> bothContexts = new ArrayList<IComponentSyncContext>();
        for (IComponentSyncContext context : ComponentSyncUtil.getContexts((Collection)result[0])) {
            if (context.isOfType(6)) {
                bothContexts.add(context);
                continue;
            }
            result[1].add(context);
        }
        return new Collection[]{bothContexts, result[1]};
    }

    public static boolean hasOutgoingChangeSetsToReplace(Collection selection) {
        for (Object element : selection) {
            IComponentSyncContext context;
            if (!(element instanceof IComponentSyncContext) || !ComponentSyncUtil.isReplaceIncoming((IComponentSyncContext)(context = (IComponentSyncContext)element)) || context.getOutgoingActivitySource().getActivities().isEmpty()) continue;
            return true;
        }
        return false;
    }

    static class StreamWarnDeliverUser
    extends WarnDeliverUser {
        public StreamWarnDeliverUser(Shell shell, String title) {
            super(shell, title);
        }

        @Override
        public int notDefaultTarget(Collection<IWorkspaceConnection> targets) {
            return 0;
        }

        @Override
        public int componentsToBeAddedRemovedOrReplaced(List<DeliverDilemmaHandler.IWorkspaceComponentOperations> workspaceComponentOperationsList, IProgressMonitor monitor) {
            ArrayList added = new ArrayList();
            ArrayList removed = new ArrayList();
            ArrayList replaced = new ArrayList();
            for (DeliverDilemmaHandler.IWorkspaceComponentOperations ops : workspaceComponentOperationsList) {
                added.addAll(ops.getAddedComponents());
                removed.addAll(ops.getRemovedComponents());
                replaced.addAll(ops.getReplacedComponents());
            }
            int nDeletions = removed.size();
            int nAdditions = added.size();
            int nReplaces = replaced.size();
            String caption = nReplaces > 0 ? (nAdditions > 0 || nDeletions > 0 ? Messages.AcceptAction_6 : Messages.AcceptAction_7) : (nAdditions > 0 && nDeletions > 0 ? Messages.AcceptAction_8 : (nDeletions > 0 ? Messages.AcceptAction_9 : Messages.AcceptAction_10));
            caption = nAdditions + nDeletions + nReplaces == 1 ? NLS.bind((String)Messages.AcceptAction_11, (Object)caption) : NLS.bind((String)Messages.AcceptAction_12, (Object)caption);
            final String message = caption;
            final String title = Messages.AcceptAction_13;
            final String choice1 = Messages.AcceptAction_14;
            final String choice2 = Messages.AcceptAction_15;
            final int[] result = new int[]{1};
            IWorkbenchPage page = JFaceUtils.getWorkbenchPage();
            if (page != null) {
                final Shell shell = page.getWorkbenchWindow().getShell();
                shell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        WarnDeliverUser.ChoiceDialog dialog = new WarnDeliverUser.ChoiceDialog(this, shell, title, message, choice1, choice2);
                        dialog.setBlockOnOpen(true);
                        if (dialog.open() == 0) {
                            if (dialog.getChoice1()) {
                                result[0] = 3;
                            } else if (dialog.getChoice2()) {
                                result[0] = 0;
                            }
                        }
                    }
                });
            }
            return result[0];
        }

        @Override
        public int deliveryWithIncomingReplace(List<IComponentHandle> components, IProgressMonitor monitor) {
            String caption = components.size() == 1 ? Messages.AcceptAction_16 : NLS.bind((String)Messages.AcceptAction_17, (Object)components.size());
            final String message = caption = NLS.bind((String)Messages.AcceptAction_18, (Object)caption);
            final String choice1 = Messages.AcceptAction_19;
            final String choice2 = Messages.AcceptAction_20;
            final int[] result = new int[]{1};
            IWorkbenchPage page = JFaceUtils.getWorkbenchPage();
            if (page != null) {
                final Shell shell = page.getWorkbenchWindow().getShell();
                shell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        WarnDeliverUser.ChoiceDialog dialog = new WarnDeliverUser.ChoiceDialog(this, shell, Messages.AcceptAction_21, message, choice1, choice2);
                        dialog.setBlockOnOpen(true);
                        if (dialog.open() == 0) {
                            if (dialog.getChoice1()) {
                                result[0] = 3;
                            } else if (dialog.getChoice2()) {
                                result[0] = 0;
                            }
                        }
                    }
                });
            }
            return result[0];
        }
    }
}

