/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.ui.changes.RenameChangeSetUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.parts.PartSiteJobRunner;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.links.ChangeSetLocationFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class RenameRemoteActivityComment {
    private Item[] items;
    private IRemoteActivity[] remoteActivities;
    private ColumnViewer viewer;
    private IWorkbenchPartSite site;

    public static RenameRemoteActivityComment create(Item[] items, ColumnViewer viewer, IWorkbenchPartSite site) {
        if (items.length == 0) {
            return null;
        }
        IRemoteActivity[] remoteActivities = new IRemoteActivity[items.length];
        int i = 0;
        while (i < items.length) {
            Object data = items[i].getData();
            int allowRename = RenameChangeSetUtil.allowRename(data, true, (IOperationRunner)new PartSiteJobRunner(site, true));
            if (allowRename != 0) {
                return null;
            }
            remoteActivities[i] = (IRemoteActivity)data;
            ++i;
        }
        return new RenameRemoteActivityComment(items, remoteActivities, viewer, site);
    }

    private RenameRemoteActivityComment(Item[] items, IRemoteActivity[] remoteActivities, ColumnViewer viewer, IWorkbenchPartSite site) {
        this.items = items;
        this.remoteActivities = remoteActivities;
        this.viewer = viewer;
        this.site = site;
    }

    public String getFirstComment() {
        IRemoteActivity firstActivity = this.remoteActivities[0];
        IComponentSyncContext firstCompareChanges = firstActivity.getActivitySource().getModel();
        return firstCompareChanges.getSummary(firstActivity);
    }

    public IRemoteActivity[] getRemoteActivities() {
        return this.remoteActivities;
    }

    public void saveTask(String newComment) {
        ArrayList<IRemoteActivity> remotes = new ArrayList<IRemoteActivity>();
        int i = 0;
        while (i < this.items.length) {
            IRemoteActivity activity = this.remoteActivities[i];
            IComponentSyncContext compareChanges = activity.getActivitySource().getModel();
            if (!newComment.equals(compareChanges.getSummary(activity))) {
                if (!this.items[i].isDisposed()) {
                    this.items[i].setText(NLS.bind((String)Messages.RenameRemoteActivityComment_SavingText, (Object)ChangeSetLocationFactory.replaceLineEnding((String)newComment, (String)" ")));
                }
                remotes.add(activity);
            } else {
                this.viewer.update((Object)activity, null);
            }
            ++i;
        }
        if (!remotes.isEmpty()) {
            this.saveTaskCommentJob(remotes, newComment);
        }
    }

    private void scheduleWithProgress(Job job) {
        job.setUser(true);
        IWorkbenchSiteProgressService ps = (IWorkbenchSiteProgressService)this.site.getAdapter(IWorkbenchSiteProgressService.class);
        ps.schedule(job, 0L, true);
    }

    private void saveTaskCommentJob(final List<IRemoteActivity> remoteActivities, final String newComment) {
        final Control control = this.viewer.getControl();
        final Display display = control.getDisplay();
        Job job = new Job(Messages.RenameRemoteActivityComment_SavingCommentJobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    HashSet<IComponentSyncContext> toRefresh = new HashSet<IComponentSyncContext>();
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(remoteActivities.size() + 10));
                    subMonitor.setTaskName(Messages.RenameRemoteActivityComment_SavingCommentProgressName);
                    for (IRemoteActivity remoteActivity : remoteActivities) {
                        IComponentSyncContext compareChanges = remoteActivity.getActivitySource().getModel();
                        compareChanges.setComment(remoteActivity, newComment, (IProgressMonitor)subMonitor.newChild(1));
                        toRefresh.add(compareChanges);
                    }
                    subMonitor.setWorkRemaining(toRefresh.size());
                    for (IComponentSyncContext context : toRefresh) {
                        context.refresh(false, (IProgressMonitor)subMonitor.newChild(1));
                    }
                }
                catch (FileSystemException e) {
                    IStatus iStatus = FileSystemStatusUtil.getStatusFor((Throwable)e);
                    display.asyncExec(new Runnable(control, remoteActivities){
                        private final /* synthetic */ Control val$control;
                        private final /* synthetic */ List val$remoteActivities;
                        {
                            this.val$control = control;
                            this.val$remoteActivities = list;
                        }

                        @Override
                        public void run() {
                            if (!this.val$control.isDisposed()) {
                                RenameRemoteActivityComment.this.viewer.update(this.val$remoteActivities.toArray(), null);
                            }
                        }
                    });
                    monitor.done();
                    return iStatus;
                }
                catch (TeamRepositoryException e) {
                    IStatus iStatus;
                    try {
                        iStatus = FileSystemStatusUtil.getStatusFor((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        display.asyncExec(new /* invalid duplicate definition of identical inner class */);
                        monitor.done();
                        throw throwable;
                    }
                    display.asyncExec(new /* invalid duplicate definition of identical inner class */);
                    monitor.done();
                    return iStatus;
                }
                display.asyncExec(new /* invalid duplicate definition of identical inner class */);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        this.scheduleWithProgress(job);
    }
}

