/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes;

import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.RepositoryUtils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.IChangeSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public abstract class RenameChangeSetUtil {
    public static final int RENAME_OK = 0;
    public static final int RENAME_NOT_LOGGED_IN = 1;
    public static final int RENAME_NOT_DONE_LOADING = 2;
    public static final int RENAME_OWNER_NOT_LOGGED_IN = 3;
    public static final int RENAME_NOT_ALLOWED_UNKNOWN = 4;
    private static final String MRU_COMMENTS = "MruComments";
    public static final int MAX_MRU_COMMENTS = 10;

    public static int allowRename(Object element, boolean showErrorDialog, IOperationRunner runner) {
        if (element != null && element instanceof IRemoteActivity) {
            IRemoteActivity activity = (IRemoteActivity)element;
            IActivitySource activitySource = activity.getActivitySource();
            ITeamRepository repo = activitySource.getModel().localTeamRepository();
            if (activitySource instanceof IIncomingActivitySource) {
                repo = activitySource.getTeamRepository();
            }
            if (!repo.loggedIn()) {
                if (showErrorDialog) {
                    RenameChangeSetUtil.showNotLoggedInDialog(repo, runner);
                }
                return 1;
            }
            IChangeSet changeSet = activity.getChangeSet();
            if (changeSet == null) {
                return 2;
            }
            return RenameChangeSetUtil.ownerIsLoggedIn(repo, changeSet, showErrorDialog, runner);
        }
        return 4;
    }

    public static int allowRename(Object element) {
        return RenameChangeSetUtil.allowRename(element, false, null);
    }

    public static void showNotLoggedInDialog(ITeamRepository repo, IOperationRunner runner) {
        int button = JFaceUtils.showMessageButtonsBlocking((String)Messages.RenameChangeSetUtil_NotLoggedInDialogTitle, (String)Messages.RenameChangeSetUtil_NotLoggedInDialogMessage, (String[])new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, (int)3, (int)0);
        if (button == 0) {
            RepositoryUtils.asyncLogin(repo, runner);
        }
    }

    public static void showNotAuthorDialog() {
        JFaceUtils.showMessage((String)Messages.RenameChangeSetUtil_NotAuthorizedTitle, (String)Messages.RenameChangeSetUtil_CreatorSetDialogMessage, (int)4);
    }

    public static void showConnectionRefusedDialog() {
        JFaceUtils.showMessage((String)Messages.RenameChangeSetUtil_ConnectionErrorTitle, (String)Messages.RenameChangeSetUtil_NotLoggedIChecknDialogMessage, (int)4);
    }

    public static int ownerIsLoggedIn(ITeamRepository repo, IChangeSet changeSet, boolean showDialog, IOperationRunner runner) {
        if (!repo.loggedIn()) {
            if (showDialog) {
                RenameChangeSetUtil.showNotLoggedInDialog(repo, runner);
            }
            return 1;
        }
        return 0;
    }

    private static Preferences getPreference() {
        IEclipsePreferences prefs = new InstanceScope().getNode("com.ibm.team.filesystem.ide.ui");
        return prefs.node(RenameChangeSetUtil.class.getName());
    }

    public static void updateMruComments(String newComment) {
        if (newComment == null || newComment.trim().length() == 0) {
            return;
        }
        LinkedList<String> mruComments = RenameChangeSetUtil.loadMruComments();
        Iterator iter = mruComments.iterator();
        while (iter.hasNext()) {
            String value = (String)iter.next();
            if (!value.equals(newComment)) continue;
            iter.remove();
            break;
        }
        mruComments.addFirst(newComment);
        if (mruComments.size() > 10) {
            mruComments.removeLast();
        }
        RenameChangeSetUtil.saveMruComments(mruComments);
    }

    public static void saveMruComments(List<String> comments) {
        Preferences prefs = RenameChangeSetUtil.getPreference().node(MRU_COMMENTS);
        try {
            prefs.removeNode();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        prefs = RenameChangeSetUtil.getPreference().node(MRU_COMMENTS);
        int i = 0;
        while (i < comments.size()) {
            prefs.put("value" + i, comments.get(i));
            ++i;
        }
    }

    public static LinkedList<String> loadMruComments() {
        LinkedList<String> list = new LinkedList<String>();
        Preferences prefs = RenameChangeSetUtil.getPreference().node(MRU_COMMENTS);
        int i = 0;
        while (i < 10) {
            String value = prefs.get("value" + i, null);
            if (value == null) break;
            list.add(value);
            ++i;
        }
        return list;
    }

    public static int computeTextHeight(Text text, int width) {
        Point p = text.computeSize(width, -1, false);
        int newTextHeight = p.y;
        String string = text.getText();
        if (string.endsWith("\n") || string.endsWith("\r")) {
            newTextHeight += RenameChangeSetUtil.getFontMetricHeight(text);
        }
        return newTextHeight;
    }

    public static int computeTextHeight(Text text, int width, int numRows) {
        int h = RenameChangeSetUtil.getFontMetricHeight(text) * numRows;
        Rectangle r = text.computeTrim(0, 0, width, h);
        return r.height;
    }

    private static int getFontMetricHeight(Text text) {
        GC gc = new GC((Drawable)text);
        FontMetrics fm = gc.getFontMetrics();
        gc.dispose();
        return fm.getHeight();
    }
}

