/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes;

import com.ibm.team.feed.core.ClientFeedUtils;
import com.ibm.team.feed.core.INewsListener;
import com.ibm.team.feed.core.NewsEvent;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.utils.ConnectionFacade;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.ActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.ComponentSyncInfo;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ModelUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.IMutate;
import com.ibm.team.filesystem.ui.AbstractDeliveryHyperlinkHandler;
import com.ibm.team.filesystem.ui.BaselineHyperlinkHandler;
import com.ibm.team.filesystem.ui.ChangeSetHyperlinkHandler;
import com.ibm.team.filesystem.ui.DeliveryLinkData;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.rcp.core.notification.Notification;
import com.ibm.team.foundation.rcp.core.notification.NotificationInfo;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.TeamServiceException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.LockEvent;
import com.ibm.team.scm.client.internal.WorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class NewsListener
implements INewsListener {
    private static final Set<String> CATEGORIES = new HashSet<String>(Arrays.asList("com.ibm.team.scm.eventCategory.delivery", "com.ibm.team.scm.eventCategory.baselineDelivery", "com.ibm.team.scm.eventCategory.stream.component.replace", "com.ibm.team.scm.eventCategory.workitem.link.create", "com.ibm.team.scm.eventCategory.workitem.link.remove", "com.ibm.team.scm.eventCategory.stream.lock.acquire", "com.ibm.team.scm.eventCategory.stream.lock.release", "com.ibm.team.scm.eventCategory.stream.lock.destroy", "com.ibm.team.scm.eventCategory.stream.lock.transfer"));
    final String thisClass = this.getClass().getSimpleName();

    public void newsReceived(NewsEvent event) {
        block12: {
            NewsItem[] news = event.getAddedNews();
            long traceBegin = 0L;
            if (ModelUtil.TRACE_REFRESH) {
                traceBegin = ModelUtil.logBegin((String)String.format("%s.newsReceived(): %d events", this.thisClass, news.length));
            }
            ArrayList<NewsItem> scmEvents = new ArrayList<NewsItem>();
            try {
                try {
                    int i = 0;
                    while (i < news.length) {
                        NewsItem item = news[i];
                        if (CATEGORIES.contains(item.getCategory()) && !this.isMine(item)) {
                            scmEvents.add(item);
                        }
                        ++i;
                    }
                    if (scmEvents.size() > 0) {
                        this.processScmEvents(scmEvents);
                    }
                }
                catch (Exception e) {
                    StatusUtil.log((Object)this, (int)2, (String)Messages.NewsListener_ErrorProcessingNewsItems, (Throwable)e);
                    if (ModelUtil.TRACE_REFRESH) {
                        ModelUtil.logEnd((String)String.format("%s.newsReceived()", this.thisClass), (long)traceBegin);
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (ModelUtil.TRACE_REFRESH) {
                    ModelUtil.logEnd((String)String.format("%s.newsReceived()", this.thisClass), (long)traceBegin);
                }
                throw throwable;
            }
            if (ModelUtil.TRACE_REFRESH) {
                ModelUtil.logEnd((String)String.format("%s.newsReceived()", this.thisClass), (long)traceBegin);
            }
        }
    }

    private void processScmEvents(List<NewsItem> items) throws TeamRepositoryException, URISyntaxException {
        if (ModelUtil.TRACE_REFRESH) {
            ModelUtil.log((String)String.format("%s.processEvents(): %d SCM events", this.thisClass, items.size()));
        }
        this.processDeliverEvents(items);
        this.processReplaceEvents(items);
        this.processWorkitemEvents(items);
        this.processLockEvents(items);
    }

    private void processLockEvents(List<NewsItem> items) throws TeamRepositoryException, URISyntaxException {
        ArrayList<NewsItem> lockNewsItems = new ArrayList<NewsItem>();
        for (NewsItem newsItem : items) {
            String category = newsItem.getCategory();
            if (!category.equals("com.ibm.team.scm.eventCategory.stream.lock.acquire") && !category.equals("com.ibm.team.scm.eventCategory.stream.lock.release") && !category.equals("com.ibm.team.scm.eventCategory.stream.lock.destroy") && !category.equals("com.ibm.team.scm.eventCategory.stream.lock.transfer")) continue;
            lockNewsItems.add(newsItem);
        }
        if (lockNewsItems.isEmpty()) {
            return;
        }
        if (ModelUtil.TRACE_REFRESH) {
            ModelUtil.log((String)String.format("%s:processLockEvents(): %d lock events", this.thisClass, lockNewsItems.size()));
        }
        final HashSet<String> componentUUIDs = new HashSet<String>();
        final HashSet<String> streamUUIDs = new HashSet<String>();
        for (NewsItem item : lockNewsItems) {
            String componentUUID = item.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", IComponent.ITEM_TYPE.getName());
            String streamUUID = item.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", IWorkspace.ITEM_TYPE.getName());
            String typeName = item.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", "typeName");
            if (ModelUtil.TRACE_REFRESH) {
                ModelUtil.log((String)String.format("%s:processLockEvents(): Category: %s", this.thisClass, item.getCategory()));
                if (typeName != null) {
                    ModelUtil.log((String)String.format("%s:processLockEvents(): Type name: %s", this.thisClass, typeName.toString()));
                }
            }
            if (componentUUID != null) {
                if (ModelUtil.TRACE_REFRESH) {
                    ModelUtil.log((String)String.format("%s:processLockEvents(): Component UUID: %s", this.thisClass, componentUUID));
                }
                componentUUIDs.add(componentUUID);
            }
            if (streamUUID == null) continue;
            if (ModelUtil.TRACE_REFRESH) {
                ModelUtil.log((String)String.format("%s:processLockEvents(): Stream UUID: %s", this.thisClass, streamUUID.toString()));
            }
            streamUUIDs.add(streamUUID);
        }
        if (!componentUUIDs.isEmpty() || !streamUUIDs.isEmpty()) {
            Job job = new Job(Messages.NewsListener_ProcessingLockEventsJobName){

                protected IStatus run(IProgressMonitor monitor) {
                    Set updatedWorkspaceConnections;
                    List updatedContexts = new ArrayList();
                    if (componentUUIDs.size() > 0 && (updatedContexts = NewsListener.findUpdatedContexts(componentUUIDs)).size() > 0) {
                        NewsListener.this.refreshComponentSyncContexts(updatedContexts);
                    }
                    if (streamUUIDs.size() > 0 && (updatedWorkspaceConnections = NewsListener.this.findUpdatedStreams(streamUUIDs, monitor)).size() > 0) {
                        NewsListener.this.refreshWorkspaceConnections(updatedWorkspaceConnections, monitor);
                        if (updatedContexts.size() == 0) {
                            NewsListener.this.refreshChangesView(updatedContexts, false);
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(false);
            job.setSystem(true);
            job.schedule();
        }
    }

    private static List<IComponentSyncContext> findUpdatedContexts(Set<String> componentUUIDs) {
        ArrayList<IComponentSyncContext> updatedContexts = new ArrayList<IComponentSyncContext>();
        if (componentUUIDs.size() == 0) {
            return updatedContexts;
        }
        IComponentSyncContext[] contexts = FileSystemResourcesPlugin.getComponentSyncModel().getComponentSyncContexts();
        ActiveWorkspaceManager manager = ActiveWorkspaceManager.getInstance();
        IComponentSyncContext[] iComponentSyncContextArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentSyncContext context = iComponentSyncContextArray[n2];
            if (manager.isWorkspaceTracked((IWorkspaceHandle)context.getWorkspaceSyncContext().getLocal().getResolvedWorkspace()) && context.getComponent() != null && componentUUIDs.contains(context.getComponent().getItemId().getUuidValue())) {
                updatedContexts.add(context);
            }
            ++n2;
        }
        return updatedContexts;
    }

    private Set<IWorkspaceConnection> findUpdatedStreams(Set<String> streamUUIDs, IProgressMonitor monitor) {
        HashSet<IWorkspaceConnection> updatedWorkspaceConnections = new HashSet<IWorkspaceConnection>();
        if (streamUUIDs.size() == 0) {
            return updatedWorkspaceConnections;
        }
        IWorkspaceSyncContext[] contexts = FileSystemResourcesPlugin.getComponentSyncModel().getWorkspaceSyncContexts();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)contexts.length);
        ActiveWorkspaceManager manager = ActiveWorkspaceManager.getInstance();
        IWorkspaceSyncContext[] iWorkspaceSyncContextArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkspaceSyncContext context = iWorkspaceSyncContextArray[n2];
            try {
                IWorkspaceConnection wcLocal = context.getLocal();
                if (!manager.isWorkspaceTracked((IWorkspaceHandle)wcLocal.getResolvedWorkspace())) {
                    progress.worked(1);
                } else if (streamUUIDs.contains(wcLocal.getResolvedWorkspace().getItemId().getUuidValue())) {
                    updatedWorkspaceConnections.add(wcLocal);
                    progress.worked(1);
                } else {
                    ConnectionFacade remoteOutgoing = context.getRemoteOutgoingConnectionDescriptor();
                    IWorkspaceConnection wcOut = remoteOutgoing.getWorkspaceConnection((IProgressMonitor)progress.newChild(1));
                    if (wcOut != null && streamUUIDs.contains(wcOut.getResolvedWorkspace().getItemId().getUuidValue())) {
                        updatedWorkspaceConnections.add(wcOut);
                        updatedWorkspaceConnections.add(wcLocal);
                    }
                }
            }
            catch (TeamRepositoryException e) {
                StatusUtil.log((Object)this, (int)2, (String)Messages.NewsListener_ErrorProcessingNewsItems, (Throwable)e);
            }
            ++n2;
        }
        return updatedWorkspaceConnections;
    }

    private void processDeliverEvents(List<NewsItem> items) throws TeamRepositoryException, URISyntaxException {
        final ArrayList<NewsItem> deliverNewsItems = new ArrayList<NewsItem>();
        for (NewsItem newsItem : items) {
            String category = newsItem.getCategory();
            if (!category.equals("com.ibm.team.scm.eventCategory.delivery") && !category.equals("com.ibm.team.scm.eventCategory.baselineDelivery")) continue;
            deliverNewsItems.add(newsItem);
        }
        if (deliverNewsItems.isEmpty()) {
            return;
        }
        final ArrayList<Location> locations = new ArrayList<Location>(deliverNewsItems.size());
        for (NewsItem item : deliverNewsItems) {
            URI eventUri = new URI(item.getLink());
            locations.add(Location.location((URI)eventUri));
        }
        Job job = new Job(Messages.NewsListener_ProcessingDeliverEventsJobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    NewsListener.this.sendEvents(locations, deliverNewsItems, monitor);
                }
                catch (TeamServiceException teamServiceException) {
                }
                catch (TeamRepositoryException e) {
                    StatusUtil.log((Object)((Object)this), (int)2, (String)"Error sending change set delivery events", (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.schedule();
    }

    private void sendEvents(List<Location> locations, List<NewsItem> newItems, IProgressMonitor monitor) throws TeamRepositoryException {
        AbstractDeliveryHyperlinkHandler handler = new ChangeSetHyperlinkHandler();
        DeliveryLinkData data = null;
        try {
            data = handler.parse(locations, monitor);
        }
        catch (FileSystemException e) {
            data = null;
        }
        if (data == null) {
            try {
                handler = new BaselineHyperlinkHandler();
                data = handler.parse(locations, monitor);
            }
            catch (FileSystemException e) {
                data = null;
            }
            if (data == null) {
                return;
            }
        }
        if (data.getWorkspace() != null && data.getRepository() != null) {
            ConnectionFacade workspace = new ConnectionFacade(data.getRepository(), (IContextHandle)data.getWorkspace());
            NotificationInfo info = this.createNotificationItem(data, newItems, handler, workspace);
            Notification.send((String)"com.ibm.team.scm.eventCategory.delivery", (NotificationInfo)info);
        }
    }

    private NotificationInfo createNotificationItem(final DeliveryLinkData data, List<NewsItem> newsItems, final AbstractDeliveryHyperlinkHandler handler, ConnectionFacade workspace) {
        final List<IComponentSyncContext> loadedContexts = this.findLoadedComponentsCollaborateWith(workspace);
        this.refreshChangesView(loadedContexts);
        int itemIndex = 0;
        Iterator<NewsItem> i = newsItems.iterator();
        while (i.hasNext()) {
            IItem item = data.getItems().get(itemIndex);
            i.next();
            if (item == null) {
                i.remove();
            }
            ++itemIndex;
        }
        String message = newsItems.size() == 1 ? newsItems.get(0).getTitle() : NLS.bind((String)Messages.NewsListener_ChangesDelivered, (Object)newsItems.size());
        NotificationInfo info = new NotificationInfo();
        info.setCategory("com.ibm.team.scm.eventCategory.delivery");
        info.setMessage(XMLString.createFromXMLText((String)message).getPlainText());
        info.setPriority(3);
        info.setSeverity(2);
        info.setTitle(String.valueOf(Messages.NewsListener_ChangesDeliveredTitle) + workspace.getName());
        info.setRunnable(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = JFaceUtils.getWorkbenchPage();
                if (page != null) {
                    if (loadedContexts.isEmpty()) {
                        Job openLinkJob = new Job(Messages.NewsListener_OpeningJobName){

                            protected IStatus run(IProgressMonitor monitor) {
                                handler.doOpen(data.getLocations(), null, monitor);
                                return Status.OK_STATUS;
                            }
                        };
                        openLinkJob.schedule();
                    } else {
                        try {
                            LocalWorkspaceChangesView view = (LocalWorkspaceChangesView)page.showView("com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView");
                            view.getFullChangesViewPage().expandToChanges();
                        }
                        catch (PartInitException e) {
                            ErrorDialog.openError((Shell)page.getWorkbenchWindow().getShell(), (String)Messages.NewsListener_ErrorOpeningPendingChangesTitle, (String)Messages.NewsListener_ErrorOpeningPendingChanges, (IStatus)StatusUtil.newStatus((Object)this, (Throwable)e));
                        }
                    }
                }
            }
        });
        return info;
    }

    private void processReplaceEvents(List<NewsItem> items) throws TeamRepositoryException, URISyntaxException {
        final HashSet<String> componentUUIDs = new HashSet<String>();
        for (NewsItem newsItem : items) {
            String componentUUID;
            String category = newsItem.getCategory();
            if (!category.equals("com.ibm.team.scm.eventCategory.stream.component.replace") || (componentUUID = newsItem.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", IComponent.ITEM_TYPE.getName())) == null) continue;
            if (ModelUtil.TRACE_REFRESH) {
                ModelUtil.log((String)String.format("%s:processReplaceEvents(): Component UUID: %s", this.thisClass, componentUUID));
            }
            componentUUIDs.add(componentUUID);
        }
        if (componentUUIDs.isEmpty()) {
            return;
        }
        Job job = new Job(Messages.NewsListener_ProcessingReplaceEventsJobName){

            protected IStatus run(IProgressMonitor monitor) {
                List updatedContexts = new ArrayList();
                updatedContexts = NewsListener.findUpdatedContexts(componentUUIDs);
                if (updatedContexts.size() > 0) {
                    NewsListener.this.refreshChangesView(updatedContexts);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.schedule();
    }

    public List<IComponentSyncContext> findLoadedComponentsCollaborateWith(ConnectionFacade targetWorkspace) {
        ArrayList<IComponentSyncContext> loadedComponents = new ArrayList<IComponentSyncContext>();
        IComponentSyncContext[] contexts = FileSystemResourcesPlugin.getComponentSyncModel().getComponentSyncContexts();
        int i = 0;
        while (i < contexts.length) {
            IComponentSyncContext context = contexts[i];
            ComponentSyncInfo info = context.getComponentSyncInfo();
            if (info.getRemoteOutgoing().equals((Object)targetWorkspace)) {
                loadedComponents.add(context);
            }
            ++i;
        }
        return loadedComponents;
    }

    private boolean isMine(NewsItem newsItem) {
        String contributorId = ClientFeedUtils.getInstance().getCurrentContributorId(newsItem);
        if (contributorId == null) {
            return true;
        }
        String modifierId = newsItem.getCustomAttribute("http://www.ibm.com/team/Feed", "modifier");
        return contributorId.equals(modifierId);
    }

    private void refreshChangesView(List<IComponentSyncContext> contexts) {
        this.refreshChangesView(contexts, true);
    }

    private void refreshChangesView(final List<? extends IEventSource> items, final boolean full) {
        if (ModelUtil.TRACE_REFRESH) {
            ModelUtil.log((String)String.format("%s:refreshChangesView(): %s items", this.thisClass, items.size()));
        }
        Job job = new Job(Messages.NewsListener_RefreshingChangesJobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    int totalWork = items.size() > 0 ? 100 * items.size() : -1;
                    monitor.beginTask(Messages.NewsListener_RefreshingChangesProgressName, totalWork);
                    FileSystemResourcesPlugin.getComponentSyncModel().refresh(full, monitor);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (FileSystemException e) {
                    IStatus iStatus = StatusUtil.newStatus((Object)((Object)this), (String)Messages.NewsListener_ErrorRefreshingChanges, (Throwable)e);
                    return iStatus;
                }
                catch (TeamRepositoryException e) {
                    IStatus iStatus = StatusUtil.newStatus((Object)((Object)this), (String)Messages.NewsListener_ErrorRefreshingChanges, (Throwable)e);
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setUser(false);
        job.schedule();
    }

    private void refreshComponentSyncContexts(final List<IComponentSyncContext> contexts) {
        if (ModelUtil.TRACE_REFRESH) {
            ModelUtil.log((String)String.format("%s.refreshComponentSyncContexts(): %d contexts", this.thisClass, contexts.size()));
        }
        Job job = new Job(Messages.NewsListener_RefreshingChangesJobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    int totalWork = contexts.size() > 0 ? 100 * contexts.size() : -1;
                    monitor.beginTask(Messages.NewsListener_RefreshingChangesProgressName, totalWork);
                    FileSystemResourcesPlugin.getComponentSyncModel().getComponentSyncManager().update(monitor);
                    FileSystemResourcesPlugin.getComponentSyncModel().refresh(false, monitor);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (TeamRepositoryException e) {
                    IStatus iStatus = StatusUtil.newStatus((Object)((Object)this), (String)Messages.NewsListener_ErrorRefreshingChanges, (Throwable)e);
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setUser(false);
        job.schedule();
    }

    private void refreshWorkspaceConnections(Collection<IWorkspaceConnection> workspaceConnections, IProgressMonitor monitor) {
        if (ModelUtil.TRACE_REFRESH) {
            ModelUtil.log((String)String.format("%s.refreshWorkspaceConnections(): %d streams", this.thisClass, workspaceConnections.size()));
        }
        HashMap repoMap = new HashMap();
        for (IWorkspaceConnection nextWC : workspaceConnections) {
            ITeamRepository repo = nextWC.teamRepository();
            List wsConnsInRepo = (List)repoMap.get(repo);
            if (wsConnsInRepo == null) {
                repoMap.put(repo, new ArrayList());
                wsConnsInRepo = (List)repoMap.get(repo);
            }
            wsConnsInRepo.add(nextWC);
        }
        if (!repoMap.isEmpty()) {
            for (ITeamRepository repo : repoMap.keySet()) {
                if (ModelUtil.TRACE_REFRESH) {
                    ModelUtil.log((String)String.format("%s.refreshWorkspaceConnections(): Refreshing workspace connections for repo %s (%d workspaces)", this.thisClass, repo.getName(), ((List)repoMap.get(repo)).size()));
                }
                IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                try {
                    List wsConns = (List)repoMap.get(repo);
                    for (IWorkspaceConnection wsConn : wsConns) {
                        if (!wsConn.isStream()) continue;
                        if (ModelUtil.TRACE_REFRESH) {
                            ModelUtil.log((String)String.format("%s.refreshWorkspaceConnections(): queuing ILockEvent.STREAMS_LOCKED event for %s", this.thisClass, wsConn.getName()));
                        }
                        ((WorkspaceConnection)wsConn).queueEvent((Object)new LockEvent(wsConn, "com.ibm.team.scm.LockEvent.StreamsLocked"));
                    }
                    wm.refreshWorkspaceConnections((Collection)repoMap.get(repo), monitor);
                }
                catch (TeamRepositoryException e) {
                    StatusUtil.log((Object)this, (int)2, (String)Messages.NewsListener_ErrorProcessingNewsItems, (Throwable)e);
                }
            }
        }
    }

    private void processWorkitemEvents(List<NewsItem> items) throws TeamRepositoryException {
        IComponentSyncContext[] componentSyncContexts = FileSystemResourcesPlugin.getComponentSyncModel().getComponentSyncContexts();
        ArrayList<NewsItem> workitemNewsItems = new ArrayList<NewsItem>();
        for (NewsItem newsItem : items) {
            String category = newsItem.getCategory();
            if (!category.equals("com.ibm.team.scm.eventCategory.workitem.link.create") && !category.equals("com.ibm.team.scm.eventCategory.workitem.link.remove")) continue;
            workitemNewsItems.add(newsItem);
        }
        if (workitemNewsItems.isEmpty()) {
            return;
        }
        if (ModelUtil.TRACE_REFRESH) {
            ModelUtil.log((String)String.format("%:processWorkItemEvents(): %d work item events%n", this.thisClass, items.size()));
        }
        HashSet<String> changeSetItemIds = new HashSet<String>();
        for (NewsItem newsItem : workitemNewsItems) {
            String changeSetItemId = newsItem.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", "changeSetId");
            if (changeSetItemId == null) continue;
            changeSetItemIds.add(changeSetItemId);
        }
        if (changeSetItemIds.isEmpty()) {
            return;
        }
        ArrayList<IComponentSyncContext> refreshComponentSyncContexts = new ArrayList<IComponentSyncContext>();
        int i = 0;
        while (i < componentSyncContexts.length) {
            IComponentSyncContext context = componentSyncContexts[i];
            boolean refreshContext = false;
            for (String changeSetItemId : changeSetItemIds) {
                refreshContext |= this.markActivitiesToRefresh(context.getOutgoingActivitySource().getActivities(), changeSetItemId);
                refreshContext |= this.markActivitiesToRefresh(context.getIncomingActivitySource().getActivities(), changeSetItemId);
                refreshContext |= this.markActivitiesToRefresh(context.getSuspendedActivitySource().getActivities(), changeSetItemId);
            }
            if (refreshContext) {
                refreshComponentSyncContexts.add(context);
            }
            ++i;
        }
        if (!refreshComponentSyncContexts.isEmpty()) {
            this.refreshChangesView(refreshComponentSyncContexts, false);
        }
    }

    private boolean markActivitiesToRefresh(List<IRemoteActivity> activities, String changeSetItemId) {
        boolean markForRefresh = false;
        for (IRemoteActivity activity : activities) {
            IChangeSet changeSet = activity.getChangeSet();
            if (changeSet == null || !changeSet.getItemId().getUuidValue().equals(changeSetItemId)) continue;
            ((IMutate)activity).markDirty();
            markForRefresh = true;
        }
        return markForRefresh;
    }

    public void newsRemoved(NewsEvent event) {
    }

    public void newsStateChanged(NewsEvent event) {
    }
}

