/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes;

import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.IFeedManagerConfigurer;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.FeedFactory;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.foundation.common.IFeedConstants;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.IPropertyChangeEvent;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

public class FeedManagerConfigurer
implements IFeedManagerConfigurer {
    public static final String SCM_USER_HISTORY_PROVIDER = "provider=scmUserHistory&user=";
    private ITeamRepositoryService.IRepositoryServiceListener fRepositoryListener = new ITeamRepositoryService.IRepositoryServiceListener(){

        public void addedRepository(ITeamRepository repository) {
            repository.addGenericListener((Object)"state", FeedManagerConfigurer.this.fStateListener);
            FeedManagerConfigurer.this.addChannel(repository);
        }

        public void removedRepository(ITeamRepository repository) {
            repository.removeGenericListener((Object)"state", FeedManagerConfigurer.this.fStateListener);
            FeedManagerConfigurer.this.removeChannel(repository);
        }
    };
    private IListener fStateListener = new IListener(){

        public void handleEvents(List events) {
            for (Object ev : events) {
                IPropertyChangeEvent delta;
                Object newValue;
                if (!(ev instanceof IPropertyChangeEvent) || !((newValue = (delta = (IPropertyChangeEvent)ev).getNewValue()) instanceof Integer)) continue;
                ITeamRepository repository = (ITeamRepository)delta.getObject();
                Integer state = (Integer)newValue;
                if (state == 1) {
                    FeedManagerConfigurer.this.addChannel(repository);
                    continue;
                }
                if (state != 3) continue;
                FeedManagerConfigurer.this.removeChannel(repository);
            }
        }
    };

    public void configure(FeedManager manager) {
        TeamPlatform.getTeamRepositoryService().addRepositoryServiceListener(this.fRepositoryListener);
        ITeamRepository[] teamRepositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int i = 0;
        while (i < teamRepositories.length) {
            ITeamRepository repository = teamRepositories[i];
            repository.addGenericListener((Object)"state", this.fStateListener);
            this.addChannel(repository);
            ++i;
        }
    }

    private void addChannel(ITeamRepository repository) {
        if (PlatformUI.isWorkbenchRunning() && PlatformUI.getWorkbench().isClosing()) {
            return;
        }
        if (!repository.loggedIn() || this.isRepositoryDeleted(repository)) {
            return;
        }
        try {
            IContributor loggedInContributor = repository.loggedInContributor();
            FeedManagerConfigurer.registerChannel(loggedInContributor.getName(), loggedInContributor.getUserId(), repository.getRepositoryURI());
        }
        catch (URISyntaxException e) {
            IStatus status = FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.CreateStreamFeedAction_ErrorConstructingURLError, (Throwable)e);
            StatusUtil.log((IStatus)status);
        }
    }

    public static void registerChannel(String userName, String userId, String repositoryURI) throws URISyntaxException {
        StringBuilder builder = FeedManagerConfigurer.getFeedServiceURL(repositoryURI);
        builder.append(SCM_USER_HISTORY_PROVIDER);
        builder.append(userId);
        String urlString = builder.toString();
        Channel channel = FeedManager.getDefault().getChannel(urlString);
        if (channel == null) {
            String title = NLS.bind((String)Messages.CreateSCMFeedAction_Title, (Object)userName);
            String description = NLS.bind((String)Messages.CreateSCMFeedAction_Status, (Object)userName);
            channel = FeedManagerConfigurer.newChannel(urlString, title, description, true);
        }
        FeedManager.getDefault().registerPredefinedChannel(channel, urlString);
    }

    private void removeChannel(ITeamRepository repository) {
        try {
            StringBuilder builder = FeedManagerConfigurer.getFeedServiceURL(repository.getRepositoryURI());
            builder.append(SCM_USER_HISTORY_PROVIDER);
            builder.append(repository.loggedInContributor().getUserId());
            String urlString = builder.toString();
            Channel channel = FeedManager.getDefault().getChannel(urlString);
            if (channel != null) {
                FeedManager.getDefault().removeChannel(channel);
            }
        }
        catch (URISyntaxException e) {
            IStatus status = FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.CreateStreamFeedAction_ErrorConstructingURLError, (Throwable)e);
            StatusUtil.log((IStatus)status);
        }
    }

    private boolean isRepositoryDeleted(ITeamRepository repository) {
        ITeamRepository[] teamRepositories;
        ITeamRepository[] iTeamRepositoryArray = teamRepositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = teamRepositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository teamRepository = iTeamRepositoryArray[n2];
            if (teamRepository.getRepositoryURI().equals(repository.getRepositoryURI())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static Channel newChannel(String urlStr, String title, String description, boolean forceDownload) {
        Channel channel = FeedManager.getDefault().getChannel(urlStr);
        channel = FeedFactory.eINSTANCE.createChannel();
        channel.setUrl(urlStr);
        channel.setTitle(title);
        channel.setDescription(description);
        channel.setForceDownload(forceDownload);
        channel.setCategory("com.ibm.team.feed.core.SystemFeed");
        channel.setUpdateInterval(10);
        FeedManager.getDefault().addChannel(channel);
        if (channel.isForceDownload()) {
            FeedManager.getDefault().loadNews(channel);
        }
        return channel;
    }

    public static StringBuilder getFeedServiceURL(String repositoryURI) throws URISyntaxException {
        StringBuilder url = FeedManagerConfigurer.getBaseURL(new URI(repositoryURI));
        url.append("service/");
        url.append(IFeedConstants.SERVICE_NAME);
        url.append("?");
        return url;
    }

    public static StringBuilder getBaseURL(URI uri) {
        String protocol = uri.getScheme();
        String authority = uri.getAuthority();
        String path = uri.getPath();
        if (protocol == null || authority == null || path == null) {
            return null;
        }
        String[] segments = path.split("/");
        int i = 0;
        while (i < segments.length && segments[i].equals("")) {
            ++i;
        }
        path = "/";
        if (i < segments.length) {
            path = String.valueOf(path) + segments[i] + "/";
        }
        StringBuilder url = new StringBuilder();
        url.append(protocol);
        url.append("://");
        url.append(authority);
        url.append(path);
        return url;
    }
}

