/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes;

import com.ibm.team.filesystem.client.internal.snapshot.BaselineId;
import com.ibm.team.filesystem.client.internal.snapshot.BaselineSetId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.snapshot.WorkspaceId;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangeSetInput;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangesViewConverter;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.Collections;
import java.util.List;
import org.eclipse.ui.IWorkbenchPage;

public class ChangesViewUtil {
    public static String getChangeSetView() {
        return "com.ibm.team.filesystem.ui.changes.views.ChangeExplorerView";
    }

    public static String getWorkspaceCompareView() {
        return "com.ibm.team.filesystem.ui.changes.views.ChangeExplorerView";
    }

    public static void openChangeSets(IWorkbenchPage page, ITeamRepository repository, List<IChangeSetHandle> changeSets) {
        ChangesViewConverter.openChangeExplorer(page, new ChangeSetInput(SnapshotId.createEmptyId((ITeamRepository)repository), changeSets));
    }

    public static void openChangeSet(IWorkbenchPage page, ITeamRepository repository, IChangeSetHandle changeSet) {
        ChangesViewConverter.openChangeExplorer(page, new ChangeSetInput(SnapshotId.createEmptyId((ITeamRepository)repository), Collections.singletonList(changeSet)));
    }

    public static void compareSnapshotWithSnapshot(IWorkbenchPage page, ITeamRepository teamRepository, IBaselineSetHandle snapshot1, IBaselineSetHandle snapshot2) {
        ChangesViewConverter.compare(page, (SnapshotId)BaselineSetId.create((ITeamRepository)teamRepository, (IBaselineSetHandle)snapshot1), (SnapshotId)BaselineSetId.create((ITeamRepository)teamRepository, (IBaselineSetHandle)snapshot2));
    }

    public static void compareSnapshotWithWorkspace(IWorkbenchPage page, ITeamRepository teamRepository, IBaselineSetHandle snapshotHandle, IWorkspaceHandle workspaceHandle) {
        ChangesViewConverter.compare(page, (SnapshotId)BaselineSetId.create((ITeamRepository)teamRepository, (IBaselineSetHandle)snapshotHandle), (SnapshotId)WorkspaceId.create((ITeamRepository)teamRepository, (IWorkspaceHandle)workspaceHandle));
    }

    public static void compareSnapshotWithBaseline(IWorkbenchPage page, ITeamRepository teamRepository, IBaselineSetHandle snapshotHandle, IBaselineHandle baseline) {
        ChangesViewConverter.compare(page, (SnapshotId)BaselineSetId.create((ITeamRepository)teamRepository, (IBaselineSetHandle)snapshotHandle), (SnapshotId)BaselineId.create((ITeamRepository)teamRepository, (IBaselineHandle)baseline));
    }

    public static void compareWorkspaceWithSnapshot(IWorkbenchPage page, ITeamRepository teamRepository, IWorkspaceHandle workspace, IBaselineSetHandle snapshotHandle) {
        ChangesViewConverter.compare(page, (SnapshotId)WorkspaceId.create((ITeamRepository)teamRepository, (IWorkspaceHandle)workspace), (SnapshotId)BaselineSetId.create((ITeamRepository)teamRepository, (IBaselineSetHandle)snapshotHandle));
    }

    public static void compareWorkspaceWithWorkspace(IWorkbenchPage page, ITeamRepository teamRepository1, IWorkspaceHandle workspace1, ITeamRepository teamRepository2, IWorkspaceHandle workspace2) {
        ChangesViewConverter.compare(page, (SnapshotId)WorkspaceId.create((ITeamRepository)teamRepository1, (IWorkspaceHandle)workspace1), (SnapshotId)WorkspaceId.create((ITeamRepository)teamRepository2, (IWorkspaceHandle)workspace2));
    }

    public static void compareWorkspaceWithBaseline(IWorkbenchPage page, ITeamRepository teamRepository, IWorkspaceHandle workspace, IBaselineHandle baseline) {
        ChangesViewConverter.compare(page, (SnapshotId)WorkspaceId.create((ITeamRepository)teamRepository, (IWorkspaceHandle)workspace), (SnapshotId)BaselineId.create((ITeamRepository)teamRepository, (IBaselineHandle)baseline));
    }

    public static void compareBaselineWithSnapshot(IWorkbenchPage page, ITeamRepository teamRepository, IBaselineHandle baseline, IBaselineSetHandle snapshot) {
        ChangesViewConverter.compare(page, (SnapshotId)BaselineId.create((ITeamRepository)teamRepository, (IBaselineHandle)baseline), (SnapshotId)BaselineSetId.create((ITeamRepository)teamRepository, (IBaselineSetHandle)snapshot));
    }

    public static void compareBaselineWithWorkspace(IWorkbenchPage page, ITeamRepository teamRepository, IBaselineHandle baseline, IWorkspaceHandle workspace) {
        ChangesViewConverter.compare(page, (SnapshotId)BaselineId.create((ITeamRepository)teamRepository, (IBaselineHandle)baseline), (SnapshotId)WorkspaceId.create((ITeamRepository)teamRepository, (IWorkspaceHandle)workspace));
    }

    public static void compareBaselineWithBaseline(IWorkbenchPage page, ITeamRepository teamRepository, IBaselineHandle baseline1, IBaselineHandle baseline2) {
        ChangesViewConverter.compare(page, (SnapshotId)BaselineId.create((ITeamRepository)teamRepository, (IBaselineHandle)baseline1), (SnapshotId)BaselineId.create((ITeamRepository)teamRepository, (IBaselineHandle)baseline2));
    }
}

