/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changes;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import org.eclipse.core.runtime.IPath;

public class AnnotateInput {
    private ItemId<IChangeSet> cs;
    private StateId<IFileItem> file;
    private IPath path;
    private ItemNamespace namespace;

    public AnnotateInput(ItemNamespace namespace, ItemId<IChangeSet> cs, StateId<IFileItem> fileItem, IPath path) {
        this.namespace = namespace;
        this.cs = cs;
        this.file = fileItem;
        this.path = path;
    }

    public AnnotateInput(IConnection connection, IChangeSetHandle cs, IComponentHandle component, IFileItemHandle file, IPath path, String text, int selectedLine) {
        this(connection.teamRepository(), (IContextHandle)(connection instanceof IWorkspaceConnection ? ((IWorkspaceConnection)connection).getResolvedWorkspace() : ((IBaselineConnection)connection).getBaseline()), cs, component, file, path);
        this.namespace = ItemNamespace.getNamespace((IConnection)connection, (IComponentHandle)component);
    }

    public AnnotateInput(ITeamRepository repo, IContextHandle connection, IChangeSetHandle cs, IComponentHandle component, IFileItemHandle file, IPath path) {
        this(ItemNamespace.getNamespace((ITeamRepository)repo, (IContextHandle)connection, (IComponentHandle)component), (ItemId<IChangeSet>)ChangeSetUtil.getChangeSet((IChangeSetHandle)cs), (StateId<IFileItem>)new StateId((IItemHandle)file), path);
    }

    public StateId<IFileItem> getFileItem() {
        return this.file;
    }

    public IPath getPath() {
        return this.path;
    }

    public ITeamRepository getTeamRepository() {
        return this.namespace.getRepository();
    }

    public ItemId<IChangeSet> getChangeSet() {
        return this.cs;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cs == null ? 0 : this.cs.hashCode());
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotateInput other = (AnnotateInput)obj;
        if (this.cs == null ? other.cs != null : !this.cs.equals(other.cs)) {
            return false;
        }
        if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
            return false;
        }
        if (this.namespace == null ? other.namespace != null : !this.namespace.equals((Object)other.namespace)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
    }

    public ItemNamespace getNamespace() {
        return this.namespace;
    }
}

