/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changemodel;

import com.ibm.team.filesystem.client.internal.ClientConfigurationChangeFactory;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.common.changemodel.ChangeDescription;
import com.ibm.team.filesystem.common.changemodel.ConfigurationChange;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ConfigurationChangeFactory;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class UIConfigurationChangeFactory {
    private UIConfigurationChangeFactory() {
    }

    public static ChangeDescription createDescriptionForChangeSets(List<ItemLocator<IChangeSet>> changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)changeSets.size());
        Map grouped = ItemLocator.groupByNamespace(changeSets);
        ChangeDescription description = new ChangeDescription();
        for (ItemNamespace next : grouped.keySet()) {
            List changes = (List)grouped.get(next);
            description = description.merge(ConfigurationChangeFactory.getDescriptionForHandles((ITeamRepository)next.getRepository(), (List)changes, (IProgressMonitor)progress.newChild(changes.size())));
        }
        return description;
    }

    public static ConfigurationChange createChangeForChangeSets(List<? extends ChangeSetWrapper> changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashMap groupedByRepository = new HashMap();
        for (ChangeSetWrapper changeSetWrapper : changeSets) {
            CollectionUtil.addToMapOfLists(groupedByRepository, (Object)changeSetWrapper.getRepository(), (Object)((Object)changeSetWrapper));
        }
        ArrayList arrayList = NewCollection.arrayList();
        SubMonitor loopProgress = progress.newChild(100).setWorkRemaining(changeSets.size());
        for (Map.Entry next : groupedByRepository.entrySet()) {
            SubMonitor iterationProgress = loopProgress.newChild(((List)next.getValue()).size()).setWorkRemaining(100);
            List nextChangeSets = (List)next.getValue();
            ITeamRepository repository = (ITeamRepository)next.getKey();
            arrayList.add(ClientConfigurationChangeFactory.createChange((ITeamRepository)repository, ChangeSetWrapper.getChangeSets(nextChangeSets), (IProgressMonitor)iterationProgress.newChild(100)));
        }
        return ConfigurationChange.merge((Collection)arrayList);
    }

    public static ChangeDescription createDescriptionForWrappers(List<? extends ChangeSetWrapper> changeSetsWithContext, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<ItemLocator<IChangeSet>> changeSetLocators = new ArrayList<ItemLocator<IChangeSet>>();
        for (ChangeSetWrapper changeSetWrapper : changeSetsWithContext) {
            changeSetLocators.add((ItemLocator<IChangeSet>)ItemLocator.create((ITeamRepository)changeSetWrapper.getRepository(), (IAuditableHandle)changeSetWrapper.getChangeSet()));
        }
        ChangeDescription changeDescription = UIConfigurationChangeFactory.createDescriptionForChangeSets(changeSetLocators, monitor);
        return changeDescription;
    }
}

