/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changemodel;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.common.IChangeSummary;
import com.ibm.team.filesystem.common.changemodel.VersionablePathSegment;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class PathUtil {
    public static IPath getBeforePath(IChangeSummary summary) {
        String[] pathArray = summary.getPathHint();
        return PathUtil.stringArrayToPath(pathArray);
    }

    public static IPath getAfterPath(IChangeSummary summary) {
        String[] pathArray = summary.getNewPathHint();
        if (pathArray == null) {
            return PathUtil.getBeforePath(summary);
        }
        return PathUtil.stringArrayToPath(pathArray);
    }

    static IPath stringArrayToPath(String[] pathArray) {
        Path result = new Path("");
        int i = 0;
        while (i < pathArray.length) {
            String string = pathArray[i];
            result = result.append(string);
            ++i;
        }
        return result;
    }

    public static IRelativeLocation getBeforePath(ILocalChange localChange) {
        IRelativeLocation beforePath = localChange.getOriginalPath();
        if (beforePath == null && (beforePath = localChange.getResultingPath()) == null) {
            beforePath = RelativeLocation.EMPTY_LOCATION;
        }
        return beforePath;
    }

    public static IRelativeLocation getAfterPath(ILocalChange localChange) {
        IRelativeLocation afterPath = localChange.getResultingPath();
        if (afterPath == null && (afterPath = localChange.getOriginalPath()) == null) {
            afterPath = RelativeLocation.EMPTY_LOCATION;
        }
        return afterPath;
    }

    @Deprecated
    public static VersionablePathSegment currentPath(IResource resource, IProgressMonitor monitor) throws FileSystemException {
        return CoreShareablesUtil.getSegment((IResource)resource, (IProgressMonitor)monitor);
    }
}

