/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.changefileproperties.wizards;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IShareableInternal;
import com.ibm.team.filesystem.client.internal.operations.ChangePropertiesOperation;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IChangePropertiesOperation;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.rcp.core.internal.resources.ContentPropertiesPreference;
import com.ibm.team.filesystem.rcp.core.internal.resources.ContentPropertiesPreferenceManager;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.filesystem.rcp.ui.internal.properties.ChangeFilePropertiesUtil;
import com.ibm.team.filesystem.rcp.ui.internal.properties.PropertyNamespaceManager;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnChangeFileProperties;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.adapters.AbstractAdaptableRemoteResource;
import com.ibm.team.internal.filesystem.ui.util.TableOrTreeResizer;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.osgi.service.prefs.BackingStoreException;

public class ChangeFilePropertiesWizard
extends Wizard
implements IPageChangedListener {
    private static final String EMPTY = "";
    private static final String MULTIPLE_ITEMS = "";
    private static final FileNameMap MIME_MAP = URLConnection.getFileNameMap();
    private Map<String, Set<IShareable>> extensionMap = new HashMap<String, Set<IShareable>>();
    private Set<IShareable> noExtension = new HashSet<IShareable>();
    private Map<IShareable, FileLineDelimiter> newLineDelimiter = new HashMap<IShareable, FileLineDelimiter>();
    private Map<IShareable, FileLineDelimiter> currentLineDelimiter = new HashMap<IShareable, FileLineDelimiter>();
    private Map<IShareable, String> newContentType = new HashMap<IShareable, String>();
    private Map<IShareable, String> currentContentType = new HashMap<IShareable, String>();
    private Map<IShareable, ContentPropertiesPreference> shareableToPreference = new HashMap<IShareable, ContentPropertiesPreference>();
    private Map<String, ContentPropertiesPreference> extensionToPreference = new HashMap<String, ContentPropertiesPreference>();
    private Map<IShareable, IContentType> shareableToEclipseContentType = new HashMap<IShareable, IContentType>();
    private Map<String, String> extensionToLineDelimiter = new HashMap<String, String>();
    private Map<String, String> extensionToContentType = new HashMap<String, String>();
    private IWorkbench workbench;
    private ImageRegistry imageRegistry;
    private ChangeFilePropertyPage changeFilePropertyPage;
    private ErrorPage preErrorPage;
    private ErrorPage postErrorPage;
    private UpdatePreferencesPage updatePreferencesPage;
    ContentPropertiesPreferenceManager manager = new ContentPropertiesPreferenceManager();
    private IResource seedResource;

    private static String getLineDelimiter(FileLineDelimiter lineDelimiter) {
        if (lineDelimiter == null) {
            return "";
        }
        return ChangeFilePropertiesUtil.delimiterToString((FileLineDelimiter)lineDelimiter);
    }

    private static String getContentType(String contentType) {
        if (contentType == null) {
            return "";
        }
        return contentType.trim().toLowerCase();
    }

    public ChangeFilePropertiesWizard(IWorkbench workbench) {
        this.workbench = workbench;
        this.imageRegistry = new ImageRegistry();
        this.setWindowTitle(Messages.ChangeFilePropertiesWizard_3);
        this.setDefaultPageImageDescriptor(ImagePool.CHANGE_FILE_PROPERTIES_WIZBAN);
        this.setNeedsProgressMonitor(true);
    }

    public void collectResources(final Object[] selection, ProgressMonitorDialog dialog) {
        if (selection.length == 1 && selection[0] instanceof IResource) {
            this.seedResource = (IResource)selection[0];
        }
        final ArrayList<TableElement> errors = new ArrayList<TableElement>();
        if (selection != null && selection.length > 0) {
            try {
                dialog.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        ChangeFilePropertiesWizard.this.collectResources(selection, errors, Messages.ChangeFilePropertiesWizard_4, monitor);
                    }
                });
            }
            catch (InvocationTargetException e) {
                ErrorDialog.openError((Shell)dialog.getShell(), (String)Messages.ChangeFilePropertiesWizard_5, (String)Messages.ChangeFilePropertiesWizard_6, (IStatus)FileSystemStatusUtil.getStatusFor((Throwable)e));
            }
            catch (InterruptedException e) {
                ErrorDialog.openError((Shell)dialog.getShell(), (String)Messages.ChangeFilePropertiesWizard_5, (String)Messages.ChangeFilePropertiesWizard_6, (IStatus)FileSystemStatusUtil.getStatusFor((Throwable)e));
            }
        }
        if (!errors.isEmpty()) {
            this.preErrorPage = new ErrorPage(Messages.ChangeFilePropertiesWizard_9, errors);
        }
    }

    private void collectRemoteShareables(IShareable[] shareables, List<TableElement> errors, SubMonitor subProgress) {
        if (shareables != null) {
            IShareable[] iShareableArray = shareables;
            int n = shareables.length;
            int n2 = 0;
            while (n2 < n) {
                IShareable shareable = iShareableArray[n2];
                try {
                    if (shareable.getResourceType((IProgressMonitor)subProgress) == ResourceType.FILE && !shareable.shouldBeIgnored((IProgressMonitor)subProgress.newChild(1))) {
                        this.collectResources(shareable, errors, subProgress.newChild(1));
                        IContentType eclipseContentType = ResourceUtil.getContentTypeFor((String)shareable.getLocalPath().getName());
                        this.shareableToEclipseContentType.put(shareable, eclipseContentType);
                        ContentPropertiesPreference pref = this.manager.get(eclipseContentType, shareable.getLocalPath().getName());
                        this.shareableToPreference.put(shareable, pref);
                    } else {
                        Collection fsChildren = ((IShareableInternal)shareable).getFileStorage().getChildren(true, (IProgressMonitor)subProgress);
                        if (fsChildren != null && !fsChildren.isEmpty()) {
                            IShareable[] childShareables = new IShareable[fsChildren.size()];
                            int idx = 0;
                            for (IFileStorage fsChild : fsChildren) {
                                childShareables[idx++] = fsChild.getShareable();
                            }
                            this.collectRemoteShareables(childShareables, errors, subProgress.newChild(1));
                        }
                    }
                }
                catch (FileSystemException e) {
                    ChangeFilePropertiesWizard.addExceptionMessage(errors, Messages.ChangeFilePropertiesWizard_12, e, 2);
                }
                ++n2;
            }
        }
    }

    private void collectResources(IShareable shareable, List<TableElement> errors, SubMonitor subProgress) {
        try {
            if (shareable.shouldBeIgnored((IProgressMonitor)subProgress.newChild(1))) {
                return;
            }
        }
        catch (FileSystemException e) {
            ChangeFilePropertiesWizard.addExceptionMessage(errors, Messages.ChangeFilePropertiesWizard_12, e, 2);
        }
        String extension = ChangeFilePropertiesWizard.getFileExtension(shareable);
        FileLineDelimiter delimiter = null;
        try {
            delimiter = shareable.getLineDelimiter((IProgressMonitor)subProgress.newChild(1));
        }
        catch (FileSystemException e) {
            ChangeFilePropertiesWizard.addExceptionMessage(errors, Messages.ChangeFilePropertiesWizard_12, e, 2);
        }
        String contentType = null;
        try {
            contentType = ChangeFilePropertiesWizard.getContentType(shareable.getContentType((IProgressMonitor)subProgress.newChild(1)));
        }
        catch (FileSystemException e) {
            ChangeFilePropertiesWizard.addExceptionMessage(errors, Messages.ChangeFilePropertiesWizard_12, e, 2);
        }
        if (extension == null) {
            this.noExtension.add(shareable);
        } else {
            String lineDelimiterStr = ChangeFilePropertiesWizard.getLineDelimiter(delimiter);
            Set<IShareable> set = this.extensionMap.get(extension);
            if (set == null) {
                set = new HashSet<IShareable>();
                this.extensionMap.put(extension, set);
                this.extensionToLineDelimiter.put(extension, lineDelimiterStr);
                this.extensionToContentType.put(extension, contentType);
                ContentPropertiesPreference pref = this.manager.get(null, extension);
                this.extensionToPreference.put(extension, pref);
            }
            set.add(shareable);
            if (!this.extensionToLineDelimiter.get(extension).equals(lineDelimiterStr)) {
                this.extensionToLineDelimiter.put(extension, "");
            }
            if (!this.extensionToContentType.get(extension).equals(contentType)) {
                this.extensionToContentType.put(extension, "");
            }
        }
        this.newLineDelimiter.put(shareable, delimiter);
        this.currentLineDelimiter.put(shareable, delimiter);
        this.newContentType.put(shareable, contentType);
        this.currentContentType.put(shareable, contentType);
    }

    /*
     * Unable to fully structure code
     */
    private void collectResources(Object[] array, List<TableElement> errors, String taskName, IProgressMonitor monitor) {
        progress = SubMonitor.convert((IProgressMonitor)monitor, (String)taskName, (int)array.length);
        var9_6 = array;
        var8_7 = array.length;
        var7_8 = 0;
        while (var7_8 < var8_7) {
            block17: {
                block18: {
                    obj = var9_6[var7_8];
                    if (progress.isCanceled()) break;
                    if (!(obj instanceof IResource)) break block18;
                    resource = (IResource)obj;
                    switch (resource.getType()) {
                        case 1: {
                            subProgress = progress.newChild(1);
                            subProgress.setWorkRemaining(3);
                            file = (IFile)resource;
                            shareable = (IShareable)file.getAdapter(IShareable.class);
                            if (shareable != null) ** GOTO lbl21
                            errors.add(new TableElement(file.getProjectRelativePath(), Messages.ChangeFilePropertiesWizard_10, Messages.ChangeFilePropertiesWizard_11, 0));
                            break block17;
lbl21:
                            // 1 sources

                            try {
                                if (shareable.shouldBeIgnored((IProgressMonitor)subProgress.newChild(1))) {
                                    break block17;
                                }
                            }
                            catch (FileSystemException e) {
                                ChangeFilePropertiesWizard.addExceptionMessage(errors, Messages.ChangeFilePropertiesWizard_12, e, 2);
                            }
                            this.collectResources(shareable, errors, subProgress);
                            try {
                                eclipseContentType = ResourceUtil.getContentTypeFor((IFile)file);
                                this.shareableToEclipseContentType.put(shareable, eclipseContentType);
                                pref = this.manager.get(eclipseContentType, file.getName());
                                this.shareableToPreference.put(shareable, pref);
                            }
                            catch (CoreException e) {
                                ChangeFilePropertiesWizard.addExceptionMessage(errors, Messages.ChangeFilePropertiesWizard_12, e, 2);
                            }
                            break block17;
                        }
                        case 2: 
                        case 4: {
                            container = (IContainer)resource;
                            try {
                                members = container.members();
                                subtaskName = resource.getLocation().toPortableString();
                                progress.subTask(subtaskName);
                                this.collectResources(members, errors, subtaskName, (IProgressMonitor)progress.newChild(1));
                            }
                            catch (CoreException e) {
                                ChangeFilePropertiesWizard.addExceptionMessage(errors, Messages.ChangeFilePropertiesWizard_12, e, 2);
                            }
                            break block17;
                        }
                        default: {
                            throw new IllegalStateException("Unhandled case");
                        }
                    }
                }
                if (obj instanceof AbstractAdaptableRemoteResource) {
                    remote = (AbstractAdaptableRemoteResource)obj;
                    subProgress = progress.newChild(1);
                    subProgress.setWorkRemaining(3);
                    shareable = (IShareable)remote.getAdapter(IShareable.class);
                    try {
                        if (shareable == null || shareable.getShare(monitor) == null) {
                            remoteLocation = remote.getLocation();
                            errors.add(new TableElement(remoteLocation.getName(), remoteLocation.toString(), Messages.ChangeFilePropertiesWizard_10, Messages.ChangeFilePropertiesWizard_11, 0));
                            break block17;
                        }
                        this.collectRemoteShareables(new IShareable[]{shareable}, errors, subProgress);
                    }
                    catch (FileSystemException e) {
                        ChangeFilePropertiesWizard.addExceptionMessage(errors, Messages.ChangeFilePropertiesWizard_12, e, 2);
                    }
                } else {
                    errors.add(new TableElement(Messages.ChangeFilePropertiesWizard_12, Messages.ChangeFilePropertiesWizard_12, Messages.ChangeFilePropertiesWizard_18, obj.toString(), 1));
                    progress.worked(1);
                }
            }
            ++var7_8;
        }
    }

    private static String getFileExtension(IShareable shareable) {
        return ResourceUtil.getFileExtension((String)shareable.getLocalPath().getName());
    }

    public void addPages() {
        if (this.preErrorPage != null) {
            this.addPage((IWizardPage)this.preErrorPage);
        }
        this.changeFilePropertyPage = new ChangeFilePropertyPage();
        this.addPage((IWizardPage)this.changeFilePropertyPage);
        this.updatePreferencesPage = new UpdatePreferencesPage();
        this.addPage((IWizardPage)this.updatePreferencesPage);
        this.postErrorPage = new ErrorPage(Messages.ChangeFilePropertiesWizard_19, null);
        this.addPage((IWizardPage)this.postErrorPage);
    }

    private static void addExceptionMessage(List<TableElement> errors, String source, Throwable e, int category) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        e.printStackTrace(printWriter);
        printWriter.flush();
        stringWriter.flush();
        errors.add(new TableElement(source, source, e.getMessage() == null || "".equals(e.getMessage().trim()) ? e.getClass().getName() : e.getMessage(), stringWriter.toString(), category));
    }

    public boolean canFinish() {
        if (this.getContainer() != null && this.getContainer().getCurrentPage() == this.preErrorPage) {
            return false;
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        Object currentValue;
        Object newValue;
        IShareable shareable;
        if (this.getContainer() != null && this.getContainer().getCurrentPage() == this.postErrorPage) {
            return true;
        }
        final ArrayList<TableElement> errors = new ArrayList<TableElement>();
        if (this.getContainer() != null && this.getContainer().getCurrentPage() == this.updatePreferencesPage) {
            this.updatePreferencesPage.save(errors);
        }
        WarnChangeFileProperties dilemmaHandler = new WarnChangeFileProperties(this.getShell(), Messages.ChangeFilePropertiesWizard_21);
        final IChangePropertiesOperation operation = IOperationFactory.instance.getChangePropertiesOperation((ChangePropertiesDilemmaHandler)dilemmaHandler);
        for (Map.Entry<IShareable, FileLineDelimiter> entry : this.newLineDelimiter.entrySet()) {
            shareable = entry.getKey();
            newValue = entry.getValue();
            if (newValue.equals(currentValue = this.currentLineDelimiter.get(shareable))) continue;
            operation.setLineDelimiter(shareable, (FileLineDelimiter)newValue);
        }
        for (Map.Entry<IShareable, Object> entry : this.newContentType.entrySet()) {
            shareable = entry.getKey();
            newValue = (String)entry.getValue();
            if (((String)newValue).equals(currentValue = this.currentContentType.get(shareable))) continue;
            operation.setContentType(entry.getKey(), (String)entry.getValue());
        }
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        operation.run(monitor);
                    }
                    catch (FileSystemException e) {
                        ChangeFilePropertiesWizard.addExceptionMessage(errors, Messages.ChangeFilePropertiesWizard_12, e, 2);
                    }
                    catch (TeamRepositoryException e) {
                        ChangeFilePropertiesWizard.addExceptionMessage(errors, Messages.ChangeFilePropertiesWizard_12, e, 3);
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            ChangeFilePropertiesWizard.addExceptionMessage(errors, Messages.ChangeFilePropertiesWizard_12, invocationTargetException, 0);
        }
        catch (InterruptedException interruptedException) {
            ChangeFilePropertiesWizard.addExceptionMessage(errors, Messages.ChangeFilePropertiesWizard_12, interruptedException, 1);
        }
        if (errors.isEmpty()) {
            return true;
        }
        this.postErrorPage.viewer.setInput(errors);
        this.getContainer().showPage((IWizardPage)this.postErrorPage);
        return false;
    }

    public void dispose() {
        this.imageRegistry.dispose();
        super.dispose();
    }

    private static <K> void populateCombo(CCombo combo, Map<K, String> map, String currentForShareable, String guessedForShareable, String selectedByUi) {
        for (Map.Entry<K, String> entry : map.entrySet()) {
            String string;
            String text = string = entry.getValue();
            if (currentForShareable != null && currentForShareable.equals(string)) {
                text = String.valueOf(Messages.ChangeFilePropertiesWizard_30) + text;
            }
            if (guessedForShareable != null && guessedForShareable.equals(string)) {
                text = String.valueOf(Messages.ChangeFilePropertiesWizard_31) + text;
            }
            combo.add(text);
            combo.setData(text, entry.getKey());
            if (!string.equals(selectedByUi)) continue;
            combo.select(combo.getItemCount() - 1);
            combo.setText(string);
        }
    }

    private Image getColumnImage(Object element) {
        String key;
        if (element instanceof String) {
            key = (String)element;
        } else if (element instanceof IShareable) {
            IShareable shareable = (IShareable)element;
            key = shareable.getLocalPath().getName();
        } else {
            return null;
        }
        Image image = this.getImage(key);
        return image;
    }

    private Image getImage(String key) {
        Image image = this.imageRegistry.get(key);
        if (image == null) {
            ImageDescriptor descriptor = this.workbench.getEditorRegistry().getImageDescriptor(key);
            if (descriptor == null) {
                descriptor = UiPlugin.getFileSystemImageDescriptor(key);
            }
            if (descriptor != null) {
                this.imageRegistry.put(key, descriptor);
                image = this.imageRegistry.get(key);
            }
        }
        return image;
    }

    public void pageChanged(PageChangedEvent event) {
        if (event.getSelectedPage() == this.updatePreferencesPage) {
            Set contentTypes = this.changeFilePropertyPage.notAsPredictedContentTypes();
            this.updatePreferencesPage.setInput(contentTypes);
        }
    }

    private class ChangeFilePropertyPage
    extends WizardPage {
        private TreeViewer viewer;
        private TreeEditor lineDelimiterEditor;
        private TreeEditor contentTypeEditor;
        private CLabel fullPath;
        private CCombo contentTypeCombo;
        private CCombo lineDelimiterCombo;
        private TreeItem lastItem;
        private boolean disableValidation;
        private boolean showUpdatePreferencesPage;
        private SelectionListener lineDelimiterListener;
        private SelectionListener contentTypeListener;

        protected ChangeFilePropertyPage() {
            super(Messages.ChangeFilePropertiesWizard_32);
            this.lineDelimiterListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    FileLineDelimiter lineDelimiter = (FileLineDelimiter)ChangeFilePropertyPage.this.lineDelimiterCombo.getData(ChangeFilePropertyPage.this.lineDelimiterCombo.getItem(ChangeFilePropertyPage.this.lineDelimiterCombo.getSelectionIndex()));
                    String lineDelimiterString = ChangeFilePropertiesUtil.delimiterToString((FileLineDelimiter)lineDelimiter);
                    if (lineDelimiterString != null) {
                        ChangeFilePropertyPage.this.comboSelected(ChangeFilePropertyPage.this.lineDelimiterCombo, ChangeFilePropertiesWizard.this.newLineDelimiter, ChangeFilePropertiesWizard.this.extensionToLineDelimiter, lineDelimiter, lineDelimiterString);
                    }
                }
            };
            this.contentTypeListener = new SelectionListener(){

                private void validateMimeType() {
                    String contentType = (String)ChangeFilePropertyPage.this.contentTypeCombo.getData(ChangeFilePropertyPage.this.contentTypeCombo.getItem(ChangeFilePropertyPage.this.contentTypeCombo.getSelectionIndex()));
                    ChangeFilePropertyPage.this.setMessage(null);
                    if (!ChangePropertiesOperation.validMimeType((String)contentType)) {
                        ChangeFilePropertyPage.this.setMessage(NLS.bind((String)Messages.ChangeFilePropertiesWizard_39, (Object)contentType), 3);
                    }
                    if (contentType != null) {
                        ChangeFilePropertyPage.this.comboSelected(ChangeFilePropertyPage.this.contentTypeCombo, ChangeFilePropertiesWizard.this.newContentType, ChangeFilePropertiesWizard.this.extensionToContentType, contentType, contentType);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.validateMimeType();
                }

                public void widgetSelected(SelectionEvent e) {
                    this.validateMimeType();
                }
            };
            this.setTitle(Messages.ChangeFilePropertiesWizard_33);
            this.setDescription(Messages.ChangeFilePropertiesWizard_34);
            this.showUpdatePreferencesPage = false;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            Label help = new Label(composite, 64);
            help.setText(Messages.ChangeFilePropertiesWizard_35);
            Composite treeComposite = new Composite(composite, 0);
            final Tree tree = new Tree(treeComposite, 68352);
            GridLayoutFactory.fillDefaults().generateLayout(treeComposite);
            tree.setHeaderVisible(true);
            TreeColumn column1 = new TreeColumn(tree, 16384);
            column1.setText(Messages.ChangeFilePropertiesWizard_36);
            column1.setWidth(200);
            TreeColumn column2 = new TreeColumn(tree, 16384);
            column2.setText(Messages.ChangeFilePropertiesWizard_37);
            column2.setWidth(100);
            column2.setToolTipText(Messages.ChangeFilePropertiesUtil_MimeTooltip);
            TreeColumn column3 = new TreeColumn(tree, 16384);
            column3.setText(Messages.ChangeFilePropertiesWizard_38);
            column3.setWidth(100);
            column3.setResizable(false);
            column3.setToolTipText(Messages.ChangeFilePropertiesUtil_LineDelimiterTooltip);
            TableOrTreeResizer.addResizeListener(tree);
            this.viewer = new TreeViewer(tree);
            this.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

                public Object[] getChildren(Object parentElement) {
                    if (parentElement.equals(tree)) {
                        ArrayList<Object> objects = new ArrayList<Object>();
                        for (Map.Entry entry : ChangeFilePropertiesWizard.this.extensionMap.entrySet()) {
                            if (((Set)entry.getValue()).size() > 1) {
                                objects.add(entry.getKey());
                                continue;
                            }
                            IShareable shareable = (IShareable)((Set)entry.getValue()).iterator().next();
                            objects.add(shareable);
                        }
                        objects.addAll(ChangeFilePropertiesWizard.this.noExtension);
                        ChangeFilePropertyPage.this.calculatePageComplete();
                        return objects.toArray();
                    }
                    return new Object[0];
                }

                public Object getParent(Object element) {
                    return null;
                }

                public boolean hasChildren(Object element) {
                    return false;
                }

                public Object[] getElements(Object inputElement) {
                    return this.getChildren(inputElement);
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            this.viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

                public Image getColumnImage(Object element, int columnIndex) {
                    if (columnIndex != 0) {
                        return null;
                    }
                    return ChangeFilePropertiesWizard.this.getColumnImage(element);
                }

                public String getColumnText(Object element, int columnIndex) {
                    if (element instanceof String) {
                        switch (columnIndex) {
                            case 0: {
                                return (String)element;
                            }
                            case 1: {
                                return (String)ChangeFilePropertiesWizard.this.extensionToContentType.get((String)element);
                            }
                            case 2: {
                                return (String)ChangeFilePropertiesWizard.this.extensionToLineDelimiter.get((String)element);
                            }
                        }
                    } else if (element instanceof IShareable) {
                        IShareable shareable = (IShareable)element;
                        switch (columnIndex) {
                            case 0: {
                                return shareable.getLocalPath().getName();
                            }
                            case 1: {
                                return (String)ChangeFilePropertiesWizard.this.newContentType.get(shareable);
                            }
                            case 2: {
                                return ChangeFilePropertiesUtil.delimiterToString((FileLineDelimiter)((FileLineDelimiter)ChangeFilePropertiesWizard.this.newLineDelimiter.get(shareable)));
                            }
                        }
                    }
                    return "";
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            });
            this.viewer.setSorter(new ViewerSorter(){

                public int category(Object element) {
                    if (element instanceof String) {
                        return 0;
                    }
                    return 1;
                }
            });
            this.viewer.setInput((Object)tree);
            this.createContentTypeCombo(tree);
            this.contentTypeCombo.setToolTipText(column2.getToolTipText());
            this.createLineDelimiterCombo(tree);
            this.lineDelimiterCombo.setToolTipText(column3.getToolTipText());
            tree.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    if (e.item == ChangeFilePropertyPage.this.lastItem || e.item == null) {
                        return;
                    }
                    ChangeFilePropertyPage.this.disableValidation = true;
                    ChangeFilePropertyPage.this.lastItem = (TreeItem)e.item;
                    IShareable shareable = null;
                    String extension = null;
                    if (ChangeFilePropertyPage.this.lastItem.getData() instanceof IShareable) {
                        shareable = (IShareable)ChangeFilePropertyPage.this.lastItem.getData();
                    } else {
                        extension = (String)ChangeFilePropertyPage.this.lastItem.getData();
                    }
                    ChangeFilePropertyPage.this.populateContentTypeCombo(shareable, extension);
                    ChangeFilePropertyPage.this.populateLineDelimiterCombo(shareable, extension);
                    String fullPathText = extension != null ? extension : shareable.getLocalPath().toString();
                    ChangeFilePropertyPage.this.fullPath.setText(fullPathText);
                    ChangeFilePropertyPage.this.fullPath.setToolTipText(fullPathText);
                    ChangeFilePropertyPage.this.contentTypeCombo.setVisibleItemCount(ChangeFilePropertyPage.this.contentTypeCombo.getItemCount());
                    ChangeFilePropertyPage.this.contentTypeEditor.setEditor((Control)ChangeFilePropertyPage.this.contentTypeCombo, ChangeFilePropertyPage.this.lastItem, 1);
                    ChangeFilePropertyPage.this.contentTypeEditor.layout();
                    ChangeFilePropertyPage.this.lineDelimiterCombo.setVisibleItemCount(ChangeFilePropertyPage.this.lineDelimiterCombo.getItemCount());
                    ChangeFilePropertyPage.this.lineDelimiterEditor.setEditor((Control)ChangeFilePropertyPage.this.lineDelimiterCombo, ChangeFilePropertyPage.this.lastItem, 2);
                    ChangeFilePropertyPage.this.lineDelimiterEditor.layout();
                    ChangeFilePropertyPage.this.disableValidation = false;
                }
            });
            tree.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    Point p = new Point(e.x, e.y);
                    TreeItem item = tree.getItem(p);
                    if (item == null) {
                        return;
                    }
                    if (item.getBounds(1).contains(p)) {
                        ChangeFilePropertyPage.this.contentTypeCombo.setFocus();
                    }
                }
            });
            this.fullPath = new CLabel(composite, 64);
            if (ChangeFilePropertiesWizard.this.seedResource != null) {
                ChangeFilePropertiesUtil.createLinkToUserPropertiesPage((Composite)composite, (IPath)ChangeFilePropertiesWizard.this.seedResource.getFullPath(), (SelectionListener)new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)ChangeFilePropertyPage.this.getShell(), (IAdaptable)ChangeFilePropertiesWizard.this.seedResource, (String)"com.ibm.team.filesystem.ui.versionablePropertiesPropertyPage", (String[])PropertyNamespaceManager.getInstance().getClientPageIds(), null);
                        dialog.open();
                    }
                });
            }
            Dialog.applyDialogFont((Control)composite);
            GridLayoutFactory.fillDefaults().extendedMargins(LayoutConstants2.getWizardPageMargins()).generateLayout(composite);
            this.calculatePageComplete();
            this.setErrorMessage(null);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.team.filesystem.ide.ui.wizard_changefileproperties");
            this.setControl((Control)composite);
        }

        private void createLineDelimiterCombo(Tree tree) {
            this.lineDelimiterEditor = new TreeEditor(tree);
            this.lineDelimiterEditor.horizontalAlignment = 16384;
            this.lineDelimiterEditor.grabHorizontal = true;
            this.lineDelimiterEditor.grabVertical = true;
            this.lineDelimiterCombo = new CCombo((Composite)tree, 2060);
            this.lineDelimiterCombo.setBackground(tree.getBackground());
            this.lineDelimiterCombo.addSelectionListener(this.lineDelimiterListener);
        }

        private void createContentTypeCombo(Tree tree) {
            this.contentTypeEditor = new TreeEditor(tree);
            this.contentTypeEditor.horizontalAlignment = 16384;
            this.contentTypeEditor.grabHorizontal = true;
            this.contentTypeEditor.grabVertical = true;
            this.contentTypeCombo = new CCombo((Composite)tree, 2052);
            this.contentTypeCombo.setBackground(tree.getBackground());
            this.contentTypeCombo.addSelectionListener(this.contentTypeListener);
            this.contentTypeCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (ChangeFilePropertyPage.this.disableValidation) {
                        return;
                    }
                    String extension = null;
                    IShareable shareable = null;
                    if (ChangeFilePropertyPage.this.lastItem.getData() instanceof String) {
                        extension = (String)ChangeFilePropertyPage.this.lastItem.getData();
                    } else {
                        shareable = (IShareable)ChangeFilePropertyPage.this.lastItem.getData();
                    }
                    String text = ChangeFilePropertyPage.this.contentTypeCombo.getText().trim().toLowerCase();
                    ChangeFilePropertyPage.this.setMessage(null);
                    if (!ChangePropertiesOperation.validMimeType((String)text)) {
                        ChangeFilePropertyPage.this.setMessage(NLS.bind((String)Messages.ChangeFilePropertiesWizard_39, (Object)text), 3);
                    }
                    if (extension != null) {
                        for (IShareable s : (Set)ChangeFilePropertiesWizard.this.extensionMap.get(extension)) {
                            ChangeFilePropertiesWizard.this.newContentType.put(s, text);
                        }
                        ChangeFilePropertiesWizard.this.extensionToContentType.put(extension, text);
                        ChangeFilePropertyPage.this.viewer.update((Object)extension, null);
                    } else {
                        ChangeFilePropertiesWizard.this.newContentType.put(shareable, text);
                        ChangeFilePropertyPage.this.viewer.update((Object)shareable, null);
                        ChangeFilePropertyPage.this.updateExtensionNode(ChangeFilePropertiesWizard.this.newContentType, ChangeFilePropertiesWizard.this.extensionToContentType, text, text, shareable);
                    }
                    ChangeFilePropertyPage.this.calculatePageComplete();
                }
            });
            this.contentTypeCombo.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    if (ChangeFilePropertyPage.this.getErrorMessage() != null) {
                        IShareable shareable = null;
                        String extension = null;
                        if (ChangeFilePropertyPage.this.lastItem.getData() instanceof IShareable) {
                            shareable = (IShareable)ChangeFilePropertyPage.this.lastItem.getData();
                        } else {
                            extension = (String)ChangeFilePropertyPage.this.lastItem.getData();
                        }
                        ChangeFilePropertyPage.this.populateContentTypeCombo(shareable, extension);
                        ChangeFilePropertyPage.this.calculatePageComplete();
                    }
                }
            });
        }

        private void populateLineDelimiterCombo(IShareable shareable, String extension) {
            this.lineDelimiterCombo.removeAll();
            String lineDelimiterSelectedByUi = null;
            String currentLineDelimiterForShareable = null;
            if (extension != null) {
                lineDelimiterSelectedByUi = (String)ChangeFilePropertiesWizard.this.extensionToLineDelimiter.get(extension);
            } else {
                currentLineDelimiterForShareable = ChangeFilePropertiesWizard.getLineDelimiter((FileLineDelimiter)ChangeFilePropertiesWizard.this.currentLineDelimiter.get(shareable));
                lineDelimiterSelectedByUi = ChangeFilePropertiesUtil.delimiterToString((FileLineDelimiter)((FileLineDelimiter)ChangeFilePropertiesWizard.this.newLineDelimiter.get(shareable)));
            }
            ChangeFilePropertiesWizard.populateCombo(this.lineDelimiterCombo, ChangeFilePropertiesUtil.DELIMITER_STRINGS, currentLineDelimiterForShareable, null, lineDelimiterSelectedByUi);
        }

        private void populateContentTypeCombo(IShareable shareable, String extension) {
            this.contentTypeCombo.removeAll();
            String contentTypeSelectedByUi = null;
            String currentContentTypeForShareable = null;
            String commonExtension = null;
            String guess = null;
            TreeMap<String, String> uniqueContentTypes = new TreeMap<String, String>();
            if (extension != null) {
                contentTypeSelectedByUi = (String)ChangeFilePropertiesWizard.this.extensionToContentType.get(extension);
                guess = ((ContentPropertiesPreference)ChangeFilePropertiesWizard.this.extensionToPreference.get(extension)).getMimeType();
                commonExtension = extension;
            } else {
                currentContentTypeForShareable = (String)ChangeFilePropertiesWizard.this.currentContentType.get(shareable);
                contentTypeSelectedByUi = (String)ChangeFilePropertiesWizard.this.newContentType.get(shareable);
                commonExtension = ChangeFilePropertiesWizard.getFileExtension(shareable);
                if (currentContentTypeForShareable != null) {
                    uniqueContentTypes.put(currentContentTypeForShareable, currentContentTypeForShareable);
                }
                guess = ((ContentPropertiesPreference)ChangeFilePropertiesWizard.this.shareableToPreference.get(shareable)).getMimeType();
                uniqueContentTypes.put(guess, guess);
            }
            if (commonExtension != null) {
                String contentType;
                for (IShareable iShareable : (Set)ChangeFilePropertiesWizard.this.extensionMap.get(commonExtension)) {
                    contentType = (String)ChangeFilePropertiesWizard.this.currentContentType.get(iShareable);
                    if (contentType != null) {
                        uniqueContentTypes.put(contentType, contentType);
                    }
                    if ((contentType = MIME_MAP.getContentTypeFor(iShareable.getLocalPath().getName())) == null) {
                        contentType = "application/unknown";
                    }
                    uniqueContentTypes.put(contentType, contentType);
                }
                for (Map.Entry entry : ChangeFilePropertiesWizard.this.newContentType.entrySet()) {
                    if (!commonExtension.equals(ChangeFilePropertiesWizard.getFileExtension((IShareable)entry.getKey()))) continue;
                    contentType = (String)entry.getValue();
                    uniqueContentTypes.put(contentType, contentType);
                }
            }
            uniqueContentTypes.put(contentTypeSelectedByUi, contentTypeSelectedByUi);
            uniqueContentTypes.remove("");
            ChangeFilePropertiesWizard.populateCombo(this.contentTypeCombo, uniqueContentTypes, currentContentTypeForShareable, guess, contentTypeSelectedByUi);
            String string = this.contentTypeCombo.getText().trim();
            if (string.length() != 0) {
                String string2 = string.toLowerCase();
                this.setMessage(null);
                if (!ChangePropertiesOperation.validMimeType((String)string2)) {
                    this.setMessage(NLS.bind((String)Messages.ChangeFilePropertiesWizard_39, (Object)string2), 3);
                }
            }
        }

        public IWizardPage getNextPage() {
            return this.showUpdatePreferencesPage ? ChangeFilePropertiesWizard.this.updatePreferencesPage : null;
        }

        private <T> void comboSelected(CCombo combo, Map<IShareable, T> newT, Map<String, String> extensionToT, T t, String tString) {
            if (this.lastItem.getData() instanceof IShareable) {
                IShareable shareable = (IShareable)this.lastItem.getData();
                newT.put(shareable, t);
                this.viewer.update((Object)shareable, null);
                this.updateExtensionNode(newT, extensionToT, t, tString, shareable);
            } else {
                String extension = (String)this.lastItem.getData();
                if (t != null) {
                    Set set = (Set)ChangeFilePropertiesWizard.this.extensionMap.get((String)this.lastItem.getData());
                    for (IShareable shareable : set) {
                        newT.put(shareable, t);
                    }
                    extensionToT.put(extension, tString);
                    this.viewer.update((Object)extension, null);
                } else {
                    extensionToT.put(extension, "");
                    this.viewer.update((Object)extension, null);
                }
            }
            combo.setText(tString);
            combo.setSelection(new Point(0, tString.length()));
            this.calculatePageComplete();
        }

        private <T> void updateExtensionNode(Map<IShareable, T> newT, Map<String, String> extensionToT, T t, String tString, IShareable shareable) {
            String extension = ChangeFilePropertiesWizard.getFileExtension(shareable);
            if (extension != null) {
                Set shareables = (Set)ChangeFilePropertiesWizard.this.extensionMap.get(extension);
                extensionToT.put(extension, tString);
                for (IShareable s : shareables) {
                    if (newT.get(s).equals(t)) continue;
                    extensionToT.put(extension, "");
                    break;
                }
                this.viewer.update((Object)extension, null);
            }
        }

        private boolean calculateShareableComplete(IShareable shareable) {
            if (ChangeFilePropertiesWizard.this.newLineDelimiter.get(shareable) == null) {
                this.setErrorMessage(NLS.bind((String)Messages.ChangeFilePropertiesWizard_40, (Object)shareable.getLocalPath().toString()));
                this.setPageComplete(false);
                return false;
            }
            String text = (String)ChangeFilePropertiesWizard.this.newContentType.get(shareable);
            if (!ChangePropertiesOperation.validMimeType((String)text)) {
                this.setErrorMessage(NLS.bind((String)Messages.ChangeFilePropertiesWizard_39, (Object)text));
                this.setPageComplete(false);
                return false;
            }
            return true;
        }

        private Set<String> notAsPredictedContentTypes() {
            HashSet<String> contentTypes = new HashSet<String>();
            for (Map.Entry entry : ChangeFilePropertiesWizard.this.shareableToPreference.entrySet()) {
                String appliedContentType = (String)ChangeFilePropertiesWizard.this.newContentType.get(entry.getKey());
                if (appliedContentType.equals(((ContentPropertiesPreference)entry.getValue()).getMimeType())) continue;
                contentTypes.add(appliedContentType);
            }
            return contentTypes;
        }

        private Set<IShareable> notAsPredictedShareables() {
            HashSet<IShareable> shareables = new HashSet<IShareable>();
            for (Map.Entry entry : ChangeFilePropertiesWizard.this.shareableToPreference.entrySet()) {
                String appliedContentType = (String)ChangeFilePropertiesWizard.this.newContentType.get(entry.getKey());
                if (appliedContentType.equals(((ContentPropertiesPreference)entry.getValue()).getMimeType())) continue;
                shareables.add((IShareable)entry.getKey());
            }
            return shareables;
        }

        private void calculatePageComplete() {
            TreeItem[] items = this.viewer.getTree().getItems();
            if (!this.calculateItemsCompleteDFS(items)) {
                return;
            }
            this.setErrorMessage(null);
            this.showUpdatePreferencesPage = !this.notAsPredictedContentTypes().isEmpty();
            this.setPageComplete(true);
        }

        private boolean calculateItemsCompleteDFS(TreeItem[] items) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (item.getData() instanceof IShareable) {
                    if (!this.calculateShareableComplete((IShareable)item.getData())) {
                        return false;
                    }
                } else if (item.getData() instanceof String) {
                    String extension = (String)item.getData();
                    for (IShareable shareable : (Set)ChangeFilePropertiesWizard.this.extensionMap.get(extension)) {
                        if (this.calculateShareableComplete(shareable)) continue;
                        return false;
                    }
                }
                if (!this.calculateItemsCompleteDFS(item.getItems())) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public void dispose() {
            this.lineDelimiterEditor.dispose();
            this.contentTypeEditor.dispose();
            super.dispose();
        }
    }

    private class ErrorPage
    extends WizardPage {
        private TableViewer viewer;
        private Label fullPath;
        private Text details;
        private List<TableElement> errors;

        public ErrorPage(String description, List<TableElement> errors) {
            super(Messages.ChangeFilePropertiesWizard_42);
            this.setTitle(Messages.ChangeFilePropertiesWizard_43);
            this.setDescription(description);
            this.errors = errors;
        }

        public void createControl(Composite parent) {
            Composite margin = new Composite(parent, 0);
            SashForm sashForm = new SashForm(margin, 512);
            GridLayoutFactory.fillDefaults().applyTo((Composite)sashForm);
            Composite tableComposite = new Composite((Composite)sashForm, 0);
            GridLayoutFactory.fillDefaults().generateLayout(tableComposite);
            Table table = new Table(tableComposite, 68352);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)table);
            TableColumn column1 = new TableColumn(table, 16384);
            table.setHeaderVisible(true);
            column1.setText(Messages.ChangeFilePropertiesWizard_44);
            column1.setWidth(200);
            TableColumn column2 = new TableColumn(table, 16384);
            column2.setText(Messages.ChangeFilePropertiesWizard_45);
            column2.setWidth(200);
            TableOrTreeResizer.addResizeListener(table);
            this.viewer = new TableViewer(table);
            this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    List elements = (List)inputElement;
                    return elements.toArray();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            this.viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

                public Image getColumnImage(Object element, int columnIndex) {
                    if (columnIndex != 0) {
                        return null;
                    }
                    TableElement tableElement = (TableElement)element;
                    String imagePath = tableElement.getImage();
                    if (imagePath == null) {
                        return null;
                    }
                    return ChangeFilePropertiesWizard.this.getImage(imagePath);
                }

                public String getColumnText(Object element, int columnIndex) {
                    TableElement tableElement = (TableElement)element;
                    switch (columnIndex) {
                        case 0: {
                            return tableElement.getShortPathString();
                        }
                        case 1: {
                            return tableElement.message;
                        }
                    }
                    return null;
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            });
            this.viewer.setSorter(new ViewerSorter(){

                public int category(Object element) {
                    TableElement tableElement = (TableElement)element;
                    return tableElement.category;
                }
            });
            this.viewer.setInput(this.errors);
            table.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    TableElement tableElement = (TableElement)e.item.getData();
                    ErrorPage.this.fullPath.setText(tableElement.getFullPathString());
                    ErrorPage.this.details.setText(tableElement.details);
                }
            });
            Composite composite = new Composite((Composite)sashForm, 0);
            this.fullPath = new Label(composite, 0);
            Label detailsTitle = new Label(composite, 0);
            detailsTitle.setText(Messages.ChangeFilePropertiesWizard_46);
            this.details = new Text(composite, 2632);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.details);
            GridLayoutFactory.fillDefaults().generateLayout(composite);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)sashForm);
            Dialog.applyDialogFont((Control)margin);
            GridLayoutFactory.fillDefaults().extendedMargins(LayoutConstants2.getWizardPageMargins()).generateLayout(margin);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)margin, "com.ibm.team.filesystem.ide.ui.wizard_changefileproperties_error");
            this.setControl((Control)margin);
        }

        public IWizardPage getPreviousPage() {
            return null;
        }
    }

    private static class TableElement {
        public String shortPath;
        public String longPath;
        public String image;
        public String message;
        public String details;
        public int category;

        public TableElement(IPath path, String message, String details, int category) {
            this.shortPath = path.lastSegment();
            this.longPath = path.toOSString();
            this.message = message;
            this.details = details;
            this.category = category;
        }

        public TableElement(String path, String longPath, String message, String details, int category) {
            this.shortPath = path;
            this.longPath = longPath;
            this.message = message;
            this.details = details;
            this.category = category;
        }

        public String getShortPathString() {
            return this.shortPath;
        }

        public String getFullPathString() {
            return this.longPath;
        }

        public String getImage() {
            return this.image;
        }
    }

    private class UpdatePreferencesPage
    extends WizardPage {
        private Map<IContentType, Set<IContentType>> contentTypeTree;
        private CheckboxTreeViewer viewer;
        private Table table;
        private ITableLabelProvider labelProvider;
        private Map<Object, Set<String>> savePreference;
        private Map<String, TreePath[]> expanded;

        protected UpdatePreferencesPage() {
            super(Messages.ChangeFilePropertiesWizard_47);
            this.contentTypeTree = new HashMap<IContentType, Set<IContentType>>();
            this.savePreference = new HashMap<Object, Set<String>>();
            this.expanded = new HashMap<String, TreePath[]>();
            this.setTitle(Messages.ChangeFilePropertiesWizard_48);
            this.setDescription(Messages.ChangeFilePropertiesWizard_49);
        }

        private void buildTree(IContentType contentType) {
            if (this.contentTypeTree.containsKey(contentType)) {
                return;
            }
            this.contentTypeTree.put(contentType, new HashSet());
            IContentType parent = contentType.getBaseType();
            if (parent != null) {
                this.buildTree(parent);
                Set<IContentType> siblings = this.contentTypeTree.get(parent);
                siblings.add(contentType);
            }
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            Label help = new Label(composite, 64);
            help.setText(Messages.ChangeFilePropertiesWizard_50);
            help = new Label(composite, 64);
            help.setText(Messages.ChangeFilePropertiesWizard_51);
            ChangeFilePropertiesUtil.createLinkToFilePropertiesPreferencePage((Composite)composite, (SelectionListener)new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    PreferenceDialog prefDialog = PreferencesUtil.createPreferenceDialogOn((Shell)UpdatePreferencesPage.this.getShell(), (String)"com.ibm.team.filesystem.ide.ui.changefileproperties.ChangeFilePropertiesPreferencePage", null, null);
                    prefDialog.open();
                    UpdatePreferencesPage.this.savePreference.clear();
                    UpdatePreferencesPage.this.expanded.clear();
                    for (IShareable shareable : ChangeFilePropertiesWizard.this.shareableToPreference.keySet()) {
                        IContentType eclipseContentType = (IContentType)ChangeFilePropertiesWizard.this.shareableToEclipseContentType.get(shareable);
                        ContentPropertiesPreference pref = ((UpdatePreferencesPage)UpdatePreferencesPage.this).ChangeFilePropertiesWizard.this.manager.get(eclipseContentType, shareable.getLocalPath().getName());
                        ChangeFilePropertiesWizard.this.shareableToPreference.put(shareable, pref);
                    }
                    Set contentTypes = ChangeFilePropertiesWizard.this.changeFilePropertyPage.notAsPredictedContentTypes();
                    UpdatePreferencesPage.this.setInput(contentTypes);
                    UpdatePreferencesPage.this.viewer.refresh();
                }
            });
            SashForm sashForm = new SashForm(composite, 256);
            GridDataFactory.fillDefaults().grab(true, true).hint(150, 150).applyTo((Control)sashForm);
            Composite left = new Composite((Composite)sashForm, 0);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)left);
            this.table = new Table(left, 2048);
            GridLayoutFactory.fillDefaults().generateLayout(left);
            this.table.setHeaderVisible(true);
            TableColumn tableColumn = new TableColumn(this.table, 0);
            tableColumn.setText(Messages.ChangeFilePropertiesWizard_52);
            tableColumn.setWidth(100);
            Composite right = new Composite((Composite)sashForm, 0);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)right);
            this.viewer = new CheckboxTreeViewer(right);
            Tree tree = this.viewer.getTree();
            GridLayoutFactory.fillDefaults().generateLayout(right);
            tree.setHeaderVisible(true);
            TreeColumn treeColumn1 = new TreeColumn(tree, 0);
            treeColumn1.setText(Messages.ChangeFilePropertiesWizard_53);
            treeColumn1.setWidth(180);
            TreeColumn treeColumn2 = new TreeColumn(tree, 0);
            treeColumn2.setText(Messages.ChangeFilePropertiesWizard_54);
            treeColumn2.setWidth(120);
            this.table.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    Object contentType = e.item.getData();
                    String oldInput = (String)UpdatePreferencesPage.this.viewer.getInput();
                    if (oldInput != null) {
                        UpdatePreferencesPage.this.expanded.put(oldInput, UpdatePreferencesPage.this.viewer.getExpandedTreePaths());
                    }
                    UpdatePreferencesPage.this.viewer.setInput(contentType);
                    TreePath[] expandedPaths = (TreePath[])UpdatePreferencesPage.this.expanded.get(contentType);
                    if (expandedPaths != null) {
                        UpdatePreferencesPage.this.viewer.setExpandedTreePaths(expandedPaths);
                    }
                    UpdatePreferencesPage.this.setCheckedElements(contentType);
                }
            });
            this.viewer.addTreeListener(new ITreeViewerListener(){

                public void treeCollapsed(TreeExpansionEvent event) {
                }

                public void treeExpanded(TreeExpansionEvent event) {
                    UpdatePreferencesPage.this.setCheckedElements(UpdatePreferencesPage.this.viewer.getInput());
                }
            });
            this.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

                public Object[] getChildren(Object parentElement) {
                    if (parentElement instanceof String) {
                        String string = (String)parentElement;
                        if (string.charAt(0) != '*') {
                            String contentType = string;
                            HashSet<Object> children = new HashSet<Object>();
                            UpdatePreferencesPage.this.contentTypeTree.clear();
                            for (Map.Entry entry : ChangeFilePropertiesWizard.this.newContentType.entrySet()) {
                                IContentType parent;
                                IShareable shareable = (IShareable)entry.getKey();
                                String appliedContentType = (String)entry.getValue();
                                if (!appliedContentType.equals(contentType) || appliedContentType.equals(((ContentPropertiesPreference)ChangeFilePropertiesWizard.this.shareableToPreference.get(shareable)).getMimeType())) continue;
                                String extension = ChangeFilePropertiesWizard.getFileExtension(shareable);
                                if (extension == null) {
                                    children.add(shareable);
                                } else {
                                    children.add(extension);
                                }
                                IContentType eclipseContentType = (IContentType)ChangeFilePropertiesWizard.this.shareableToEclipseContentType.get(shareable);
                                if (eclipseContentType == null) continue;
                                UpdatePreferencesPage.this.buildTree(eclipseContentType);
                                while ((parent = eclipseContentType.getBaseType()) != null) {
                                    eclipseContentType = parent;
                                }
                                children.add(eclipseContentType);
                            }
                            return children.toArray();
                        }
                        Set children = (Set)ChangeFilePropertiesWizard.this.extensionMap.get(string);
                        String contentType = (String)UpdatePreferencesPage.this.viewer.getInput();
                        if (children.size() == 1) {
                            IShareable shareable = (IShareable)children.iterator().next();
                            if (((String)ChangeFilePropertiesWizard.this.newContentType.get(shareable)).equals(contentType) && !((ContentPropertiesPreference)ChangeFilePropertiesWizard.this.shareableToPreference.get(shareable)).getMimeType().equals(contentType)) {
                                return new Object[]{shareable};
                            }
                        }
                        return new Object[0];
                    }
                    if (parentElement instanceof IContentType) {
                        Set children = (Set)UpdatePreferencesPage.this.contentTypeTree.get(parentElement);
                        return children.toArray();
                    }
                    return new Object[0];
                }

                public Object getParent(Object element) {
                    return null;
                }

                public boolean hasChildren(Object element) {
                    return this.getChildren(element).length > 0;
                }

                public Object[] getElements(Object inputElement) {
                    return this.getChildren(inputElement);
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            this.labelProvider = new ITableLabelProvider(){

                public Image getColumnImage(Object element, int columnIndex) {
                    if (columnIndex != 0) {
                        return null;
                    }
                    return ChangeFilePropertiesWizard.this.getColumnImage(element);
                }

                public String getColumnText(Object element, int columnIndex) {
                    if (element instanceof String) {
                        String extension = (String)element;
                        switch (columnIndex) {
                            case 0: {
                                return extension;
                            }
                            case 1: {
                                return ((UpdatePreferencesPage)UpdatePreferencesPage.this).ChangeFilePropertiesWizard.this.manager.get(null, extension).getMimeType();
                            }
                        }
                    } else if (element instanceof IContentType) {
                        IContentType contentType = (IContentType)element;
                        switch (columnIndex) {
                            case 0: {
                                return contentType.getName();
                            }
                            case 1: {
                                if (contentType.getId().equals("org.eclipse.core.runtime.text")) {
                                    return NLS.bind((String)Messages.ChangeFilePropertiesWizard_55, (Object)((UpdatePreferencesPage)UpdatePreferencesPage.this).ChangeFilePropertiesWizard.this.manager.get(contentType, null).getMimeType());
                                }
                                return ((UpdatePreferencesPage)UpdatePreferencesPage.this).ChangeFilePropertiesWizard.this.manager.get(contentType, null).getMimeType();
                            }
                        }
                    } else if (element instanceof IShareable) {
                        IShareable shareable = (IShareable)element;
                        switch (columnIndex) {
                            case 0: {
                                return shareable.getLocalPath().getName();
                            }
                            case 1: {
                                return ((ContentPropertiesPreference)ChangeFilePropertiesWizard.this.shareableToPreference.get(shareable)).getMimeType();
                            }
                        }
                    }
                    throw new IllegalStateException();
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            };
            this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            this.viewer.setSorter(new ViewerSorter(){

                public int category(Object element) {
                    if (element instanceof IContentType) {
                        return 0;
                    }
                    if (element instanceof String) {
                        return 1;
                    }
                    if (element instanceof IShareable) {
                        return 2;
                    }
                    return 3;
                }
            });
            this.viewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    Object data = event.getElement();
                    if (data instanceof IContentType && ((IContentType)data).getId().equals("org.eclipse.core.runtime.text")) {
                        UpdatePreferencesPage.this.viewer.setGrayChecked(data, false);
                        return;
                    }
                    Set<String> set = (HashSet<String>)UpdatePreferencesPage.this.savePreference.get(data);
                    if (set == null) {
                        set = new HashSet<String>();
                        UpdatePreferencesPage.this.savePreference.put(data, set);
                    }
                    if (event.getChecked()) {
                        set.add((String)UpdatePreferencesPage.this.viewer.getInput());
                    } else {
                        set.remove((String)UpdatePreferencesPage.this.viewer.getInput());
                    }
                    boolean ok = this.calculateSavePreferenceComplete(data, set);
                    if (ok) {
                        for (Map.Entry entry : UpdatePreferencesPage.this.savePreference.entrySet()) {
                            if (this.calculateSavePreferenceComplete(entry.getKey(), (Set)entry.getValue())) continue;
                            ok = false;
                            break;
                        }
                    }
                    if (ok) {
                        IShareable stillNotAsPredicted = null;
                        String pref = null;
                        Object key = null;
                        block1: for (IShareable shareable : ChangeFilePropertiesWizard.this.changeFilePropertyPage.notAsPredictedShareables()) {
                            pref = null;
                            key = shareable;
                            set = (Set)UpdatePreferencesPage.this.savePreference.get(key);
                            if (set != null && set.size() == 1) continue;
                            IContentType contentType = (IContentType)ChangeFilePropertiesWizard.this.shareableToEclipseContentType.get(shareable);
                            key = contentType;
                            while (contentType != null) {
                                set = (Set)UpdatePreferencesPage.this.savePreference.get(contentType);
                                if (set != null && set.size() == 1) {
                                    pref = set.iterator().next();
                                    if (!pref.equals(ChangeFilePropertiesWizard.this.newContentType.get(shareable))) {
                                        stillNotAsPredicted = shareable;
                                        break block1;
                                    }
                                    pref = null;
                                    continue block1;
                                }
                                contentType = contentType.getBaseType();
                                key = contentType;
                            }
                            key = ChangeFilePropertiesWizard.getFileExtension(shareable);
                            if (key != null && (set = (Set)UpdatePreferencesPage.this.savePreference.get(key)) != null && set.size() == 1) {
                                pref = set.iterator().next();
                                if (!pref.equals(ChangeFilePropertiesWizard.this.newContentType.get(shareable))) {
                                    stillNotAsPredicted = shareable;
                                    break;
                                }
                                pref = null;
                                continue;
                            }
                            stillNotAsPredicted = shareable;
                            pref = null;
                        }
                        if (stillNotAsPredicted != null) {
                            String shareableName = stillNotAsPredicted.getLocalPath().getName();
                            if (pref != null) {
                                UpdatePreferencesPage.this.setErrorMessage(NLS.bind((String)Messages.ChangeFilePropertiesWizard_56, (Object[])new String[]{UpdatePreferencesPage.this.labelProvider.getColumnText(key, 0), pref, shareableName, (String)ChangeFilePropertiesWizard.this.newContentType.get(stillNotAsPredicted)}));
                            } else {
                                UpdatePreferencesPage.this.setErrorMessage(NLS.bind((String)Messages.ChangeFilePropertiesWizard_57, (Object)shareableName, ChangeFilePropertiesWizard.this.newContentType.get(stillNotAsPredicted)));
                            }
                        }
                    }
                    if (ok) {
                        UpdatePreferencesPage.this.setErrorMessage(null);
                        UpdatePreferencesPage.this.setPageComplete(true);
                    }
                }

                private boolean calculateSavePreferenceComplete(Object data, Set<String> set) {
                    if (set.size() > 1) {
                        UpdatePreferencesPage.this.setErrorMessage(UpdatePreferencesPage.this.makeErrorMessage(data, set));
                        UpdatePreferencesPage.this.setPageComplete(false);
                        return false;
                    }
                    return true;
                }
            });
            sashForm.setWeights(new int[]{1, 3});
            TableOrTreeResizer.addResizeListener(this.table);
            TableOrTreeResizer.addResizeListener(tree);
            Dialog.applyDialogFont((Control)composite);
            GridLayoutFactory.fillDefaults().extendedMargins(LayoutConstants2.getWizardPageMargins()).generateLayout(composite);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.team.filesystem.ide.ui.wizard_changefileproperties_update_preferences");
            this.setControl((Control)composite);
        }

        public void save(List<TableElement> errors) {
            for (Map.Entry<Object, Set<String>> entry : ((ChangeFilePropertiesWizard)ChangeFilePropertiesWizard.this).updatePreferencesPage.savePreference.entrySet()) {
                Object key = entry.getKey();
                ContentPropertiesPreference pref = null;
                String shortPath = null;
                String longPath = null;
                if (key instanceof IContentType) {
                    IContentType contentType = (IContentType)key;
                    pref = ChangeFilePropertiesWizard.this.manager.get(contentType, null);
                    longPath = shortPath = contentType.getName();
                } else if (key instanceof IShareable) {
                    IShareable shareable = (IShareable)key;
                    shortPath = shareable.getLocalPath().getName();
                    pref = ChangeFilePropertiesWizard.this.manager.get((IContentType)ChangeFilePropertiesWizard.this.shareableToEclipseContentType.get(shareable), shortPath);
                    longPath = shareable.getLocalPath().toString();
                } else if (key instanceof String) {
                    shortPath = (String)key;
                    pref = ChangeFilePropertiesWizard.this.manager.get(null, shortPath);
                    longPath = shortPath;
                }
                Set<String> set = entry.getValue();
                if (set.size() > 1) {
                    errors.add(new TableElement(shortPath, longPath, this.makeErrorMessage(entry.getKey(), set), "", 6));
                    continue;
                }
                if (set.size() != 1) continue;
                pref.setMimeType(set.iterator().next());
            }
            try {
                ChangeFilePropertiesWizard.this.manager.flush();
            }
            catch (BackingStoreException e) {
                ChangeFilePropertiesWizard.addExceptionMessage(errors, Messages.ChangeFilePropertiesWizard_59, e, 9);
            }
        }

        private void setCheckedElements(Object contentType) {
            HashSet<Object> checked = new HashSet<Object>();
            block0: for (Map.Entry<Object, Set<String>> entry : this.savePreference.entrySet()) {
                for (String string : entry.getValue()) {
                    if (!string.equals(contentType)) continue;
                    checked.add(entry.getKey());
                    continue block0;
                }
            }
            this.viewer.setCheckedElements(checked.toArray());
            TreeItem[] treeItemArray = this.viewer.getTree().getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContentType type;
                TreeItem item = treeItemArray[n2];
                if (item.getData() instanceof IContentType && (type = (IContentType)item.getData()).getId().equals("org.eclipse.core.runtime.text")) {
                    item.setGrayed(true);
                }
                ++n2;
            }
        }

        public IWizardPage getNextPage() {
            return null;
        }

        public void setInput(Set<String> contentTypes) {
            this.table.removeAll();
            for (String contentType : contentTypes) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(contentType);
                item.setData((Object)contentType);
            }
        }

        private String makeErrorMessage(Object data, Set<String> set) {
            StringBuilder builder = new StringBuilder();
            Iterator<String> iterator = set.iterator();
            while (true) {
                builder.append(iterator.next());
                if (!iterator.hasNext()) break;
                builder.append(Messages.ChangeFilePropertiesWizard_60);
            }
            return NLS.bind((String)Messages.ChangeFilePropertiesWizard_61, (Object)builder.toString(), (Object)this.labelProvider.getColumnText(data, 0));
        }
    }
}

