/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.autocommit;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.rcp.core.internal.IAutoCommitParticipant;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AutoCommitParticipant
implements IAutoCommitParticipant,
IPropertyChangeListener {
    private static final int SWT_KEYSTROKE_EVENT = 1;
    static Object TIMER_JOB_GROUP = "ACPTimer";
    private static int BLUR_TIMER_DELAY = 5000;
    long lastCommitTime = -1L;
    long lastCommitRequested = -1L;
    long lastBlurRequest = -1L;
    long lastKeystroke = -1L;
    private Object initLock = new Object();
    private boolean initialized = false;
    final IWindowListener windowListener = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            this.blur();
        }

        public void windowDeactivated(IWorkbenchWindow window) {
            this.blur();
        }

        public void windowOpened(IWorkbenchWindow window) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void blur() {
            Display d = Display.getCurrent();
            if (d == null) {
                return;
            }
            if (!AutoCommitParticipant.this.store.getBoolean("commit_on_blur")) {
                return;
            }
            IWindowListener iWindowListener = AutoCommitParticipant.this.windowListener;
            synchronized (iWindowListener) {
                AutoCommitParticipant.this.lastBlurRequest = System.currentTimeMillis();
            }
            d.timerExec(BLUR_TIMER_DELAY, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Display d = Display.getCurrent();
                    if (d == null) {
                        return;
                    }
                    IWindowListener iWindowListener = (this).AutoCommitParticipant.this.windowListener;
                    synchronized (iWindowListener) {
                        if ((this).AutoCommitParticipant.this.lastBlurRequest + (long)BLUR_TIMER_DELAY > System.currentTimeMillis()) {
                            return;
                        }
                    }
                    if (d.getFocusControl() == null) {
                        AutoCommitParticipant.this.workbenchBlur();
                    }
                }
            });
        }
    };
    final Listener keystrokeListener = new Listener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(Event event) {
            long now = System.currentTimeMillis();
            Listener listener = AutoCommitParticipant.this.keystrokeListener;
            synchronized (listener) {
                AutoCommitParticipant.this.lastKeystroke = now;
            }
        }
    };
    final IResourceChangeListener saveListener = new IResourceChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta[] deltas;
            3 var2_2 = this;
            synchronized (var2_2) {
                if (AutoCommitParticipant.this.lastCommitTime >= AutoCommitParticipant.this.lastCommitRequested) {
                    return;
                }
            }
            IResourceDelta[] iResourceDeltaArray = deltas = event.getDelta().getAffectedChildren();
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta delta = iResourceDeltaArray[n2];
                IResource resource = delta.getResource();
                IShareable shareable = (IShareable)resource.getAdapter(IShareable.class);
                if (shareable != null) {
                    try {
                        if (!shareable.shouldBeIgnored((IProgressMonitor)TempHelper.MONITOR)) {
                            AutoCommitParticipant.this.commit();
                            break;
                        }
                    }
                    catch (FileSystemException fileSystemException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
    };
    private static AutoCommitParticipant instance;
    IAutoCommitParticipant.IAutoCommitController controller;
    private final Object controllerLock = new Object();
    IPreferenceStore store = null;
    private Job commitJob = new Job(Messages.AutoCommitParticipant_AutocommitJobName){

        protected IStatus run(IProgressMonitor monitor) {
            IAutoCommitParticipant.IAutoCommitController controller = AutoCommitParticipant.this.getController();
            controller.commit(monitor);
            return Status.OK_STATUS;
        }
    };

    public static synchronized AutoCommitParticipant getInstance() {
        if (instance == null) {
            instance = new AutoCommitParticipant();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IAutoCommitParticipant.IAutoCommitController getController() {
        Object object = this.controllerLock;
        synchronized (object) {
            return this.controller;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        IWorkbench workbench;
        try {
            workbench = PlatformUI.getWorkbench();
        }
        catch (IllegalStateException e) {
            Object object = this.initLock;
            synchronized (object) {
                this.initialized = false;
            }
            return;
        }
        this.store = UiPlugin.getDefault().getPreferenceStore();
        this.store.addPropertyChangeListener((IPropertyChangeListener)this);
        if (!this.store.getBoolean("auto commit")) {
            return;
        }
        if (this.store.getBoolean("commit_on_save") && this.store.getInt("min_commit_interval") > 0) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.saveListener, 1);
        }
        if (this.store.getBoolean("commit_on_blur")) {
            workbench.addWindowListener(this.windowListener);
        }
        if (this.store.getBoolean("commit_interval_enabled")) {
            this.startTimerJob();
        } else {
            this.cancelTimerJob();
        }
        if (this.store.getInt("keyboard_idle_commit") > 0) {
            this.addKeystrokeListener();
        }
        Object object = this.initLock;
        synchronized (object) {
            this.initialized = true;
        }
    }

    private void addKeystrokeListener() {
        final Display d = this.getDisplay();
        if (d != null) {
            d.asyncExec(new Runnable(){

                @Override
                public void run() {
                    d.addFilter(1, AutoCommitParticipant.this.keystrokeListener);
                }
            });
        }
    }

    private void removeKeystrokeListener() {
        final Display d = this.getDisplay();
        if (d != null) {
            d.asyncExec(new Runnable(){

                @Override
                public void run() {
                    d.removeFilter(1, AutoCommitParticipant.this.keystrokeListener);
                }
            });
        }
    }

    private void startTimerJob() {
        this.cancelTimerJob();
        new TimerJob(){

            protected IStatus run(IProgressMonitor monitor) {
                AutoCommitParticipant.this.timerExpired(monitor);
                return Status.OK_STATUS;
            }
        }.schedule(60000L * this.store.getLong("max_commit_interval"));
    }

    private void cancelTimerJob() {
        Job.getJobManager().cancel(TIMER_JOB_GROUP);
    }

    private Display getDisplay() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Display d = null;
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        if (windows.length > 0 && windows[0] != null) {
            Shell shell = windows[0].getShell();
            if (shell == null || shell.isDisposed()) {
                return null;
            }
            d = shell.getDisplay();
            if (d.isDisposed()) {
                return null;
            }
        }
        return d;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        boolean autoCommitOn = this.store.getBoolean("auto commit");
        boolean isAutoCommitPref = "auto commit".equals(property);
        if (isAutoCommitPref || "commit_on_blur".equals(property)) {
            if (autoCommitOn && this.store.getBoolean("commit_on_blur")) {
                PlatformUI.getWorkbench().addWindowListener(this.windowListener);
            } else {
                PlatformUI.getWorkbench().removeWindowListener(this.windowListener);
            }
        }
        if (isAutoCommitPref || "commit_interval_enabled".equals(property) || "max_commit_interval".equals(property)) {
            if (autoCommitOn && this.store.getBoolean("commit_interval_enabled")) {
                this.startTimerJob();
            } else {
                this.cancelTimerJob();
            }
        }
        if (isAutoCommitPref || "keyboard_idle_commit".equals(property)) {
            this.removeKeystrokeListener();
            if (autoCommitOn && this.store.getInt("keyboard_idle_commit") > 0) {
                this.addKeystrokeListener();
            }
        }
        if (isAutoCommitPref || "commit_on_save".equals(property) || "min_commit_interval".equals(property)) {
            if (autoCommitOn && this.store.getBoolean("commit_on_save") && this.store.getInt("min_commit_interval") > 0) {
                ResourcesPlugin.getWorkspace().addResourceChangeListener(this.saveListener, 1);
            } else {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.saveListener);
            }
        }
    }

    private void workbenchBlur() {
        if (this.store.getBoolean("commit_on_blur")) {
            this.commit();
        }
    }

    private void timerExpired(IProgressMonitor progress) {
        if (this.store.getBoolean("commit_interval_enabled")) {
            if (this.timersAllowCommit()) {
                this.commit(progress);
            }
            this.startTimerJob();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean timersAllowCommit() {
        long interval = this.store.getLong("min_commit_interval") * 60L * 1000L;
        long now = System.currentTimeMillis();
        AutoCommitParticipant autoCommitParticipant = this;
        synchronized (autoCommitParticipant) {
            if (this.lastCommitTime + interval > now) {
                return false;
            }
        }
        if (this.store.getBoolean("commit_interval_enabled")) {
            long lastKey = -1L;
            Listener listener = this.keystrokeListener;
            synchronized (listener) {
                lastKey = this.lastKeystroke;
            }
            interval = (long)this.store.getInt("keyboard_idle_commit") * 1000L;
            if (lastKey + interval > now) {
                return false;
            }
        }
        return true;
    }

    private void commit() {
        this.commit(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(IProgressMonitor progress) {
        IAutoCommitParticipant.IAutoCommitController controller = this.getController();
        AutoCommitParticipant autoCommitParticipant = this;
        synchronized (autoCommitParticipant) {
            this.lastCommitTime = System.currentTimeMillis();
        }
        if (progress == null) {
            this.commitJob.schedule();
        } else if (controller != null) {
            controller.commit(progress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autocommitRequested(IAutoCommitParticipant.IAutoCommitRequest req) {
        Object object = this.initLock;
        synchronized (object) {
            if (!this.initialized) {
                req.allow();
                return;
            }
        }
        long now = System.currentTimeMillis();
        AutoCommitParticipant autoCommitParticipant = this;
        synchronized (autoCommitParticipant) {
            this.lastCommitRequested = now;
        }
        if (this.store.getBoolean("auto commit") && this.store.getBoolean("commit_on_save") && this.timersAllowCommit()) {
            req.allow();
            autoCommitParticipant = this;
            synchronized (autoCommitParticipant) {
                this.lastCommitTime = now;
            }
        } else {
            req.deny();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userCommitted() {
        AutoCommitParticipant autoCommitParticipant = this;
        synchronized (autoCommitParticipant) {
            this.lastCommitTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(IAutoCommitParticipant.IAutoCommitController controller) {
        Object object = this.controllerLock;
        synchronized (object) {
            this.controller = controller;
        }
        Display display = Display.getCurrent();
        if (display == null) {
            this.init();
        } else {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    AutoCommitParticipant.this.init();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstall() {
        IWorkbench workbench;
        try {
            workbench = PlatformUI.getWorkbench();
        }
        catch (IllegalStateException e) {
            workbench = null;
        }
        if (workbench != null) {
            workbench.removeWindowListener(this.windowListener);
            this.cancelTimerJob();
            this.removeKeystrokeListener();
        }
        try {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.saveListener);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (this.store != null) {
            this.store.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        Object object = this.controllerLock;
        synchronized (object) {
            this.controller = null;
        }
    }

    private static abstract class TimerJob
    extends Job {
        public TimerJob() {
            super("Timer");
            this.setSystem(true);
        }

        public boolean belongsTo(Object family) {
            return family == TIMER_JOB_GROUP;
        }
    }
}

