/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.teamplace;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.operations.IUnshareOperation;
import com.ibm.team.filesystem.client.operations.UnshareDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.ui.actions.teamplace.CommonAction;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnUnShareUser;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class UnloadAction
extends CommonAction {
    public void run(final Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        List<IWorkspaceHandle> workspaces = UnloadAction.getWorkspaceListFromSelection(selection);
        String message = workspaces.size() == 1 ? Messages.UnloadAction_UnloadWorkspaceDialogMessage : NLS.bind((String)Messages.UnloadAction_UnloadWorkspacesDialogMessage, (Object)workspaces.size());
        final UnshareWarningResults promptResults = UnloadAction.promptIfNeeded(shell, Messages.UnloadAction_ConfirmUnloadDialogTitle, message, workspaces, false, true);
        if (promptResults.isCancelled()) {
            return;
        }
        this.runOnSelection(selection, new CommonAction.ITeamPlaceRunnable(){

            @Override
            public IStatus run(IWorkspaceConnection stream, Object[] selected, IProgressMonitor monitor) {
                block4: {
                    try {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)(String.valueOf(Messages.UnloadAction_UnloadingProgressName) + stream.getName()), (int)1);
                        IWorkspace resolvedWorkspace = stream.getResolvedWorkspace();
                        FileSystemResourcesPlugin.getActiveWorkspaceManager().deactivate((IWorkspaceHandle)resolvedWorkspace);
                        List components = stream.getComponents();
                        if (components.size() <= 0) break block4;
                        IUnshareOperation op = IOperationFactory.instance.getUnshareOperation((UnshareDilemmaHandler)new WarnUnShareUser(shell, Messages.UnLoadAction_UnShareOperationTitle, promptResults.isDeleteContent()), IRepositoryResolver.EXISTING_SHARED);
                        op.requestUnshare((IConnection)stream, (Collection)components);
                        op.setDeleteContent(promptResults.isDeleteContent());
                        try {
                            op.run((IProgressMonitor)progress.newChild(1));
                        }
                        catch (OperationCanceledException e) {
                            FileSystemResourcesPlugin.getActiveWorkspaceManager().activate((IWorkspaceHandle)resolvedWorkspace);
                            throw e;
                        }
                    }
                    catch (TeamRepositoryException e) {
                        return StatusUtil.newStatus((Object)this, (Throwable)e);
                    }
                }
                return Status.OK_STATUS;
            }
        });
    }

    public static UnshareWarningResults promptIfNeeded(Shell shell, String title, String message, IStructuredSelection selection, boolean force, boolean deleteContent) {
        List<IWorkspaceHandle> workspaces = UnloadAction.getWorkspaceListFromSelection(selection);
        return UnloadAction.promptIfNeeded(shell, title, message, workspaces, force, deleteContent);
    }

    public static UnshareWarningResults promptIfNeeded(Shell shell, String title, String message, List<? extends IWorkspaceHandle> workspaces, boolean force, boolean deleteContent) {
        boolean cancelled = false;
        boolean hasLoadedProjects = UnloadAction.hasLoadedProjects(workspaces);
        if (hasLoadedProjects) {
            UnshareWarningDialog d = new UnshareWarningDialog(shell, title, message, deleteContent);
            int code = d.open();
            if (code != 0) {
                cancelled = true;
            }
            deleteContent = d.getDeleteContent();
        } else if (force) {
            cancelled = !DialogUtil.openQuestionDialog(shell, title, message, false);
            deleteContent = false;
        }
        return new UnshareWarningResults(deleteContent, cancelled);
    }

    public static boolean hasLoadedProjects(List<? extends IWorkspaceHandle> workspaces) {
        for (IWorkspaceHandle iWorkspaceHandle : workspaces) {
            try {
                if (!FileSystemCore.getSharingManager().isConnectionShared((IContextHandle)iWorkspaceHandle)) continue;
                return true;
            }
            catch (FileSystemException e) {
                StatusUtil.log(UnloadAction.class, (String)"Error finding loaded repository workspaces", (Throwable)e);
                return true;
            }
        }
        return false;
    }

    @Override
    protected String getOperationName() {
        return Messages.UnloadAction_UnloadingWorkspacesJobName;
    }

    public static UnshareDilemmaHandler getUnshareDilemmaHandler() {
        return new UnshareDilemmaHandler(){

            public int emptySandbox(Collection<ISandbox> emptySandboxes) {
                return 0;
            }
        };
    }

    public static class UnshareWarningDialog
    extends MessageDialog {
        private boolean deleteContent;
        private Button radio1;
        private Button radio2;
        private SelectionListener selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    deleteContent = button == radio1;
                }
            }
        };

        public UnshareWarningDialog(Shell parentShell, String title, String message, boolean deleteContent) {
            super(parentShell, title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
            this.deleteContent = deleteContent;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
        }

        protected Control createCustomArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.radio1 = new Button(composite, 16);
            this.radio1.addSelectionListener(this.selectionListener);
            String text1 = Messages.UnloadAction_DeleteProjectsRadioButton;
            this.radio1.setText(text1);
            this.radio1.setFont(parent.getFont());
            this.radio2 = new Button(composite, 16);
            this.radio2.addSelectionListener(this.selectionListener);
            String text2 = Messages.UnloadAction_DisconnectProjectsRadioButton;
            this.radio2.setText(text2);
            this.radio2.setFont(parent.getFont());
            this.radio1.setSelection(this.deleteContent);
            this.radio2.setSelection(!this.deleteContent);
            return composite;
        }

        public boolean getDeleteContent() {
            return this.deleteContent;
        }
    }

    public static class UnshareWarningResults {
        private boolean deleteContent;
        private boolean cancelled;

        public UnshareWarningResults(boolean deleteContent, boolean cancelled) {
            this.deleteContent = deleteContent;
            this.cancelled = cancelled;
        }

        public boolean isDeleteContent() {
            return this.deleteContent;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }
    }
}

