/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.teamplace;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.operations.ReplaceWithRepositoryOperation;
import com.ibm.team.filesystem.client.internal.operations.UndoChangesOperation;
import com.ibm.team.filesystem.client.operations.ReplaceDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UndoDilemmaHandler;
import com.ibm.team.filesystem.client.util.ConnectionUtil;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnReplaceUser;
import com.ibm.team.internal.filesystem.ui.util.WarnUndoUser;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class UndoAction
extends AbstractActionDelegate {
    public void run(final Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        String confirmationDescription;
        final ArrayList shareables = NewCollection.arrayList();
        for (Object next : selection.toList()) {
            IShareable nextShareable = (IShareable)Adapters.getAdapter(next, IShareable.class);
            if (nextShareable == null) continue;
            shareables.add(nextShareable);
        }
        String confirmationTitle = Messages.UndoAction_0;
        String string = confirmationDescription = shareables.size() == 1 ? Messages.UndoAction_CONFIRMATION_SINGLE : Messages.UndoAction_CONFIRMATION_PLURAL;
        if (!MessageDialogFactory.confirm((Shell)shell, (String)confirmationTitle, (String)confirmationDescription)) {
            return;
        }
        final String name = Messages.UndoAction_UndoingChangesJobName;
        this.getOperationRunner().enqueue(name, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                Map shareablesByLocation = CoreShareablesUtil.groupByContributorPlace((Collection)shareables, (IProgressMonitor)progress.newChild(1));
                progress.setWorkRemaining(shareablesByLocation.size());
                for (Map.Entry next : shareablesByLocation.entrySet()) {
                    List shareables2 = (List)next.getValue();
                    ItemNamespace namespace = (ItemNamespace)next.getKey();
                    SubMonitor iterationProgress = progress.newChild(1).setWorkRemaining(100);
                    IConnection nextConnection = namespace.getConnection((IProgressMonitor)iterationProgress.newChild(5));
                    ItemId component = namespace.fetchComponentId((IProgressMonitor)iterationProgress.newChild(5));
                    if (!(nextConnection instanceof IWorkspaceConnection)) continue;
                    IWorkspaceConnection wc = (IWorkspaceConnection)nextConnection;
                    FileSystemCore.getFileSystemManager((ITeamRepository)wc.teamRepository()).getFileSystemView((IConnection)wc);
                    List activeChanges = ConnectionUtil.getActiveChangeSets((IWorkspaceConnection)wc, (ItemId)component);
                    Collection activeChangeSets = RepoFetcher.fetchCurrents((ITeamRepository)wc.teamRepository(), (Collection)activeChanges, (IProgressMonitor)iterationProgress.newChild(10)).values();
                    HashMap shareablesToDiscard = NewCollection.hashMap();
                    SubMonitor subProgress = iterationProgress.newChild(5).setWorkRemaining(shareables2.size());
                    for (IShareable shareable : shareables2) {
                        IVersionableHandle handle = shareable.getVersionable((IProgressMonitor)subProgress.newChild(1));
                        if (handle == null) continue;
                        ItemId versionable = new ItemId((IItemHandle)handle);
                        shareablesToDiscard.put(versionable, shareable);
                    }
                    UndoChangesOperation undoOp = UndoAction.this.prepareUndo(wc, activeChangeSets, shareablesToDiscard, new WarnUndoUser(shell, name, false));
                    if (undoOp != null) {
                        if (shareablesToDiscard.isEmpty()) {
                            iterationProgress.setWorkRemaining(75);
                        } else {
                            iterationProgress.setWorkRemaining(100);
                        }
                        undoOp.run((IProgressMonitor)iterationProgress.newChild(75));
                    }
                    if (shareablesToDiscard.isEmpty()) continue;
                    iterationProgress.setWorkRemaining(100);
                    new ReplaceWithRepositoryOperation(shareablesToDiscard.values(), IRepositoryResolver.EXISTING_SHARED, 0, (ReplaceDilemmaHandler)new WarnReplaceUser(shell, name)).run((IProgressMonitor)iterationProgress.newChild(100));
                }
            }
        });
    }

    private UndoChangesOperation prepareUndo(IWorkspaceConnection wc, Collection<IChangeSet> activeChangeSets, Map<ItemId, IShareable> shareablesToDiscard, UndoDilemmaHandler undoProblemHandler) {
        UndoChangesOperation undoOp = null;
        for (IChangeSet changeSet : activeChangeSets) {
            for (Object o : changeSet.changes()) {
                IChange change;
                ItemId key;
                if (!(o instanceof IChange) || !shareablesToDiscard.containsKey(key = new ItemId((IItemHandle)(change = (IChange)o).item()))) continue;
                if (undoOp == null) {
                    undoOp = new UndoChangesOperation(wc, undoProblemHandler);
                }
                undoOp.addChangesToUndo((IChangeSetHandle)changeSet, Collections.singleton(change));
                shareablesToDiscard.remove(key);
            }
        }
        return undoOp;
    }

    public static Map<ItemId, IRemoteChangeSummary> getOutgoingChanges(IComponentSyncContext componentSyncContext) {
        HashMap allChanges = NewCollection.hashMap();
        IOutgoingActivitySource outgoingActivitySource = componentSyncContext.getOutgoingActivitySource();
        for (Object activity : outgoingActivitySource.getActivities()) {
            if (!(activity instanceof IRemoteActivity)) continue;
            IRemoteActivity remoteActivity = (IRemoteActivity)activity;
            for (Object changeSummary : remoteActivity.getChanges()) {
                if (!(changeSummary instanceof IRemoteChangeSummary)) continue;
                IRemoteChangeSummary nextChange = (IRemoteChangeSummary)changeSummary;
                ItemId nextItem = new ItemId((IItemHandle)nextChange.getItem());
                allChanges.put(nextItem, nextChange);
            }
        }
        return allChanges;
    }
}

