/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.teamplace;

import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class ShowWorkspaceInPendingChangesAction
extends AbstractActionDelegate {
    public void run(Shell shell, final IWorkbenchPage page, IStructuredSelection sel) {
        final Display display = shell.getDisplay();
        final HashMap<ITeamRepository, Set<ContributorPlaceWrapper>> allContributorPlaces = new HashMap<ITeamRepository, Set<ContributorPlaceWrapper>>();
        for (Object object : sel.toList()) {
            if (object == null || !Adapters.hasAdapter(object, ContributorPlaceWrapper.class)) {
                return;
            }
            ContributorPlaceWrapper wrapper = (ContributorPlaceWrapper)((Object)Adapters.getAdapter(object, ContributorPlaceWrapper.class));
            if (wrapper.getRepository() == null) continue;
            this.addContributorPlace(allContributorPlaces, wrapper.getRepository(), wrapper);
        }
        this.getOperationRunner().enqueue(Messages.ShowWorkspaceInPendingChangesAction_0, (Operation)new RepositoryOperation(allContributorPlaces.keySet()){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)allContributorPlaces.size());
                for (Map.Entry entry : allContributorPlaces.entrySet()) {
                    Set contributorPlaces = (Set)entry.getValue();
                    SubMonitor loopProgress = progress.newChild(1).setWorkRemaining(contributorPlaces.size());
                    for (ContributorPlaceWrapper contributorPlace : contributorPlaces) {
                        FileSystemResourcesPlugin.getActiveWorkspaceManager().activate((IWorkspaceHandle)contributorPlace.getWorkspace());
                        loopProgress.worked(1);
                    }
                }
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            page.showView("com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView");
                        }
                        catch (PartInitException e) {
                            StatusUtil.log((Object)this, (Throwable)e);
                        }
                    }
                });
            }
        });
    }

    private void addContributorPlace(Map<ITeamRepository, Set<ContributorPlaceWrapper>> contributorPlaceMap, ITeamRepository repo, ContributorPlaceWrapper contributorPlace) {
        Set<ContributorPlaceWrapper> currentContributorPlaces = null;
        if (contributorPlaceMap.containsKey(repo)) {
            currentContributorPlaces = contributorPlaceMap.get(repo);
        }
        if (currentContributorPlaces == null) {
            currentContributorPlaces = new HashSet<ContributorPlaceWrapper>();
        }
        currentContributorPlaces.add(contributorPlace);
        contributorPlaceMap.put(repo, currentContributorPlaces);
    }
}

