/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.teamplace;

import com.ibm.team.filesystem.client.internal.utils.FlowTableUtil;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.ui.wrapper.TeamPlaceWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class ShowStreamInPendingChangesAction
extends AbstractActionDelegate {
    public void run(Shell shell, final IWorkbenchPage page, IStructuredSelection sel) {
        final Display display = shell.getDisplay();
        final HashMap<ITeamRepository, Set<TeamPlaceWrapper>> allTeamPlaces = new HashMap<ITeamRepository, Set<TeamPlaceWrapper>>();
        for (Object object : sel.toList()) {
            if (object == null || !Adapters.hasAdapter(object, TeamPlaceWrapper.class)) {
                return;
            }
            TeamPlaceWrapper wrapper = (TeamPlaceWrapper)((Object)Adapters.getAdapter(object, TeamPlaceWrapper.class));
            if (wrapper.getRepository() == null) continue;
            this.addTeamPlace(allTeamPlaces, wrapper.getRepository(), wrapper);
        }
        this.getOperationRunner().enqueue(Messages.ShowStreamInPendingChangesAction_0, (Operation)new RepositoryOperation(allTeamPlaces.keySet()){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)allTeamPlaces.size());
                final HashSet<IWorkspaceConnection> noFlowTargets = new HashSet<IWorkspaceConnection>();
                for (Map.Entry entry : allTeamPlaces.entrySet()) {
                    Set teamPlaces = (Set)entry.getValue();
                    SubMonitor loopProgress = progress.newChild(1).setWorkRemaining(teamPlaces.size());
                    for (TeamPlaceWrapper teamPlace : teamPlaces) {
                        IWorkspaceConnection wc = teamPlace.getWorkspaceConnection((IProgressMonitor)loopProgress.newChild(1));
                        if (!FlowTableUtil.hasCollaboration((IWorkspaceConnection)wc)) {
                            noFlowTargets.add(wc);
                            continue;
                        }
                        FileSystemResourcesPlugin.getActiveWorkspaceManager().activate((IWorkspaceHandle)teamPlace.getWorkspace());
                    }
                }
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (noFlowTargets.size() > 0) {
                            if (noFlowTargets.size() == 1) {
                                IWorkspaceConnection wc = (IWorkspaceConnection)noFlowTargets.iterator().next();
                                JFaceUtils.showMessageBlocking((String)Messages.ShowStreamInPendingChangesAction_1, (String)NLS.bind((String)Messages.ShowStreamInPendingChangesAction_2, (Object)wc.getName()), (String[])new String[]{IDialogConstants.OK_LABEL}, (int)4);
                            } else {
                                JFaceUtils.showMessageBlocking((String)Messages.ShowStreamInPendingChangesAction_3, (String)Messages.ShowStreamInPendingChangesAction_4, (String[])new String[]{IDialogConstants.OK_LABEL}, (int)4);
                            }
                        }
                        try {
                            page.showView("com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView");
                        }
                        catch (PartInitException e) {
                            StatusUtil.log((Object)this, (Throwable)e);
                        }
                    }
                });
            }
        });
    }

    private void addTeamPlace(Map<ITeamRepository, Set<TeamPlaceWrapper>> teamPlacesMap, ITeamRepository repo, TeamPlaceWrapper teamPlace) {
        Set<TeamPlaceWrapper> currentTeamPlaces = null;
        if (teamPlacesMap.containsKey(repo)) {
            currentTeamPlaces = teamPlacesMap.get(repo);
        }
        if (currentTeamPlaces == null) {
            currentTeamPlaces = new HashSet<TeamPlaceWrapper>();
        }
        currentTeamPlaces.add(teamPlace);
        teamPlacesMap.put(repo, currentTeamPlaces);
    }
}

