/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.teamplace;

import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.ui.utils.MnemonicGenerator;
import com.ibm.team.scm.common.IWorkspace;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SafelyDeleteStreamDialog
extends MessageDialog {
    ITeamRepository repo;
    private Button radio1;
    private Button radio2;
    private volatile boolean doBackup = true;
    List<IWorkspace> toDelete;
    Shell shell;
    AbstractPlaceWrapper peer;

    public SafelyDeleteStreamDialog(Shell shell, ITeamRepository repo, List<IWorkspace> toDelete) {
        super(shell, SafelyDeleteStreamDialog.getTitle(), null, SafelyDeleteStreamDialog.getMessage(toDelete), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        this.shell = shell;
        this.repo = repo;
        this.toDelete = toDelete;
    }

    static String getTitle() {
        return Messages.SafelyDeleteStreamDialog_6;
    }

    static String getMessage(List<IWorkspace> toDelete) {
        String message = toDelete.size() > 1 ? NLS.bind((String)Messages.SafelyDeleteStreamDialog_0, (Object)toDelete.size()) : NLS.bind((String)Messages.SafelyDeleteStreamDialog_1, (Object)toDelete.get(0).getName());
        return message;
    }

    void resetButtons(final Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        MnemonicGenerator mnemonicGen = new MnemonicGenerator(true);
        this.radio1 = new Button(composite, 16);
        String text = this.peer != null ? NLS.bind((String)Messages.SafelyDeleteStreamDialog_5, (Object)this.peer.getWorkspace().getName()) : Messages.SafelyDeleteStreamDialog_4;
        this.radio1.setText(mnemonicGen.generate(text));
        final Button browse = new Button(composite, 8);
        browse.setText(mnemonicGen.generate(Messages.SafelyDeleteStreamDialog_8));
        browse.setEnabled(this.doBackup);
        GridDataFactory.defaultsFor((Control)browse).align(0x1000008, 0x1000000).grab(true, false).applyTo((Control)browse);
        this.radio2 = new Button(composite, 16);
        this.radio2.setText(mnemonicGen.generate(Messages.SafelyDeleteStreamDialog_2));
        GridDataFactory.defaultsFor((Control)browse).span(2, 1).applyTo((Control)this.radio2);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(composite);
        this.radio1.setSelection(this.doBackup);
        this.radio2.setSelection(!this.doBackup);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    SafelyDeleteStreamDialog.this.doBackup = button == SafelyDeleteStreamDialog.this.radio1;
                    browse.setEnabled(SafelyDeleteStreamDialog.this.doBackup);
                    SafelyDeleteStreamDialog.this.enableButtons();
                }
            }
        };
        this.radio1.addSelectionListener((SelectionListener)selectionListener);
        this.radio2.addSelectionListener((SelectionListener)selectionListener);
        browse.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AbstractPlaceWrapper selection = WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream(SafelyDeleteStreamDialog.this.shell, SafelyDeleteStreamDialog.this.repo, SafelyDeleteStreamDialog.this.toDelete);
                if (selection != null) {
                    SafelyDeleteStreamDialog.this.peer = selection;
                    SafelyDeleteStreamDialog.this.resetButtons(composite);
                    Point pt = composite.getShell().computeSize(-1, -1, true);
                    composite.getShell().setSize(pt);
                    SafelyDeleteStreamDialog.this.shell.layout();
                    composite.layout();
                    SafelyDeleteStreamDialog.this.enableButtons();
                }
            }
        });
    }

    protected Control createCustomArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.resetButtons(composite);
        return composite;
    }

    void enableButtons() {
        this.getButton(0).setEnabled(!this.doBackup || this.peer != null);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.enableButtons();
    }

    public AbstractPlaceWrapper getWorkspace() {
        return this.doBackup ? this.peer : null;
    }
}

