/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.teamplace;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.operations.IUnshareOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.UnshareDilemmaHandler;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.actions.teamplace.CommonAction;
import com.ibm.team.filesystem.ui.actions.teamplace.UnloadAction;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnUnShareUser;
import com.ibm.team.internal.filesystem.ui.util.WarnUpdateUser;
import com.ibm.team.internal.filesystem.ui.util.WarnWorkspaceUpdate;
import com.ibm.team.internal.filesystem.ui.util.WorkspaceUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IComponentHierarchyResult;
import com.ibm.team.scm.common.internal.subcomponents.SubcomponentCommonUtils;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class RemoveComponentsInContributorPlaceAction
extends CommonAction {
    @Override
    protected boolean isEnabled() {
        IStructuredSelection selection = this.getStructuredSelection();
        IWorkspaceConnection wc = null;
        for (Object o : selection.toList()) {
            if (!(o instanceof ContributorPlaceComponentWrapper)) continue;
            ContributorPlaceComponentWrapper wrapper = (ContributorPlaceComponentWrapper)o;
            if (wc == null) {
                wc = wrapper.getWorkspaceConnection();
                continue;
            }
            if (wrapper.getWorkspaceConnection() == wc) continue;
            return false;
        }
        return super.isEnabled();
    }

    public void run(final Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        final Map selectedComponentsToRemove = NewCollection.hashMap((int)selection.size());
        final HashMap subcomponentsToRemove = NewCollection.hashMap();
        final Map selectedComponentsWithSubcomponents = NewCollection.hashMap((int)selection.size());
        for (Object o : selection.toList()) {
            if (!(o instanceof ContributorPlaceComponentWrapper)) continue;
            ContributorPlaceComponentWrapper wrapper = (ContributorPlaceComponentWrapper)o;
            selectedComponentsToRemove.put(wrapper.getItem().getItemId(), wrapper);
        }
        this.runOnSelection(selection, new CommonAction.TeamPlaceRunnable(){

            @Override
            public IStatus run(IWorkspaceConnection workspaceConnection, Object[] selection, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
                HashMap<UUID, IComponentHandle> componentsInWorkspace = new HashMap<UUID, IComponentHandle>();
                for (Object o : workspaceConnection.getComponents()) {
                    if (!(o instanceof IComponentHandle)) continue;
                    IComponentHandle component = (IComponentHandle)o;
                    componentsInWorkspace.put(component.getItemId(), component);
                }
                IComponentHierarchyResult hierarchy = workspaceConnection.getComponentHierarchy(null);
                Map parentToChildMap = hierarchy.getParentToChildrenMap();
                for (Map.Entry entry : selectedComponentsToRemove.entrySet()) {
                    Collection children = (Collection)parentToChildMap.get(entry.getKey());
                    if (children == null || children.isEmpty()) continue;
                    selectedComponentsWithSubcomponents.put((UUID)entry.getKey(), (WorkspaceComponentWrapper)entry.getValue());
                }
                Collection childrenToRemove = SubcomponentCommonUtils.determineUniqueHierarchy(selectedComponentsToRemove.keySet(), (Map)hierarchy.getParentToChildrenMap());
                childrenToRemove.removeAll(selectedComponentsToRemove.keySet());
                ArrayList<IComponentHandle> toFetch = new ArrayList<IComponentHandle>();
                for (UUID id : childrenToRemove) {
                    IComponentHandle child = (IComponentHandle)componentsInWorkspace.get(id);
                    if (child == null) continue;
                    toFetch.add(child);
                }
                IFetchResult fetchResult = workspaceConnection.teamRepository().itemManager().fetchCompleteItemsPermissionAware(toFetch, 0, monitor);
                for (Object retrievedItem : fetchResult.getRetrievedItems()) {
                    if (!(retrievedItem instanceof IComponent)) continue;
                    IComponent component = (IComponent)retrievedItem;
                    WorkspaceComponentWrapper wrapper = WorkspaceComponentWrapper.newWrapper(workspaceConnection, component);
                    subcomponentsToRemove.put(wrapper.getComponent().getItemId(), wrapper);
                }
                return Status.OK_STATUS;
            }

            @Override
            public IStatus run(Map<ITeamRepository, Map<IWorkspaceConnection, Object[]>> selection, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
                IStatus result = super.run(selection, monitor);
                shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!selectedComponentsWithSubcomponents.isEmpty() && !RemoveComponentsInContributorPlaceAction.this.shouldContinueWithNoBackupBaseline(shell, selectedComponentsWithSubcomponents)) {
                            return;
                        }
                        IOperationRunner runner = RemoveComponentsInContributorPlaceAction.this.getOperationRunner();
                        RemoveComponentsInContributorPlaceAction.removeComponents(shell, new HashSet<WorkspaceComponentWrapper>(selectedComponentsToRemove.values()), new HashSet<WorkspaceComponentWrapper>(subcomponentsToRemove.values()), runner);
                    }
                });
                return result;
            }
        });
    }

    private boolean shouldContinueWithNoBackupBaseline(Shell shell, Map<UUID, WorkspaceComponentWrapper> selectedComponentsWithSubcomponents) {
        boolean shouldContinueToRemoveComponents = true;
        if (!selectedComponentsWithSubcomponents.isEmpty()) {
            IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
            String prefKey = "warn_no_backup_baseline_before_remove";
            boolean prompt = store.getBoolean("warn_no_backup_baseline_before_remove");
            if (prompt) {
                String dialogMessage;
                String dialogTitle = WarnWorkspaceUpdate.getNoBackupBaselineForRemoveTitle();
                if (selectedComponentsWithSubcomponents.size() == 1) {
                    WorkspaceComponentWrapper component = selectedComponentsWithSubcomponents.values().iterator().next();
                    dialogMessage = WarnWorkspaceUpdate.getNoBackupBaselineForRemoveSingleMessage(component.getComponent());
                } else {
                    dialogMessage = WarnWorkspaceUpdate.getNoBackupBaselineForRemovePluralMessage();
                }
                String[] yesNoButtons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
                MessageDialogWithToggle dialog = new MessageDialogWithToggle(shell, dialogTitle, null, dialogMessage, 4, yesNoButtons, 1, Messages.PreferencesListener_18, false);
                dialog.open();
                if (dialog.getReturnCode() == 2) {
                    store.setValue("warn_no_backup_baseline_before_remove", !dialog.getToggleState());
                } else {
                    shouldContinueToRemoveComponents = false;
                }
            }
        }
        return shouldContinueToRemoveComponents;
    }

    @Override
    protected String getOperationName() {
        return Messages.DeleteComponentsInContributorPlaceAction_DeleteComponentsJobName;
    }

    public static void removeComponents(final Shell shell, Set<WorkspaceComponentWrapper> selectedComponentsToRemove, Set<WorkspaceComponentWrapper> subcomponentsToRemove, IOperationRunner runner) {
        String message;
        final HashSet<WorkspaceComponentWrapper> allComponentsToRemove = new HashSet<WorkspaceComponentWrapper>(selectedComponentsToRemove.size() + subcomponentsToRemove.size());
        allComponentsToRemove.addAll(selectedComponentsToRemove);
        allComponentsToRemove.addAll(subcomponentsToRemove);
        if (subcomponentsToRemove.isEmpty()) {
            message = selectedComponentsToRemove.size() == 1 ? Messages.DeleteComponentsInContributorPlaceAction_DeleteComponentDialogMessage : NLS.bind((String)Messages.DeleteComponentsInContributorPlaceAction_DeleteComponentsDialogMessage, (Object)selectedComponentsToRemove.size());
        } else if (selectedComponentsToRemove.size() == 1) {
            if (subcomponentsToRemove.size() == 1) {
                WorkspaceComponentWrapper selectedWrapper = selectedComponentsToRemove.iterator().next();
                WorkspaceComponentWrapper subComponentWrapper = subcomponentsToRemove.iterator().next();
                message = NLS.bind((String)Messages.RemoveComponentsInContributorPlaceAction_RemoveComponentHierarchyDialogMessage1, (Object)selectedWrapper.getComponent().getName(), (Object)subComponentWrapper.getComponent().getName());
            } else {
                message = NLS.bind((String)Messages.RemoveComponentsInContributorPlaceAction_RemoveComponentHierarchyDialogMessage2, (Object)subcomponentsToRemove.size());
            }
        } else {
            message = NLS.bind((String)Messages.RemoveComponentsInContributorPlaceAction_RemoveComponentHierarchyDialogMessage3, (Object)selectedComponentsToRemove.size());
        }
        final UnloadAction.UnshareWarningResults promptResults = UnloadAction.promptIfNeeded(shell, Messages.DeleteComponentsInContributorPlaceAction_ConfirmDeleteDialogTitle, message, (IStructuredSelection)new StructuredSelection(allComponentsToRemove), true, false);
        if (promptResults.isCancelled()) {
            return;
        }
        if (RemoveComponentsInContributorPlaceAction.cancelDeleteForOutgoingChanges(shell, allComponentsToRemove)) {
            return;
        }
        final String jobName = Messages.DeleteComponentsInContributorPlaceAction_DeletingComponentsJobName;
        runner.enqueue(jobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                WarnUpdateUser problemHandler = new WarnUpdateUser(shell, jobName);
                IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(problemHandler.getOutOfSyncDilemmaHandler());
                ArrayList ops = NewCollection.arrayList();
                ArrayList componentHandles = NewCollection.arrayList();
                IWorkspaceConnection connection = ((WorkspaceComponentWrapper)allComponentsToRemove.iterator().next()).getWorkspaceConnection();
                for (WorkspaceComponentWrapper wrapper : allComponentsToRemove) {
                    if (wrapper.getWorkspaceConnection() != connection) continue;
                    ops.add(connection.componentOpFactory().removeComponent((IComponentHandle)wrapper.getComponent(), false));
                    verifyOp.addToVerify((IConnection)connection, (IComponentHandle)wrapper.getComponent());
                    componentHandles.add(wrapper.getComponent());
                }
                verifyOp.run((IProgressMonitor)progress.newChild(25));
                IUnshareOperation op = IOperationFactory.instance.getUnshareOperation((UnshareDilemmaHandler)new WarnUnShareUser(shell, Messages.DeleteComponentsInContributorPlaceAction_UnShareOperationTitle, promptResults.isDeleteContent()), IRepositoryResolver.EXISTING_SHARED);
                op.requestUnshare((IConnection)connection, (Collection)componentHandles);
                op.setDeleteContent(promptResults.isDeleteContent());
                op.run((IProgressMonitor)progress.newChild(1));
                connection.applyComponentOperations((List)ops, (IProgressMonitor)progress.newChild(25));
            }
        });
    }

    private static boolean cancelDeleteForOutgoingChanges(Shell shell, Set<WorkspaceComponentWrapper> componentWrappers) {
        if (RemoveComponentsInContributorPlaceAction.hasOutgoingChanges(componentWrappers)) {
            String message = componentWrappers.size() == 1 ? Messages.DeleteComponentsInContributorPlaceAction_ComponentOutgoingChangeSetsDialogMessage : Messages.DeleteComponentsInContributorPlaceAction_ComponentsOutgoingChangeSetsDialogMessage;
            return !DialogUtil.openConfirm(shell, Messages.DeleteComponentsInContributorPlaceAction_ConfirmDeleteDialogTitle, message, false);
        }
        return false;
    }

    private static boolean hasOutgoingChanges(Set<WorkspaceComponentWrapper> componentWrappers) {
        for (WorkspaceComponentWrapper componentWrapper : componentWrappers) {
            if (!WorkspaceUtil.hasUndeliveredChanges(componentWrapper, false)) continue;
            return true;
        }
        return false;
    }
}

