/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.teamplace;

import com.ibm.team.containers.common.IItemContainer;
import com.ibm.team.containers.common.IItemContainerHandle;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.domain.MyWorkspacesDomain;
import com.ibm.team.filesystem.ui.item.Repositories;
import com.ibm.team.filesystem.ui.queries.FolderNode;
import com.ibm.team.filesystem.ui.queries.RepositoryNode;
import com.ibm.team.filesystem.ui.queries.ScmAllDomainNode;
import com.ibm.team.filesystem.ui.queries.WorkspacesDomainNode;
import com.ibm.team.filesystem.ui.views.TeamPlaceEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlacePart2;
import com.ibm.team.filesystem.ui.wizards.newworkspace.NewWorkspaceWizard;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorWrapper;
import com.ibm.team.filesystem.ui.wrapper.RawSnapshotWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.operations.AddToFolderOperation;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.common.IWorkspace;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class NewWorkspaceAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection sel) {
        Object element = sel.getFirstElement();
        if (element != null && Adapters.hasAdapter((Object)element, RawSnapshotWrapper.class)) {
            RawSnapshotWrapper snapshot = (RawSnapshotWrapper)((Object)Adapters.getAdapter((Object)element, RawSnapshotWrapper.class));
            ContributorWrapper contributor = new ContributorWrapper(snapshot.getRepository().loggedInContributor());
            TeamPlacePart2.open(page, TeamPlaceEditorInput.newWorkspace().setOwner(contributor).setRepository(snapshot.getRepository()).setOriginalSnapshot(snapshot.getSnapshot()));
        } else {
            Object node;
            ITeamRepository initialRepo = null;
            IItemContainer parent = null;
            IContributor owner = null;
            if (element instanceof DomainSubtreeRoot) {
                DomainSubtreeRoot root = (DomainSubtreeRoot)element;
                Object categoryElement = root.getCategoryElement();
                if (categoryElement instanceof IProjectAreaHandle) {
                    IProjectAreaHandle pah = (IProjectAreaHandle)categoryElement;
                    initialRepo = Repositories.getRepository((IItemHandle)pah);
                    parent = null;
                    owner = null;
                } else if (root.getDomain() instanceof MyWorkspacesDomain) {
                    initialRepo = Repositories.getDefaultRepository();
                    parent = null;
                    if (initialRepo != null) {
                        owner = initialRepo.loggedInContributor();
                    }
                }
            } else if (element instanceof WorkspacesDomainNode) {
                node = (WorkspacesDomainNode)element;
                initialRepo = ((ScmAllDomainNode)node).getRepository();
            } else if (element instanceof RepositoryNode) {
                node = (RepositoryNode)element;
                initialRepo = ((RepositoryNode)node).getRepository();
                parent = null;
                owner = ((RepositoryNode)node).getRepository().loggedInContributor();
            } else if (element instanceof FolderNode) {
                node = (FolderNode)element;
                initialRepo = ((FolderNode)node).getRepo();
                parent = ((FolderNode)node).getItem();
                owner = ((FolderNode)node).getOwner();
            }
            NewWorkspaceWizard wizard = new NewWorkspaceWizard(this.getContext(), initialRepo, true, this.getAddChildHandler((IItemHandle)owner, (IItemContainerHandle)parent, initialRepo));
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            if (dialog.open() != 0) {
                return;
            }
        }
    }

    IPartResult<AbstractPlaceWrapper> getAddChildHandler(final IItemHandle owner, final IItemContainerHandle parent, final ITeamRepository initialRepo) {
        return new IPartResult<AbstractPlaceWrapper>(){

            public void setResult(AbstractPlaceWrapper wrapper) {
                if (wrapper == null || owner == null && parent == null) {
                    return;
                }
                final IWorkspace workspace = wrapper.getWorkspace();
                if (workspace == null) {
                    throw new IllegalStateException("Wrapper should contain a Workspace");
                }
                if (!workspace.getOrigin().equals(initialRepo)) {
                    return;
                }
                NewWorkspaceAction.this.getOperationRunner().enqueue(NewWorkspaceAction.this.getOperationName(), (Operation)new RepositoryOperation(){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                        try {
                            AddToFolderOperation operation = new AddToFolderOperation();
                            operation.add(owner, parent, (IItem)workspace);
                            operation.run(monitor, problems);
                        }
                        catch (Exception e) {
                            DialogUtil.openError(NewWorkspaceAction.this.getContext().getShell(), Messages.NewWorkspaceAction_noFolderPermissionTitle, Messages.NewWorkspaceAction_noFolderPermissionMessage);
                            throw e;
                        }
                    }
                });
            }
        };
    }

    private String getOperationName() {
        return Messages.NewWorkspaceOperation_creating;
    }
}

